# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190111

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.usage.src.oci_cli_usage.generated import usage_service_cli


@click.command(cli_util.override('resources.resources_root_group.command_name', 'resources'), cls=CommandGroupWithAlias, help=cli_util.override('resources.resources_root_group.help', """Use the Usage Proxy API to list Oracle Support Rewards, view related detailed usage information, and manage users who redeem rewards. For more information, see [Oracle Support Rewards Overview]."""), short_help=cli_util.override('resources.resources_root_group.short_help', """Usage Proxy API"""))
@cli_util.help_option_group
def resources_root_group():
    pass


@click.command(cli_util.override('resources.resource_summary_group.command_name', 'resource-summary'), cls=CommandGroupWithAlias, help="""The details of a resource under a service.""")
@cli_util.help_option_group
def resource_summary_group():
    pass


@click.command(cli_util.override('resources.resource_quotum_summary_group.command_name', 'resource-quotum-summary'), cls=CommandGroupWithAlias, help="""The resource quota balance details.""")
@cli_util.help_option_group
def resource_quotum_summary_group():
    pass


usage_service_cli.usage_service_group.add_command(resources_root_group)
resources_root_group.add_command(resource_summary_group)
resources_root_group.add_command(resource_quotum_summary_group)


@resource_quotum_summary_group.command(name=cli_util.override('resources.list_resource_quota.command_name', 'list-resource-quota'), help=u"""Returns the resource quota details under a tenancy > **Important**: Calls to this API will only succeed against the endpoint in the home region. \n[Command Reference](listResourceQuota)""")
@cli_util.option('--service-name', required=True, help=u"""Service Name.""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the root compartment.""")
@cli_util.option('--service-entitlement', help=u"""Service entitlement Id.""")
@cli_util.option('--page', help=u"""The value of the 'opc-next-page' response header from the previous call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return in the paginated response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, which can be ascending (ASC) or descending (DESC).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["TIMECREATED", "TIMESTART"]), help=u"""The field to sort by. Supports one sort order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'usage', 'class': 'ResourceQuotumCollection'})
@cli_util.wrap_exceptions
def list_resource_quota(ctx, from_json, all_pages, page_size, service_name, compartment_id, service_entitlement, page, limit, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if service_entitlement is not None:
        kwargs['service_entitlement'] = service_entitlement
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('usage', 'resources', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_resource_quota,
            service_name=service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_resource_quota,
            limit,
            page_size,
            service_name=service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_resource_quota(
            service_name=service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@resource_summary_group.command(name=cli_util.override('resources.list_resources.command_name', 'list-resources'), help=u"""Returns the resource details for a service > **Important**: Calls to this API will only succeed against the endpoint in the home region. \n[Command Reference](listResources)""")
@cli_util.option('--service-name', required=True, help=u"""Service Name.""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the root compartment.""")
@cli_util.option('--entitlement-id', help=u"""Subscription or entitlement Id.""")
@cli_util.option('--page', help=u"""The value of the 'opc-next-page' response header from the previous call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return in the paginated response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, which can be ascending (ASC) or descending (DESC).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["TIMECREATED", "TIMESTART"]), help=u"""The field to sort by. Supports one sort order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'usage', 'class': 'ResourcesCollection'})
@cli_util.wrap_exceptions
def list_resources(ctx, from_json, all_pages, page_size, service_name, compartment_id, entitlement_id, page, limit, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if entitlement_id is not None:
        kwargs['entitlement_id'] = entitlement_id
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('usage', 'resources', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_resources,
            service_name=service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_resources,
            limit,
            page_size,
            service_name=service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_resources(
            service_name=service_name,
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)
