function GetOciTopLevelCommand_data_catalog() {
    return 'data-catalog'
}

function GetOciSubcommands_data_catalog() {
    $ociSubcommands = @{
        'data-catalog' = 'attribute attribute-tag catalog catalog-private-endpoint connection custom-property data-asset data-asset-tag entity entity-tag folder folder-tag glossary job job-definition job-execution job-log job-metric namespace pattern rule-summary search suggest-results tag term term-relationship type work-request work-request-error work-request-log'
        'data-catalog attribute' = 'create delete get list update'
        'data-catalog attribute-tag' = 'create delete get list'
        'data-catalog catalog' = 'attach change-compartment create delete detach get list object-stats process-recommendation recommendations update users'
        'data-catalog catalog-private-endpoint' = 'change-compartment create delete get list update'
        'data-catalog connection' = 'create delete get list test update upload-credentials'
        'data-catalog custom-property' = 'create delete get list update'
        'data-catalog data-asset' = 'add-data-selector-patterns create delete get import-connection list parse-connection remove-data-selector-patterns update validate-connection'
        'data-catalog data-asset-tag' = 'create delete get list'
        'data-catalog entity' = 'create delete get list list-aggregated-physical update'
        'data-catalog entity-tag' = 'create delete get list'
        'data-catalog folder' = 'create delete get list update'
        'data-catalog folder-tag' = 'create delete get list'
        'data-catalog glossary' = 'create delete expand-tree-for export get import list update'
        'data-catalog job' = 'create delete get list update'
        'data-catalog job-definition' = 'create delete get list update'
        'data-catalog job-execution' = 'create get list'
        'data-catalog job-log' = 'get list'
        'data-catalog job-metric' = 'get list'
        'data-catalog namespace' = 'create delete get list update'
        'data-catalog pattern' = 'create delete get list list-derived-logical-entities update validate'
        'data-catalog rule-summary' = 'list-rules'
        'data-catalog search' = 'query'
        'data-catalog suggest-results' = 'suggest-matches'
        'data-catalog tag' = 'list'
        'data-catalog term' = 'create delete get list update'
        'data-catalog term-relationship' = 'create delete get list update'
        'data-catalog type' = 'associate-custom-properties disassociate-custom-properties get list'
        'data-catalog work-request' = 'get list'
        'data-catalog work-request-error' = 'list'
        'data-catalog work-request-log' = 'list'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_data_catalog() {
    $ociCommandsToLongParams = @{
        'data-catalog attribute create' = 'business-name catalog-id custom-property-members data-asset-key description display-name entity-key external-data-type external-datatype-entity-key external-parent-attribute-key from-json help is-incremental-data is-nullable length max-collection-count max-wait-seconds min-collection-count position precision properties scale time-external wait-for-state wait-interval-seconds'
        'data-catalog attribute delete' = 'attribute-key catalog-id data-asset-key entity-key force from-json help if-match'
        'data-catalog attribute get' = 'attribute-key catalog-id data-asset-key entity-key fields from-json help'
        'data-catalog attribute list' = 'all business-name catalog-id created-by-id data-asset-key display-name display-name-contains display-or-business-name-contains entity-key external-key external-type-name fields from-json help is-incremental-data is-nullable length lifecycle-state limit page page-size position precision scale sort-by sort-order time-created time-external time-updated updated-by-id'
        'data-catalog attribute update' = 'attribute-key business-name catalog-id custom-property-members data-asset-key description display-name entity-key external-data-type external-datatype-entity-key external-parent-attribute-key force from-json help if-match is-incremental-data is-nullable length max-collection-count max-wait-seconds min-collection-count position precision properties scale time-external wait-for-state wait-interval-seconds'
        'data-catalog attribute-tag create' = 'attribute-key catalog-id data-asset-key entity-key from-json help max-wait-seconds name term-key wait-for-state wait-interval-seconds'
        'data-catalog attribute-tag delete' = 'attribute-key catalog-id data-asset-key entity-key force from-json help if-match tag-key'
        'data-catalog attribute-tag get' = 'attribute-key catalog-id data-asset-key entity-key fields from-json help tag-key'
        'data-catalog attribute-tag list' = 'all attribute-key catalog-id created-by-id data-asset-key entity-key fields from-json help lifecycle-state limit name page page-size sort-by sort-order term-key term-path time-created'
        'data-catalog catalog attach' = 'catalog-id catalog-private-endpoint-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog catalog change-compartment' = 'catalog-id compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog catalog create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog catalog delete' = 'catalog-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog catalog detach' = 'catalog-id catalog-private-endpoint-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog catalog get' = 'catalog-id from-json help'
        'data-catalog catalog list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'data-catalog catalog object-stats' = 'catalog-id from-json help limit page sort-by sort-order'
        'data-catalog catalog process-recommendation' = 'catalog-id from-json help if-match properties recommendation-key recommendation-status'
        'data-catalog catalog recommendations' = 'catalog-id from-json help recommendation-status recommendation-type source-object-key source-object-type'
        'data-catalog catalog update' = 'catalog-id defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog catalog users' = 'catalog-id from-json help limit page sort-by sort-order'
        'data-catalog catalog-private-endpoint change-compartment' = 'catalog-private-endpoint-id compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog catalog-private-endpoint create' = 'compartment-id defined-tags display-name dns-zones freeform-tags from-json help max-wait-seconds subnet-id wait-for-state wait-interval-seconds'
        'data-catalog catalog-private-endpoint delete' = 'catalog-private-endpoint-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog catalog-private-endpoint get' = 'catalog-private-endpoint-id from-json help'
        'data-catalog catalog-private-endpoint list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'data-catalog catalog-private-endpoint update' = 'catalog-private-endpoint-id defined-tags display-name dns-zones force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog connection create' = 'catalog-id custom-property-members data-asset-key description display-name enc-properties from-json help is-default max-wait-seconds properties type-key wait-for-state wait-interval-seconds'
        'data-catalog connection delete' = 'catalog-id connection-key data-asset-key force from-json help if-match'
        'data-catalog connection get' = 'catalog-id connection-key data-asset-key fields from-json help'
        'data-catalog connection list' = 'all catalog-id created-by-id data-asset-key display-name display-name-contains external-key fields from-json help is-default lifecycle-state limit page page-size sort-by sort-order time-created time-status-updated time-updated updated-by-id'
        'data-catalog connection test' = 'catalog-id connection-key data-asset-key from-json help'
        'data-catalog connection update' = 'catalog-id connection-key custom-property-members data-asset-key description display-name enc-properties force from-json help if-match is-default max-wait-seconds properties wait-for-state wait-interval-seconds'
        'data-catalog connection upload-credentials' = 'catalog-id connection-detail connection-key credential-payload data-asset-key from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog custom-property create' = 'allowed-values catalog-id data-type description display-name from-json help is-editable is-filterable is-hidden is-hidden-in-search is-multi-valued is-shown-in-list is-sortable max-wait-seconds namespace-id properties wait-for-state wait-interval-seconds'
        'data-catalog custom-property delete' = 'catalog-id custom-property-key force from-json help if-match namespace-id'
        'data-catalog custom-property get' = 'catalog-id custom-property-key fields from-json help namespace-id'
        'data-catalog custom-property list' = 'all catalog-id created-by-id data-types display-name display-name-contains fields from-json help lifecycle-state limit namespace-id page page-size sort-by sort-order time-created time-updated type-name updated-by-id'
        'data-catalog custom-property update' = 'allowed-values catalog-id custom-property-key description display-name force from-json help if-match is-editable is-filterable is-hidden is-hidden-in-search is-multi-valued is-shown-in-list is-sortable max-wait-seconds namespace-id properties wait-for-state wait-interval-seconds'
        'data-catalog data-asset add-data-selector-patterns' = 'catalog-id data-asset-key from-json help if-match items max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog data-asset create' = 'catalog-id custom-property-members description display-name from-json help max-wait-seconds properties type-key wait-for-state wait-interval-seconds'
        'data-catalog data-asset delete' = 'catalog-id data-asset-key force from-json help if-match'
        'data-catalog data-asset get' = 'catalog-id data-asset-key fields from-json help'
        'data-catalog data-asset import-connection' = 'catalog-id connection-detail connection-payload data-asset-key from-json help if-match'
        'data-catalog data-asset list' = 'all catalog-id created-by-id display-name display-name-contains external-key fields from-json help lifecycle-state limit page page-size sort-by sort-order time-created time-updated type-key updated-by-id'
        'data-catalog data-asset parse-connection' = 'catalog-id connection-detail connection-key connection-payload data-asset-key from-json help'
        'data-catalog data-asset remove-data-selector-patterns' = 'catalog-id data-asset-key from-json help if-match items max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog data-asset update' = 'catalog-id custom-property-members data-asset-key description display-name force from-json help if-match max-wait-seconds properties wait-for-state wait-interval-seconds'
        'data-catalog data-asset validate-connection' = 'catalog-id connection-detail connection-payload data-asset-key from-json help'
        'data-catalog data-asset-tag create' = 'catalog-id data-asset-key from-json help max-wait-seconds name term-key wait-for-state wait-interval-seconds'
        'data-catalog data-asset-tag delete' = 'catalog-id data-asset-key force from-json help if-match tag-key'
        'data-catalog data-asset-tag get' = 'catalog-id data-asset-key fields from-json help tag-key'
        'data-catalog data-asset-tag list' = 'all catalog-id created-by-id data-asset-key fields from-json help lifecycle-state limit name page page-size sort-by sort-order term-key term-path time-created'
        'data-catalog entity create' = 'business-name catalog-id custom-property-members data-asset-key description display-name folder-key from-json harvest-status help is-logical is-partition last-job-key max-wait-seconds pattern-key properties realized-expression time-external wait-for-state wait-interval-seconds'
        'data-catalog entity delete' = 'catalog-id data-asset-key entity-key force from-json help if-match'
        'data-catalog entity get' = 'catalog-id data-asset-key entity-key fields from-json help'
        'data-catalog entity list' = 'all business-name catalog-id created-by-id data-asset-key display-name display-name-contains display-or-business-name-contains external-key fields folder-key from-json harvest-status help is-logical is-partition last-job-key lifecycle-state limit page page-size path pattern-key sort-by sort-order time-created time-external time-status-updated time-updated type-key updated-by-id'
        'data-catalog entity list-aggregated-physical' = 'all catalog-id data-asset-key display-name-contains entity-key fields from-json help limit page page-size sort-by sort-order'
        'data-catalog entity update' = 'business-name catalog-id custom-property-members data-asset-key description display-name entity-key folder-key force from-json harvest-status help if-match is-logical is-partition last-job-key max-wait-seconds pattern-key properties realized-expression time-external wait-for-state wait-interval-seconds'
        'data-catalog entity-tag create' = 'catalog-id data-asset-key entity-key from-json help max-wait-seconds name term-key wait-for-state wait-interval-seconds'
        'data-catalog entity-tag delete' = 'catalog-id data-asset-key entity-key force from-json help if-match tag-key'
        'data-catalog entity-tag get' = 'catalog-id data-asset-key entity-key fields from-json help tag-key'
        'data-catalog entity-tag list' = 'all catalog-id created-by-id data-asset-key entity-key fields from-json help lifecycle-state limit name page page-size sort-by sort-order term-key term-path time-created'
        'data-catalog folder create' = 'business-name catalog-id custom-property-members data-asset-key description display-name from-json harvest-status help last-job-key max-wait-seconds parent-folder-key properties time-external wait-for-state wait-interval-seconds'
        'data-catalog folder delete' = 'catalog-id data-asset-key folder-key force from-json help if-match'
        'data-catalog folder get' = 'catalog-id data-asset-key fields folder-key from-json help'
        'data-catalog folder list' = 'all business-name catalog-id created-by-id data-asset-key display-name display-name-contains display-or-business-name-contains external-key fields from-json harvest-status help last-job-key lifecycle-state limit page page-size parent-folder-key path sort-by sort-order time-created time-updated updated-by-id'
        'data-catalog folder update' = 'business-name catalog-id custom-property-members data-asset-key description display-name folder-key force from-json harvest-status help if-match last-job-key max-wait-seconds parent-folder-key properties time-external wait-for-state wait-interval-seconds'
        'data-catalog folder-tag create' = 'catalog-id data-asset-key folder-key from-json help max-wait-seconds name term-key wait-for-state wait-interval-seconds'
        'data-catalog folder-tag delete' = 'catalog-id data-asset-key folder-key force from-json help if-match tag-key'
        'data-catalog folder-tag get' = 'catalog-id data-asset-key fields folder-key from-json help tag-key'
        'data-catalog folder-tag list' = 'all catalog-id created-by-id data-asset-key fields folder-key from-json help lifecycle-state limit name page page-size sort-by sort-order term-key term-path time-created'
        'data-catalog glossary create' = 'catalog-id custom-property-members description display-name from-json help max-wait-seconds owner wait-for-state wait-interval-seconds workflow-status'
        'data-catalog glossary delete' = 'catalog-id force from-json glossary-key help if-match'
        'data-catalog glossary expand-tree-for' = 'catalog-id from-json glossary-key help'
        'data-catalog glossary export' = 'catalog-id from-json glossary-key help is-relationship-exported'
        'data-catalog glossary get' = 'catalog-id fields from-json glossary-key help'
        'data-catalog glossary import' = 'catalog-id from-json glossary-file-contents glossary-key help is-relationship-imported'
        'data-catalog glossary list' = 'all catalog-id created-by-id display-name display-name-contains fields from-json help lifecycle-state limit page page-size sort-by sort-order time-created time-updated updated-by-id'
        'data-catalog glossary update' = 'catalog-id custom-property-members description display-name force from-json glossary-key help if-match max-wait-seconds owner wait-for-state wait-interval-seconds workflow-status'
        'data-catalog job create' = 'catalog-id connection-key description display-name from-json help job-definition-key max-wait-seconds schedule-cron-expression time-schedule-begin time-schedule-end wait-for-state wait-interval-seconds'
        'data-catalog job delete' = 'catalog-id force from-json help if-match job-key'
        'data-catalog job get' = 'catalog-id fields from-json help job-key'
        'data-catalog job list' = 'all catalog-id connection-key created-by-id data-asset-key display-name display-name-contains execution-count fields from-json help job-definition-key job-type lifecycle-state limit page page-size schedule-cron-expression schedule-type sort-by sort-order time-created time-of-latest-execution time-schedule-begin time-schedule-end time-updated updated-by-id'
        'data-catalog job update' = 'catalog-id connection-key description display-name from-json help if-match job-key max-wait-seconds schedule-cron-expression time-schedule-begin time-schedule-end wait-for-state wait-interval-seconds'
        'data-catalog job-definition create' = 'catalog-id connection-key data-asset-key description display-name from-json help is-incremental is-sample-data-extracted job-type max-wait-seconds properties sample-data-size-in-mbs wait-for-state wait-interval-seconds'
        'data-catalog job-definition delete' = 'catalog-id force from-json help if-match job-definition-key'
        'data-catalog job-definition get' = 'catalog-id fields from-json help job-definition-key'
        'data-catalog job-definition list' = 'all catalog-id connection-key created-by-id data-asset-key display-name display-name-contains fields from-json help is-incremental job-execution-state job-type lifecycle-state limit page page-size sample-data-size-in-mbs sort-by sort-order time-created time-updated updated-by-id'
        'data-catalog job-definition update' = 'catalog-id connection-key data-asset-key description display-name force from-json help if-match is-incremental is-sample-data-extracted job-definition-key max-wait-seconds properties sample-data-size-in-mbs wait-for-state wait-interval-seconds'
        'data-catalog job-execution create' = 'catalog-id data-entity-key error-code error-message event-key external-url from-json help job-key job-type lifecycle-state max-wait-seconds parent-key process-key properties schedule-instance-key sub-type time-ended time-started wait-for-state wait-interval-seconds'
        'data-catalog job-execution get' = 'catalog-id fields from-json help job-execution-key job-key'
        'data-catalog job-execution list' = 'all catalog-id created-by-id data-entity-key error-code error-message event-key external-url fields from-json help job-key job-type lifecycle-state limit page page-size parent-key process-key sort-by sort-order sub-type time-created time-end time-start time-updated updated-by-id'
        'data-catalog job-log get' = 'catalog-id fields from-json help job-execution-key job-key job-log-key'
        'data-catalog job-log list' = 'all catalog-id created-by-id fields from-json help job-execution-key job-key lifecycle-state limit page page-size severity sort-by sort-order time-created time-updated updated-by-id'
        'data-catalog job-metric get' = 'catalog-id fields from-json help job-execution-key job-key job-metrics-key'
        'data-catalog job-metric list' = 'all batch-key catalog-id category created-by-id display-name display-name-contains fields from-json help job-execution-key job-key limit page page-size sort-by sort-order sub-category time-created time-inserted time-updated unit updated-by-id value'
        'data-catalog namespace create' = 'catalog-id description display-name from-json help is-service-defined max-wait-seconds wait-for-state wait-interval-seconds'
        'data-catalog namespace delete' = 'catalog-id force from-json help if-match namespace-id'
        'data-catalog namespace get' = 'catalog-id fields from-json help namespace-id'
        'data-catalog namespace list' = 'all catalog-id created-by-id display-name display-name-contains fields from-json help lifecycle-state limit page page-size sort-by sort-order time-created time-updated updated-by-id'
        'data-catalog namespace update' = 'catalog-id description display-name from-json help if-match is-service-defined max-wait-seconds namespace-id wait-for-state wait-interval-seconds'
        'data-catalog pattern create' = 'catalog-id check-failure-limit check-file-path-list description display-name expression from-json help is-enable-check-failure-limit max-wait-seconds properties wait-for-state wait-interval-seconds'
        'data-catalog pattern delete' = 'catalog-id force from-json help if-match pattern-key'
        'data-catalog pattern get' = 'catalog-id fields from-json help pattern-key'
        'data-catalog pattern list' = 'all catalog-id created-by-id display-name display-name-contains fields from-json help lifecycle-state limit page page-size sort-by sort-order time-created time-updated updated-by-id'
        'data-catalog pattern list-derived-logical-entities' = 'all catalog-id display-name-contains from-json help if-match limit page page-size pattern-key sort-by sort-order'
        'data-catalog pattern update' = 'catalog-id check-failure-limit check-file-path-list description display-name expression force from-json help if-match is-enable-check-failure-limit max-wait-seconds pattern-key properties wait-for-state wait-interval-seconds'
        'data-catalog pattern validate' = 'catalog-id check-failure-limit check-file-path-list expression from-json help pattern-key'
        'data-catalog rule-summary list-rules' = 'all catalog-id created-by-id data-asset-key display-name display-name-contains entity-key external-key fields from-json help lifecycle-state limit origin-type page page-size rule-type sort-by sort-order time-created time-updated updated-by-id'
        'data-catalog search query' = 'catalog-id dimensions display-name faceted-query filters from-json help lifecycle-state limit name page query-text sort sort-by sort-order timeout'
        'data-catalog suggest-results suggest-matches' = 'catalog-id from-json help input-text limit timeout'
        'data-catalog tag list' = 'all catalog-id display-name display-name-contains fields from-json help lifecycle-state limit page page-size sort-by sort-order'
        'data-catalog term create' = 'catalog-id custom-property-members description display-name from-json glossary-key help is-allowed-to-have-child-terms max-wait-seconds owner parent-term-key wait-for-state wait-interval-seconds workflow-status'
        'data-catalog term delete' = 'catalog-id force from-json glossary-key help if-match term-key'
        'data-catalog term get' = 'catalog-id fields from-json glossary-key help term-key'
        'data-catalog term list' = 'all catalog-id display-name display-name-contains fields from-json glossary-key help is-allowed-to-have-child-terms lifecycle-state limit page page-size parent-term-key path sort-by sort-order workflow-status'
        'data-catalog term update' = 'catalog-id custom-property-members description display-name force from-json glossary-key help if-match max-wait-seconds owner parent-term-key term-key wait-for-state wait-interval-seconds workflow-status'
        'data-catalog term-relationship create' = 'catalog-id description display-name from-json glossary-key help max-wait-seconds related-term-key term-key wait-for-state wait-interval-seconds'
        'data-catalog term-relationship delete' = 'catalog-id force from-json glossary-key help if-match term-key term-relationship-key'
        'data-catalog term-relationship get' = 'catalog-id fields from-json glossary-key help term-key term-relationship-key'
        'data-catalog term-relationship list' = 'all catalog-id display-name display-name-contains fields from-json glossary-key help lifecycle-state limit page page-size sort-by sort-order term-key'
        'data-catalog term-relationship update' = 'catalog-id description display-name from-json glossary-key help if-match max-wait-seconds term-key term-relationship-key wait-for-state wait-interval-seconds'
        'data-catalog type associate-custom-properties' = 'catalog-id custom-property-ids from-json help if-match max-wait-seconds type-key wait-for-state wait-interval-seconds'
        'data-catalog type disassociate-custom-properties' = 'catalog-id custom-property-ids from-json help if-match max-wait-seconds type-key wait-for-state wait-interval-seconds'
        'data-catalog type get' = 'catalog-id fields from-json help type-key'
        'data-catalog type list' = 'all catalog-id external-type-name fields from-json help is-approved is-internal is-tag lifecycle-state limit name page page-size sort-by sort-order type-category'
        'data-catalog work-request get' = 'from-json help work-request-id'
        'data-catalog work-request list' = 'all compartment-id from-json help limit page page-size'
        'data-catalog work-request-error list' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
        'data-catalog work-request-log list' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_data_catalog() {
    $ociCommandsToShortParams = @{
        'data-catalog attribute create' = '? h'
        'data-catalog attribute delete' = '? h'
        'data-catalog attribute get' = '? h'
        'data-catalog attribute list' = '? h'
        'data-catalog attribute update' = '? h'
        'data-catalog attribute-tag create' = '? h'
        'data-catalog attribute-tag delete' = '? h'
        'data-catalog attribute-tag get' = '? h'
        'data-catalog attribute-tag list' = '? h'
        'data-catalog catalog attach' = '? h'
        'data-catalog catalog change-compartment' = '? c h'
        'data-catalog catalog create' = '? c h'
        'data-catalog catalog delete' = '? h'
        'data-catalog catalog detach' = '? h'
        'data-catalog catalog get' = '? h'
        'data-catalog catalog list' = '? c h'
        'data-catalog catalog object-stats' = '? h'
        'data-catalog catalog process-recommendation' = '? h'
        'data-catalog catalog recommendations' = '? h'
        'data-catalog catalog update' = '? h'
        'data-catalog catalog users' = '? h'
        'data-catalog catalog-private-endpoint change-compartment' = '? c h'
        'data-catalog catalog-private-endpoint create' = '? c h'
        'data-catalog catalog-private-endpoint delete' = '? h'
        'data-catalog catalog-private-endpoint get' = '? h'
        'data-catalog catalog-private-endpoint list' = '? c h'
        'data-catalog catalog-private-endpoint update' = '? h'
        'data-catalog connection create' = '? h'
        'data-catalog connection delete' = '? h'
        'data-catalog connection get' = '? h'
        'data-catalog connection list' = '? h'
        'data-catalog connection test' = '? h'
        'data-catalog connection update' = '? h'
        'data-catalog connection upload-credentials' = '? h'
        'data-catalog custom-property create' = '? h'
        'data-catalog custom-property delete' = '? h'
        'data-catalog custom-property get' = '? h'
        'data-catalog custom-property list' = '? h'
        'data-catalog custom-property update' = '? h'
        'data-catalog data-asset add-data-selector-patterns' = '? h'
        'data-catalog data-asset create' = '? h'
        'data-catalog data-asset delete' = '? h'
        'data-catalog data-asset get' = '? h'
        'data-catalog data-asset import-connection' = '? h'
        'data-catalog data-asset list' = '? h'
        'data-catalog data-asset parse-connection' = '? h'
        'data-catalog data-asset remove-data-selector-patterns' = '? h'
        'data-catalog data-asset update' = '? h'
        'data-catalog data-asset validate-connection' = '? h'
        'data-catalog data-asset-tag create' = '? h'
        'data-catalog data-asset-tag delete' = '? h'
        'data-catalog data-asset-tag get' = '? h'
        'data-catalog data-asset-tag list' = '? h'
        'data-catalog entity create' = '? h'
        'data-catalog entity delete' = '? h'
        'data-catalog entity get' = '? h'
        'data-catalog entity list' = '? h'
        'data-catalog entity list-aggregated-physical' = '? h'
        'data-catalog entity update' = '? h'
        'data-catalog entity-tag create' = '? h'
        'data-catalog entity-tag delete' = '? h'
        'data-catalog entity-tag get' = '? h'
        'data-catalog entity-tag list' = '? h'
        'data-catalog folder create' = '? h'
        'data-catalog folder delete' = '? h'
        'data-catalog folder get' = '? h'
        'data-catalog folder list' = '? h'
        'data-catalog folder update' = '? h'
        'data-catalog folder-tag create' = '? h'
        'data-catalog folder-tag delete' = '? h'
        'data-catalog folder-tag get' = '? h'
        'data-catalog folder-tag list' = '? h'
        'data-catalog glossary create' = '? h'
        'data-catalog glossary delete' = '? h'
        'data-catalog glossary expand-tree-for' = '? h'
        'data-catalog glossary export' = '? h'
        'data-catalog glossary get' = '? h'
        'data-catalog glossary import' = '? h'
        'data-catalog glossary list' = '? h'
        'data-catalog glossary update' = '? h'
        'data-catalog job create' = '? h'
        'data-catalog job delete' = '? h'
        'data-catalog job get' = '? h'
        'data-catalog job list' = '? h'
        'data-catalog job update' = '? h'
        'data-catalog job-definition create' = '? h'
        'data-catalog job-definition delete' = '? h'
        'data-catalog job-definition get' = '? h'
        'data-catalog job-definition list' = '? h'
        'data-catalog job-definition update' = '? h'
        'data-catalog job-execution create' = '? h'
        'data-catalog job-execution get' = '? h'
        'data-catalog job-execution list' = '? h'
        'data-catalog job-log get' = '? h'
        'data-catalog job-log list' = '? h'
        'data-catalog job-metric get' = '? h'
        'data-catalog job-metric list' = '? h'
        'data-catalog namespace create' = '? h'
        'data-catalog namespace delete' = '? h'
        'data-catalog namespace get' = '? h'
        'data-catalog namespace list' = '? h'
        'data-catalog namespace update' = '? h'
        'data-catalog pattern create' = '? h'
        'data-catalog pattern delete' = '? h'
        'data-catalog pattern get' = '? h'
        'data-catalog pattern list' = '? h'
        'data-catalog pattern list-derived-logical-entities' = '? h'
        'data-catalog pattern update' = '? h'
        'data-catalog pattern validate' = '? h'
        'data-catalog rule-summary list-rules' = '? h'
        'data-catalog search query' = '? h'
        'data-catalog suggest-results suggest-matches' = '? h'
        'data-catalog tag list' = '? h'
        'data-catalog term create' = '? h'
        'data-catalog term delete' = '? h'
        'data-catalog term get' = '? h'
        'data-catalog term list' = '? h'
        'data-catalog term update' = '? h'
        'data-catalog term-relationship create' = '? h'
        'data-catalog term-relationship delete' = '? h'
        'data-catalog term-relationship get' = '? h'
        'data-catalog term-relationship list' = '? h'
        'data-catalog term-relationship update' = '? h'
        'data-catalog type associate-custom-properties' = '? h'
        'data-catalog type disassociate-custom-properties' = '? h'
        'data-catalog type get' = '? h'
        'data-catalog type list' = '? h'
        'data-catalog work-request get' = '? h'
        'data-catalog work-request list' = '? c h'
        'data-catalog work-request-error list' = '? h'
        'data-catalog work-request-log list' = '? h'
    }
    return $ociCommandsToShortParams
}