# Structorex

[![Python Version](https://img.shields.io/badge/python-3.8%2B-blue.svg)](https://www.python.org/downloads/)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](LICENSE)

**Structorex** — это консольный инструмент, который генерирует подробный отчет о структуре вашего проекта, включая содержимое файлов. Он предоставляет визуальное представление иерархии каталогов и позволяет просматривать содержимое файлов непосредственно в сгенерированном отчете.

## Возможности

- 🌳 Визуальное представление структуры каталогов
- 📄 Просмотр содержимого файлов в отчете
- 🔍 Автоматическое определение типов файлов (изображения, аудио, видео, документы)
- 🗑️ Исключение определенных каталогов (`.git`, `__pycache__` и др.)
- 📏 Ограничение по размеру файлов (пропускает большие файлы)
- 🧪 Комплексный набор тестов

## Установка

```bash
pip install structorex
```

Или установка из исходников:

```bash
git clone https://github.com/yourusername/structorex.git
cd structorex
pip install -e .
```

## Использование

### Интерфейс командной строки

```bash
structorex
```

Инструмент запросит у вас:
1. Путь к каталогу для анализа
2. Имя выходного файла (по умолчанию: `project_report.txt`)

### Пример вывода

```
PROJECT STRUCTURE:
└── my_project/
    ├── src/
    │   ├── __init__.py
    │   ├── main.py
    │   └── utils.py
    ├── tests/
    │   ├── __init__.py
    │   └── test_utils.py
    ├── .gitignore
    └── README.md

FILE CONTENTS:
==================================================
File: /path/to/my_project/src/main.py
==================================================
def main():
    print("Hello, Structorex!")

if __name__ == "__main__":
    main()
```

## Расширенная настройка

Вы можете настроить список исключаемых каталогов, изменив множество `excluded` в коде:

```python
excluded = {
    '.git', '__pycache__', '.idea', 'venv', '.venv',
    'node_modules', '.vscode'
}
```

## Запуск тестов

```bash
pip install -e .[dev]
pytest -v
```

## Структура проекта

```
structorex/
├── app/
│   ├── __init__.py
│   ├── app.py          # Точка входа CLI
│   ├── builder.py      # Построение дерева файловой системы
│   ├── components.py   # Компоненты файловой системы
│   ├── console.py      # Обработка пользовательского ввода
│   ├── file_utils.py   # Утилиты для операций с файлами
│   └── visitors.py     # Генерация отчетов
├── tests/              # Набор тестов
├── pyproject.toml      # Конфигурация проекта
└── .gitignore
```

## Участие в разработке

Приветствуются любые вклады! Пожалуйста, ознакомьтесь с нашим файлом [CONTRIBUTING.md](CONTRIBUTING.md), чтобы узнать подробности о нашем кодексе поведения и процессе отправки запросов на включение изменений.

## Лицензия

Этот проект лицензирован по лицензии MIT — подробности см. в файле [LICENSE](LICENSE).