# Generated by Django 4.2.21 on 2025-06-09 03:49

from django.db import migrations, models
import django.db.models.deletion
import mojo.models.rest


class Migration(migrations.Migration):

    dependencies = [
        ('fileman', '0009_rename_file_path_file_storage_file_path'),
    ]

    operations = [
        migrations.CreateModel(
            name='FileRendition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('filename', models.CharField(db_index=True, help_text='rendition filename', max_length=255)),
                ('storage_path', models.TextField(help_text='Storage path and filename')),
                ('download_url', models.TextField(blank=True, default=None, help_text='Persistent URL for downloading the file, (if allowed)', null=True)),
                ('file_size', models.BigIntegerField(blank=True, help_text='File size in bytes', null=True)),
                ('content_type', models.CharField(help_text='MIME type of the file', max_length=255)),
                ('category', models.CharField(help_text="A category for the file, like 'image', 'document', 'video', etc.", max_length=255)),
                ('role', models.CharField(db_index=True, help_text="The role of the file, like 'thumbnail', 'preview', 'full', etc.", max_length=255)),
                ('upload_status', models.CharField(db_index=True, default='pending', help_text='Current status of rendering', max_length=32)),
                ('original_file', models.ForeignKey(help_text='The parent file', on_delete=django.db.models.deletion.CASCADE, related_name='renditions', to='fileman.file')),
            ],
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
    ]
