"""Change Comment.updated_by in Comment.editor_id

Revision ID: 307edd8c639d
Revises: addbad59c706
Create Date: 2025-03-10 12:53:19.482537

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "307edd8c639d"
down_revision = "addbad59c706"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("comment", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "editor_id",
                sqlalchemy_utils.types.uuid.UUIDType(binary=False),
                default=uuid.uuid4,
                nullable=True,
            )
        )
        batch_op.drop_index("ix_comment_updated_by")
        batch_op.create_index(
            batch_op.f("ix_comment_editor_id"), ["editor_id"], unique=False
        )
        batch_op.drop_constraint("comment_updated_by_fkey", type_="foreignkey")
        batch_op.create_foreign_key(None, "person", ["editor_id"], ["id"])
        batch_op.drop_column("updated_by")

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("comment", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "updated_by", sa.UUID(), autoincrement=False, nullable=True
            )
        )
        batch_op.drop_constraint("comment_editor_id_fkey", type_="foreignkey")
        batch_op.create_foreign_key(
            "comment_updated_by_fkey", "person", ["updated_by"], ["id"]
        )
        batch_op.drop_index(batch_op.f("ix_comment_editor_id"))
        batch_op.create_index(
            "ix_comment_updated_by", ["updated_by"], unique=False
        )
        batch_op.drop_column("editor_id")

    # ### end Alembic commands ###
