"""add departement links tables for hardware and software

Revision ID: dde6be40f54f
Revises: 9af2df17a9d5
Create Date: 2025-07-16 21:58:45.737760

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "dde6be40f54f"
down_revision = "9af2df17a9d5"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "hardware_item_department_link",
        sa.Column(
            "department_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "hardware_item_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["department_id"],
            ["department.id"],
        ),
        sa.ForeignKeyConstraint(
            ["hardware_item_id"],
            ["hardware_item.id"],
        ),
        sa.PrimaryKeyConstraint("department_id", "hardware_item_id", "id"),
        sa.UniqueConstraint(
            "hardware_item_id",
            "department_id",
            name="hardware_item_department_link_uc",
        ),
    )
    with op.batch_alter_table(
        "hardware_item_department_link", schema=None
    ) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_hardware_item_department_link_department_id"),
            ["department_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_hardware_item_department_link_hardware_item_id"),
            ["hardware_item_id"],
            unique=False,
        )

    op.create_table(
        "software_department_link",
        sa.Column(
            "department_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "software_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["department_id"],
            ["department.id"],
        ),
        sa.ForeignKeyConstraint(
            ["software_id"],
            ["software.id"],
        ),
        sa.PrimaryKeyConstraint("department_id", "software_id", "id"),
        sa.UniqueConstraint(
            "department_id", "software_id", name="software_department_link_uc"
        ),
    )
    with op.batch_alter_table(
        "software_department_link", schema=None
    ) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_software_department_link_department_id"),
            ["department_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_software_department_link_software_id"),
            ["software_id"],
            unique=False,
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "software_department_link", schema=None
    ) as batch_op:
        batch_op.drop_index(
            batch_op.f("ix_software_department_link_software_id")
        )
        batch_op.drop_index(
            batch_op.f("ix_software_department_link_department_id")
        )

    op.drop_table("software_department_link")
    with op.batch_alter_table(
        "hardware_item_department_link", schema=None
    ) as batch_op:
        batch_op.drop_index(
            batch_op.f("ix_hardware_item_department_link_hardware_item_id")
        )
        batch_op.drop_index(
            batch_op.f("ix_hardware_item_department_link_department_id")
        )

    op.drop_table("hardware_item_department_link")
    # ### end Alembic commands ###
