# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from datetime import datetime
from pydantic.v1 import Field, StrictInt, StrictStr
from typing import Dict, Optional
from typing_extensions import Annotated
from lusid.models.annul_structured_data_response import AnnulStructuredDataResponse
from lusid.models.append_complex_market_data_request import AppendComplexMarketDataRequest
from lusid.models.complex_market_data_id import ComplexMarketDataId
from lusid.models.get_complex_market_data_response import GetComplexMarketDataResponse
from lusid.models.resource_list_of_list_complex_market_data_with_meta_data_response import ResourceListOfListComplexMarketDataWithMetaDataResponse
from lusid.models.upsert_complex_market_data_request import UpsertComplexMarketDataRequest
from lusid.models.upsert_single_structured_data_response import UpsertSingleStructuredDataResponse
from lusid.models.upsert_structured_data_response import UpsertStructuredDataResponse

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class ComplexMarketDataApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def delete_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to delete.")], request_body : Annotated[Dict[str, ComplexMarketDataId], Field(description="The complex market data Ids to delete, each keyed by a unique correlation id.")], **kwargs) -> AnnulStructuredDataResponse:  # noqa: E501
        ...

    @overload
    def delete_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to delete.")], request_body : Annotated[Dict[str, ComplexMarketDataId], Field(description="The complex market data Ids to delete, each keyed by a unique correlation id.")], async_req: Optional[bool]=True, **kwargs) -> AnnulStructuredDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to delete.")], request_body : Annotated[Dict[str, ComplexMarketDataId], Field(description="The complex market data Ids to delete, each keyed by a unique correlation id.")], async_req: Optional[bool]=None, **kwargs) -> Union[AnnulStructuredDataResponse, Awaitable[AnnulStructuredDataResponse]]:  # noqa: E501
        """DeleteComplexMarketData: Delete one or more items of complex market data, assuming they are present.  # noqa: E501

        Delete one or more specified complex market data items from a single scope. Each item is identified by a unique id which includes  information about its type as well as the exact effective datetime (to the microsecond) at which it entered the system (became valid).                In the request each complex market data item must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each quote in the response.                The response will return both the collection of successfully deleted  complex market data items, as well as those that failed.  For the failures a reason will be provided explaining why the it could not be deleted.                It is important to always check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_complex_market_data(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the complex market data to delete. (required)
        :type scope: str
        :param request_body: The complex market data Ids to delete, each keyed by a unique correlation id. (required)
        :type request_body: Dict[str, ComplexMarketDataId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AnnulStructuredDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_complex_market_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_complex_market_data_with_http_info(scope, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_complex_market_data_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to delete.")], request_body : Annotated[Dict[str, ComplexMarketDataId], Field(description="The complex market data Ids to delete, each keyed by a unique correlation id.")], **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteComplexMarketData: Delete one or more items of complex market data, assuming they are present.  # noqa: E501

        Delete one or more specified complex market data items from a single scope. Each item is identified by a unique id which includes  information about its type as well as the exact effective datetime (to the microsecond) at which it entered the system (became valid).                In the request each complex market data item must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each quote in the response.                The response will return both the collection of successfully deleted  complex market data items, as well as those that failed.  For the failures a reason will be provided explaining why the it could not be deleted.                It is important to always check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_complex_market_data_with_http_info(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the complex market data to delete. (required)
        :type scope: str
        :param request_body: The complex market data Ids to delete, each keyed by a unique correlation id. (required)
        :type request_body: Dict[str, ComplexMarketDataId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AnnulStructuredDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_complex_market_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AnnulStructuredDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/complexmarketdata/{scope}/$delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to retrieve.")], request_body : Annotated[Dict[str, ComplexMarketDataId], Field(description="The time invariant set of complex data identifiers to retrieve the data for. These need to be               keyed by a unique correlation id allowing the retrieved item to be identified in the response.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime at which to retrieve the complex market data.               Defaults to the current LUSID system datetime if not specified.               Must match the Effective at of each ComplexMarketDataId given in the request body.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a complex market data item must exist to be retrieved.")] = None, **kwargs) -> GetComplexMarketDataResponse:  # noqa: E501
        ...

    @overload
    def get_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to retrieve.")], request_body : Annotated[Dict[str, ComplexMarketDataId], Field(description="The time invariant set of complex data identifiers to retrieve the data for. These need to be               keyed by a unique correlation id allowing the retrieved item to be identified in the response.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime at which to retrieve the complex market data.               Defaults to the current LUSID system datetime if not specified.               Must match the Effective at of each ComplexMarketDataId given in the request body.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a complex market data item must exist to be retrieved.")] = None, async_req: Optional[bool]=True, **kwargs) -> GetComplexMarketDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to retrieve.")], request_body : Annotated[Dict[str, ComplexMarketDataId], Field(description="The time invariant set of complex data identifiers to retrieve the data for. These need to be               keyed by a unique correlation id allowing the retrieved item to be identified in the response.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime at which to retrieve the complex market data.               Defaults to the current LUSID system datetime if not specified.               Must match the Effective at of each ComplexMarketDataId given in the request body.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a complex market data item must exist to be retrieved.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[GetComplexMarketDataResponse, Awaitable[GetComplexMarketDataResponse]]:  # noqa: E501
        """GetComplexMarketData: Get complex market data  # noqa: E501

        Get one or more items of complex market data from a single scope.                Each item can be identified by its time invariant complex market data identifier.                For each id LUSID will return the most recent matched item with respect to the provided (or default) effective datetime.                An optional maximum age range window can be specified which defines how far back to look back for data from the specified effective datetime.  LUSID will return the most recent item within this window.                In the request each complex market data id must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each item in the response.                The response will return three collections. One, the successfully retrieved complex market data. Two, those that had a  valid identifier but could not be found. Three, those that failed because LUSID could not construct a valid identifier from the request.                For the ids that failed to resolve or could not be found a reason will be provided explaining why that is the case.                It is important to always check the failed and not found sets for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_complex_market_data(scope, request_body, effective_at, as_at, max_age, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the complex market data to retrieve. (required)
        :type scope: str
        :param request_body: The time invariant set of complex data identifiers to retrieve the data for. These need to be               keyed by a unique correlation id allowing the retrieved item to be identified in the response. (required)
        :type request_body: Dict[str, ComplexMarketDataId]
        :param effective_at: The effective datetime at which to retrieve the complex market data.               Defaults to the current LUSID system datetime if not specified.               Must match the Effective at of each ComplexMarketDataId given in the request body.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param max_age: The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a complex market data item must exist to be retrieved.
        :type max_age: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetComplexMarketDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_complex_market_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_complex_market_data_with_http_info(scope, request_body, effective_at, as_at, max_age, **kwargs)  # noqa: E501

    @validate_arguments
    def get_complex_market_data_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to retrieve.")], request_body : Annotated[Dict[str, ComplexMarketDataId], Field(description="The time invariant set of complex data identifiers to retrieve the data for. These need to be               keyed by a unique correlation id allowing the retrieved item to be identified in the response.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime at which to retrieve the complex market data.               Defaults to the current LUSID system datetime if not specified.               Must match the Effective at of each ComplexMarketDataId given in the request body.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a complex market data item must exist to be retrieved.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetComplexMarketData: Get complex market data  # noqa: E501

        Get one or more items of complex market data from a single scope.                Each item can be identified by its time invariant complex market data identifier.                For each id LUSID will return the most recent matched item with respect to the provided (or default) effective datetime.                An optional maximum age range window can be specified which defines how far back to look back for data from the specified effective datetime.  LUSID will return the most recent item within this window.                In the request each complex market data id must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each item in the response.                The response will return three collections. One, the successfully retrieved complex market data. Two, those that had a  valid identifier but could not be found. Three, those that failed because LUSID could not construct a valid identifier from the request.                For the ids that failed to resolve or could not be found a reason will be provided explaining why that is the case.                It is important to always check the failed and not found sets for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_complex_market_data_with_http_info(scope, request_body, effective_at, as_at, max_age, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the complex market data to retrieve. (required)
        :type scope: str
        :param request_body: The time invariant set of complex data identifiers to retrieve the data for. These need to be               keyed by a unique correlation id allowing the retrieved item to be identified in the response. (required)
        :type request_body: Dict[str, ComplexMarketDataId]
        :param effective_at: The effective datetime at which to retrieve the complex market data.               Defaults to the current LUSID system datetime if not specified.               Must match the Effective at of each ComplexMarketDataId given in the request body.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param max_age: The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a complex market data item must exist to be retrieved.
        :type max_age: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetComplexMarketDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body',
            'effective_at',
            'as_at',
            'max_age'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_complex_market_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('max_age') is not None:  # noqa: E501
            _query_params.append(('maxAge', _params['max_age']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "GetComplexMarketDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/complexmarketdata/{scope}/$get', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_complex_market_data(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified. Note  that this parameter is not implemented at this time and the latest version of the ComplexMarketData will  always be returned.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ComplexMarketData; this              value is returned from the previous call. If a pagination token is provided, the effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the results to this number. If not specified, no pagination will be applied. It is  highly recommended to supply a value for this parameter as the default behaviour will change in the future.")] = None, **kwargs) -> ResourceListOfListComplexMarketDataWithMetaDataResponse:  # noqa: E501
        ...

    @overload
    def list_complex_market_data(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified. Note  that this parameter is not implemented at this time and the latest version of the ComplexMarketData will  always be returned.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ComplexMarketData; this              value is returned from the previous call. If a pagination token is provided, the effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the results to this number. If not specified, no pagination will be applied. It is  highly recommended to supply a value for this parameter as the default behaviour will change in the future.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfListComplexMarketDataWithMetaDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def list_complex_market_data(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified. Note  that this parameter is not implemented at this time and the latest version of the ComplexMarketData will  always be returned.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ComplexMarketData; this              value is returned from the previous call. If a pagination token is provided, the effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the results to this number. If not specified, no pagination will be applied. It is  highly recommended to supply a value for this parameter as the default behaviour will change in the future.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfListComplexMarketDataWithMetaDataResponse, Awaitable[ResourceListOfListComplexMarketDataWithMetaDataResponse]]:  # noqa: E501
        """ListComplexMarketData: List the set of ComplexMarketData  # noqa: E501

        List the set of ComplexMarketData at the specified date/time,  along with the scope the data was stored in and its identifier in that scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_complex_market_data(as_at, effective_at, page, limit, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified.
        :type as_at: datetime
        :param effective_at: The effectiveAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified. Note  that this parameter is not implemented at this time and the latest version of the ComplexMarketData will  always be returned.
        :type effective_at: str
        :param page: The pagination token to use to continue listing ComplexMarketData; this              value is returned from the previous call. If a pagination token is provided, the effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. If not specified, no pagination will be applied. It is  highly recommended to supply a value for this parameter as the default behaviour will change in the future.
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfListComplexMarketDataWithMetaDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_complex_market_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_complex_market_data_with_http_info(as_at, effective_at, page, limit, **kwargs)  # noqa: E501

    @validate_arguments
    def list_complex_market_data_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified. Note  that this parameter is not implemented at this time and the latest version of the ComplexMarketData will  always be returned.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ComplexMarketData; this              value is returned from the previous call. If a pagination token is provided, the effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the results to this number. If not specified, no pagination will be applied. It is  highly recommended to supply a value for this parameter as the default behaviour will change in the future.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListComplexMarketData: List the set of ComplexMarketData  # noqa: E501

        List the set of ComplexMarketData at the specified date/time,  along with the scope the data was stored in and its identifier in that scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_complex_market_data_with_http_info(as_at, effective_at, page, limit, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified.
        :type as_at: datetime
        :param effective_at: The effectiveAt datetime at which to list the ComplexMarketData. Defaults to latest if not specified. Note  that this parameter is not implemented at this time and the latest version of the ComplexMarketData will  always be returned.
        :type effective_at: str
        :param page: The pagination token to use to continue listing ComplexMarketData; this              value is returned from the previous call. If a pagination token is provided, the effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. If not specified, no pagination will be applied. It is  highly recommended to supply a value for this parameter as the default behaviour will change in the future.
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfListComplexMarketDataWithMetaDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'effective_at',
            'page',
            'limit'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_complex_market_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfListComplexMarketDataWithMetaDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/complexmarketdata', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_append_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to append.")], append_complex_market_data_request : Annotated[AppendComplexMarketDataRequest, Field(description="Request definition of the point to append.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.")] = None, **kwargs) -> UpsertSingleStructuredDataResponse:  # noqa: E501
        ...

    @overload
    def upsert_append_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to append.")], append_complex_market_data_request : Annotated[AppendComplexMarketDataRequest, Field(description="Request definition of the point to append.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> UpsertSingleStructuredDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_append_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to append.")], append_complex_market_data_request : Annotated[AppendComplexMarketDataRequest, Field(description="Request definition of the point to append.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[UpsertSingleStructuredDataResponse, Awaitable[UpsertSingleStructuredDataResponse]]:  # noqa: E501
        """[EARLY ACCESS] UpsertAppendComplexMarketData: Appends a new point to the end of a ComplexMarketData definition.  # noqa: E501

        Update a complex market data item in a single scope by appending a new point onto the end.                NOTE: This operation is only supported for FX curves with one of the following data types:  FxForwardCurveByQuoteReference, FxForwardCurveData, FxForwardPipsCurveData, FxForwardTenorCurveData, FxForwardTenorPipsCurveData  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_append_complex_market_data(scope, append_complex_market_data_request, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the complex market data to append. (required)
        :type scope: str
        :param append_complex_market_data_request: Request definition of the point to append. (required)
        :type append_complex_market_data_request: AppendComplexMarketDataRequest
        :param as_at: The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertSingleStructuredDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_append_complex_market_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_append_complex_market_data_with_http_info(scope, append_complex_market_data_request, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_append_complex_market_data_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the complex market data to append.")], append_complex_market_data_request : Annotated[AppendComplexMarketDataRequest, Field(description="Request definition of the point to append.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpsertAppendComplexMarketData: Appends a new point to the end of a ComplexMarketData definition.  # noqa: E501

        Update a complex market data item in a single scope by appending a new point onto the end.                NOTE: This operation is only supported for FX curves with one of the following data types:  FxForwardCurveByQuoteReference, FxForwardCurveData, FxForwardPipsCurveData, FxForwardTenorCurveData, FxForwardTenorPipsCurveData  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_append_complex_market_data_with_http_info(scope, append_complex_market_data_request, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the complex market data to append. (required)
        :type scope: str
        :param append_complex_market_data_request: Request definition of the point to append. (required)
        :type append_complex_market_data_request: AppendComplexMarketDataRequest
        :param as_at: The asAt datetime at which to retrieve the complex market data. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertSingleStructuredDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'append_complex_market_data_request',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_append_complex_market_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['append_complex_market_data_request'] is not None:
            _body_params = _params['append_complex_market_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpsertSingleStructuredDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/complexmarketdata/{scope}/$append', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the complex market data.")], request_body : Annotated[Dict[str, UpsertComplexMarketDataRequest], Field(description="The set of complex market data items to update or insert keyed by a unique correlation id.")], **kwargs) -> UpsertStructuredDataResponse:  # noqa: E501
        ...

    @overload
    def upsert_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the complex market data.")], request_body : Annotated[Dict[str, UpsertComplexMarketDataRequest], Field(description="The set of complex market data items to update or insert keyed by a unique correlation id.")], async_req: Optional[bool]=True, **kwargs) -> UpsertStructuredDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_complex_market_data(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the complex market data.")], request_body : Annotated[Dict[str, UpsertComplexMarketDataRequest], Field(description="The set of complex market data items to update or insert keyed by a unique correlation id.")], async_req: Optional[bool]=None, **kwargs) -> Union[UpsertStructuredDataResponse, Awaitable[UpsertStructuredDataResponse]]:  # noqa: E501
        """UpsertComplexMarketData: Upsert a set of complex market data items. This creates or updates the data in Lusid.  # noqa: E501

        Update or insert one or more complex market data items in a single scope. An item will be updated if it already exists  and inserted if it does not.                In the request each complex market data item must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each complex market data in the response.                The response will return both the collection of successfully updated or inserted complex market data, as well as those that failed.  For the failures a reason will be provided explaining why the item could not be updated or inserted.                It is important to always check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_complex_market_data(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope to use when updating or inserting the complex market data. (required)
        :type scope: str
        :param request_body: The set of complex market data items to update or insert keyed by a unique correlation id. (required)
        :type request_body: Dict[str, UpsertComplexMarketDataRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertStructuredDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_complex_market_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_complex_market_data_with_http_info(scope, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_complex_market_data_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the complex market data.")], request_body : Annotated[Dict[str, UpsertComplexMarketDataRequest], Field(description="The set of complex market data items to update or insert keyed by a unique correlation id.")], **kwargs) -> ApiResponse:  # noqa: E501
        """UpsertComplexMarketData: Upsert a set of complex market data items. This creates or updates the data in Lusid.  # noqa: E501

        Update or insert one or more complex market data items in a single scope. An item will be updated if it already exists  and inserted if it does not.                In the request each complex market data item must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each complex market data in the response.                The response will return both the collection of successfully updated or inserted complex market data, as well as those that failed.  For the failures a reason will be provided explaining why the item could not be updated or inserted.                It is important to always check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_complex_market_data_with_http_info(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope to use when updating or inserting the complex market data. (required)
        :type scope: str
        :param request_body: The set of complex market data items to update or insert keyed by a unique correlation id. (required)
        :type request_body: Dict[str, UpsertComplexMarketDataRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertStructuredDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_complex_market_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpsertStructuredDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/complexmarketdata/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
