# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from datetime import datetime
from pydantic.v1 import Field, StrictBool, StrictInt, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from lusid.models.paged_resource_list_of_order_graph_block import PagedResourceListOfOrderGraphBlock
from lusid.models.paged_resource_list_of_order_graph_placement import PagedResourceListOfOrderGraphPlacement

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class OrderGraphApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def list_order_graph_blocks(self, as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, filter : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01914/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be block-level properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, use_compliance_v2 : Annotated[Optional[StrictBool], Field(description="Whether to use the V2 compliance engine when deriving compliance statuses for orders. (default: false)")] = None, **kwargs) -> PagedResourceListOfOrderGraphBlock:  # noqa: E501
        ...

    @overload
    def list_order_graph_blocks(self, as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, filter : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01914/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be block-level properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, use_compliance_v2 : Annotated[Optional[StrictBool], Field(description="Whether to use the V2 compliance engine when deriving compliance statuses for orders. (default: false)")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfOrderGraphBlock:  # noqa: E501
        ...

    @validate_arguments
    def list_order_graph_blocks(self, as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, filter : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01914/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be block-level properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, use_compliance_v2 : Annotated[Optional[StrictBool], Field(description="Whether to use the V2 compliance engine when deriving compliance statuses for orders. (default: false)")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfOrderGraphBlock, Awaitable[PagedResourceListOfOrderGraphBlock]]:  # noqa: E501
        """ListOrderGraphBlocks: Lists blocks that pass the filter provided, and builds a summary picture of the state of their associated order entities.  # noqa: E501

        Lists all blocks of orders, subject to the filter, along with the IDs of orders, placements, allocations and  executions in the block, the total quantities of each, and a simple text field describing the overall state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_order_graph_blocks(as_at, pagination_token, sort_by, limit, filter, property_keys, use_compliance_v2, async_req=True)
        >>> result = thread.get()

        :param as_at: See https://support.lusid.com/knowledgebase/article/KA-01832/
        :type as_at: datetime
        :param pagination_token: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type pagination_token: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type limit: int
        :param filter: See https://support.lusid.com/knowledgebase/article/KA-01914/
        :type filter: str
        :param property_keys: Must be block-level properties. See https://support.lusid.com/knowledgebase/article/KA-01855/
        :type property_keys: List[str]
        :param use_compliance_v2: Whether to use the V2 compliance engine when deriving compliance statuses for orders. (default: false)
        :type use_compliance_v2: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfOrderGraphBlock
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_order_graph_blocks_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_order_graph_blocks_with_http_info(as_at, pagination_token, sort_by, limit, filter, property_keys, use_compliance_v2, **kwargs)  # noqa: E501

    @validate_arguments
    def list_order_graph_blocks_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, filter : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01914/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be block-level properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, use_compliance_v2 : Annotated[Optional[StrictBool], Field(description="Whether to use the V2 compliance engine when deriving compliance statuses for orders. (default: false)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListOrderGraphBlocks: Lists blocks that pass the filter provided, and builds a summary picture of the state of their associated order entities.  # noqa: E501

        Lists all blocks of orders, subject to the filter, along with the IDs of orders, placements, allocations and  executions in the block, the total quantities of each, and a simple text field describing the overall state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_order_graph_blocks_with_http_info(as_at, pagination_token, sort_by, limit, filter, property_keys, use_compliance_v2, async_req=True)
        >>> result = thread.get()

        :param as_at: See https://support.lusid.com/knowledgebase/article/KA-01832/
        :type as_at: datetime
        :param pagination_token: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type pagination_token: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type limit: int
        :param filter: See https://support.lusid.com/knowledgebase/article/KA-01914/
        :type filter: str
        :param property_keys: Must be block-level properties. See https://support.lusid.com/knowledgebase/article/KA-01855/
        :type property_keys: List[str]
        :param use_compliance_v2: Whether to use the V2 compliance engine when deriving compliance statuses for orders. (default: false)
        :type use_compliance_v2: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfOrderGraphBlock, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'pagination_token',
            'sort_by',
            'limit',
            'filter',
            'property_keys',
            'use_compliance_v2'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_order_graph_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('pagination_token') is not None:  # noqa: E501
            _query_params.append(('paginationToken', _params['pagination_token']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('use_compliance_v2') is not None:  # noqa: E501
            _query_params.append(('useComplianceV2', _params['use_compliance_v2']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfOrderGraphBlock",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordergraph/blocks', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_order_graph_placement_children(self, scope : Annotated[StrictStr, Field(..., description="The parent placement's scope")], code : Annotated[StrictStr, Field(..., description="The parent placement's code")], as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName.")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, **kwargs) -> PagedResourceListOfOrderGraphPlacement:  # noqa: E501
        ...

    @overload
    def list_order_graph_placement_children(self, scope : Annotated[StrictStr, Field(..., description="The parent placement's scope")], code : Annotated[StrictStr, Field(..., description="The parent placement's code")], as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName.")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfOrderGraphPlacement:  # noqa: E501
        ...

    @validate_arguments
    def list_order_graph_placement_children(self, scope : Annotated[StrictStr, Field(..., description="The parent placement's scope")], code : Annotated[StrictStr, Field(..., description="The parent placement's code")], as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName.")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfOrderGraphPlacement, Awaitable[PagedResourceListOfOrderGraphPlacement]]:  # noqa: E501
        """[EARLY ACCESS] ListOrderGraphPlacementChildren: Lists all placements for the parent placement specified by the scope and code, and builds a summary picture of the state of their associated order entities.  # noqa: E501

        Lists all child order placements, for the specified parent placement, along with the IDs of the block and order that the  placement is for, each placement's quantity, the IDs of all allocations and executions in the placement  and the total quantities of those, and a simple text field describing the overall state of the placement.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_order_graph_placement_children(scope, code, as_at, pagination_token, sort_by, limit, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The parent placement's scope (required)
        :type scope: str
        :param code: The parent placement's code (required)
        :type code: str
        :param as_at: See https://support.lusid.com/knowledgebase/article/KA-01832/
        :type as_at: datetime
        :param pagination_token: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type pagination_token: str
        :param sort_by: Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName.
        :type sort_by: List[str]
        :param limit: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type limit: int
        :param property_keys: Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfOrderGraphPlacement
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_order_graph_placement_children_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_order_graph_placement_children_with_http_info(scope, code, as_at, pagination_token, sort_by, limit, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_order_graph_placement_children_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The parent placement's scope")], code : Annotated[StrictStr, Field(..., description="The parent placement's code")], as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName.")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListOrderGraphPlacementChildren: Lists all placements for the parent placement specified by the scope and code, and builds a summary picture of the state of their associated order entities.  # noqa: E501

        Lists all child order placements, for the specified parent placement, along with the IDs of the block and order that the  placement is for, each placement's quantity, the IDs of all allocations and executions in the placement  and the total quantities of those, and a simple text field describing the overall state of the placement.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_order_graph_placement_children_with_http_info(scope, code, as_at, pagination_token, sort_by, limit, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The parent placement's scope (required)
        :type scope: str
        :param code: The parent placement's code (required)
        :type code: str
        :param as_at: See https://support.lusid.com/knowledgebase/article/KA-01832/
        :type as_at: datetime
        :param pagination_token: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type pagination_token: str
        :param sort_by: Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName.
        :type sort_by: List[str]
        :param limit: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type limit: int
        :param property_keys: Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfOrderGraphPlacement, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at',
            'pagination_token',
            'sort_by',
            'limit',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_order_graph_placement_children" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('pagination_token') is not None:  # noqa: E501
            _query_params.append(('paginationToken', _params['pagination_token']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfOrderGraphPlacement",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordergraph/placementchildren/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_order_graph_placements(self, as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, filter : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01914/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, **kwargs) -> PagedResourceListOfOrderGraphPlacement:  # noqa: E501
        ...

    @overload
    def list_order_graph_placements(self, as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, filter : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01914/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfOrderGraphPlacement:  # noqa: E501
        ...

    @validate_arguments
    def list_order_graph_placements(self, as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, filter : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01914/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfOrderGraphPlacement, Awaitable[PagedResourceListOfOrderGraphPlacement]]:  # noqa: E501
        """ListOrderGraphPlacements: Lists placements that pass the filter provided, and builds a summary picture of the state of their associated order entities.  # noqa: E501

        Lists all order placements, subject to the filter, along with the IDs of the block and order that the  placement is for, each placement's quantity, the IDs of all allocations and executions in the placement  and the total quantities of those, and a simple text field describing the overall state of the placement.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_order_graph_placements(as_at, pagination_token, sort_by, limit, filter, property_keys, async_req=True)
        >>> result = thread.get()

        :param as_at: See https://support.lusid.com/knowledgebase/article/KA-01832/
        :type as_at: datetime
        :param pagination_token: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type pagination_token: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type limit: int
        :param filter: See https://support.lusid.com/knowledgebase/article/KA-01914/
        :type filter: str
        :param property_keys: Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfOrderGraphPlacement
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_order_graph_placements_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_order_graph_placements_with_http_info(as_at, pagination_token, sort_by, limit, filter, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_order_graph_placements_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01832/")] = None, pagination_token : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[StrictInt], Field(description="See https://support.lusid.com/knowledgebase/article/KA-01915/")] = None, filter : Annotated[Optional[StrictStr], Field( description="See https://support.lusid.com/knowledgebase/article/KA-01914/")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListOrderGraphPlacements: Lists placements that pass the filter provided, and builds a summary picture of the state of their associated order entities.  # noqa: E501

        Lists all order placements, subject to the filter, along with the IDs of the block and order that the  placement is for, each placement's quantity, the IDs of all allocations and executions in the placement  and the total quantities of those, and a simple text field describing the overall state of the placement.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_order_graph_placements_with_http_info(as_at, pagination_token, sort_by, limit, filter, property_keys, async_req=True)
        >>> result = thread.get()

        :param as_at: See https://support.lusid.com/knowledgebase/article/KA-01832/
        :type as_at: datetime
        :param pagination_token: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type pagination_token: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: See https://support.lusid.com/knowledgebase/article/KA-01915/
        :type limit: int
        :param filter: See https://support.lusid.com/knowledgebase/article/KA-01914/
        :type filter: str
        :param property_keys: Must be placement properties. See https://support.lusid.com/knowledgebase/article/KA-01855/
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfOrderGraphPlacement, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'pagination_token',
            'sort_by',
            'limit',
            'filter',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_order_graph_placements" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('pagination_token') is not None:  # noqa: E501
            _query_params.append(('paginationToken', _params['pagination_token']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfOrderGraphPlacement",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordergraph/placements', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
