# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from datetime import datetime
from pydantic.v1 import Field, StrictBool
from typing import Dict, List, Optional
from typing_extensions import Annotated
from lusid.models.allocation_service_run_response import AllocationServiceRunResponse
from lusid.models.block_and_orders_create_request import BlockAndOrdersCreateRequest
from lusid.models.book_transactions_request import BookTransactionsRequest
from lusid.models.book_transactions_response import BookTransactionsResponse
from lusid.models.cancel_orders_and_move_remaining_request import CancelOrdersAndMoveRemainingRequest
from lusid.models.cancel_orders_and_move_remaining_response import CancelOrdersAndMoveRemainingResponse
from lusid.models.cancel_orders_response import CancelOrdersResponse
from lusid.models.cancel_placements_response import CancelPlacementsResponse
from lusid.models.move_orders_to_different_blocks_request import MoveOrdersToDifferentBlocksRequest
from lusid.models.order_update_request import OrderUpdateRequest
from lusid.models.place_blocks_request import PlaceBlocksRequest
from lusid.models.placement_update_request import PlacementUpdateRequest
from lusid.models.resource_id import ResourceId
from lusid.models.resource_list_of_block_and_orders import ResourceListOfBlockAndOrders
from lusid.models.resource_list_of_change_interval_with_order_management_detail import ResourceListOfChangeIntervalWithOrderManagementDetail
from lusid.models.resource_list_of_moved_order_to_different_block_response import ResourceListOfMovedOrderToDifferentBlockResponse
from lusid.models.resource_list_of_placement import ResourceListOfPlacement
from lusid.models.sweep_blocks_request import SweepBlocksRequest
from lusid.models.sweep_blocks_response import SweepBlocksResponse
from lusid.models.update_orders_response import UpdateOrdersResponse
from lusid.models.update_placements_response import UpdatePlacementsResponse

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class OrderManagementApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def book_transactions(self, book_transactions_request : Annotated[BookTransactionsRequest, Field(description="The allocations to create transactions for")], apply_fees_and_commission : Annotated[Optional[StrictBool], Field(description="Whether to apply fees and commissions to transactions (default: true)")] = None, mark_orders_and_allocations_as_booked : Annotated[Optional[StrictBool], Field(description="Whether to mark allocations and fully-booked orders with state Booked")] = None, **kwargs) -> BookTransactionsResponse:  # noqa: E501
        ...

    @overload
    def book_transactions(self, book_transactions_request : Annotated[BookTransactionsRequest, Field(description="The allocations to create transactions for")], apply_fees_and_commission : Annotated[Optional[StrictBool], Field(description="Whether to apply fees and commissions to transactions (default: true)")] = None, mark_orders_and_allocations_as_booked : Annotated[Optional[StrictBool], Field(description="Whether to mark allocations and fully-booked orders with state Booked")] = None, async_req: Optional[bool]=True, **kwargs) -> BookTransactionsResponse:  # noqa: E501
        ...

    @validate_arguments
    def book_transactions(self, book_transactions_request : Annotated[BookTransactionsRequest, Field(description="The allocations to create transactions for")], apply_fees_and_commission : Annotated[Optional[StrictBool], Field(description="Whether to apply fees and commissions to transactions (default: true)")] = None, mark_orders_and_allocations_as_booked : Annotated[Optional[StrictBool], Field(description="Whether to mark allocations and fully-booked orders with state Booked")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[BookTransactionsResponse, Awaitable[BookTransactionsResponse]]:  # noqa: E501
        """BookTransactions: Books transactions using specific allocations as a source.  # noqa: E501

        Takes a collection of allocation IDs, and maps fields from those allocations and related orders onto new transactions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.book_transactions(book_transactions_request, apply_fees_and_commission, mark_orders_and_allocations_as_booked, async_req=True)
        >>> result = thread.get()

        :param book_transactions_request: The allocations to create transactions for (required)
        :type book_transactions_request: BookTransactionsRequest
        :param apply_fees_and_commission: Whether to apply fees and commissions to transactions (default: true)
        :type apply_fees_and_commission: bool
        :param mark_orders_and_allocations_as_booked: Whether to mark allocations and fully-booked orders with state Booked
        :type mark_orders_and_allocations_as_booked: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BookTransactionsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the book_transactions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.book_transactions_with_http_info(book_transactions_request, apply_fees_and_commission, mark_orders_and_allocations_as_booked, **kwargs)  # noqa: E501

    @validate_arguments
    def book_transactions_with_http_info(self, book_transactions_request : Annotated[BookTransactionsRequest, Field(description="The allocations to create transactions for")], apply_fees_and_commission : Annotated[Optional[StrictBool], Field(description="Whether to apply fees and commissions to transactions (default: true)")] = None, mark_orders_and_allocations_as_booked : Annotated[Optional[StrictBool], Field(description="Whether to mark allocations and fully-booked orders with state Booked")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """BookTransactions: Books transactions using specific allocations as a source.  # noqa: E501

        Takes a collection of allocation IDs, and maps fields from those allocations and related orders onto new transactions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.book_transactions_with_http_info(book_transactions_request, apply_fees_and_commission, mark_orders_and_allocations_as_booked, async_req=True)
        >>> result = thread.get()

        :param book_transactions_request: The allocations to create transactions for (required)
        :type book_transactions_request: BookTransactionsRequest
        :param apply_fees_and_commission: Whether to apply fees and commissions to transactions (default: true)
        :type apply_fees_and_commission: bool
        :param mark_orders_and_allocations_as_booked: Whether to mark allocations and fully-booked orders with state Booked
        :type mark_orders_and_allocations_as_booked: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BookTransactionsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'book_transactions_request',
            'apply_fees_and_commission',
            'mark_orders_and_allocations_as_booked'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method book_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('apply_fees_and_commission') is not None:  # noqa: E501
            _query_params.append(('applyFeesAndCommission', _params['apply_fees_and_commission']))

        if _params.get('mark_orders_and_allocations_as_booked') is not None:  # noqa: E501
            _query_params.append(('markOrdersAndAllocationsAsBooked', _params['mark_orders_and_allocations_as_booked']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['book_transactions_request'] is not None:
            _body_params = _params['book_transactions_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "BookTransactionsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/booktransactions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def cancel_orders(self, request_body : Annotated[Dict[str, ResourceId], Field(description="The request containing the ids of the orders to be cancelled.")], **kwargs) -> CancelOrdersResponse:  # noqa: E501
        ...

    @overload
    def cancel_orders(self, request_body : Annotated[Dict[str, ResourceId], Field(description="The request containing the ids of the orders to be cancelled.")], async_req: Optional[bool]=True, **kwargs) -> CancelOrdersResponse:  # noqa: E501
        ...

    @validate_arguments
    def cancel_orders(self, request_body : Annotated[Dict[str, ResourceId], Field(description="The request containing the ids of the orders to be cancelled.")], async_req: Optional[bool]=None, **kwargs) -> Union[CancelOrdersResponse, Awaitable[CancelOrdersResponse]]:  # noqa: E501
        """[EARLY ACCESS] CancelOrders: Cancel existing orders  # noqa: E501

        The response returns both the collection of successfully canceled orders, as well as those  that failed. For each failure, a reason is provided. It is important to check the failed set for  unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_orders(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The request containing the ids of the orders to be cancelled. (required)
        :type request_body: Dict[str, ResourceId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CancelOrdersResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the cancel_orders_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.cancel_orders_with_http_info(request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def cancel_orders_with_http_info(self, request_body : Annotated[Dict[str, ResourceId], Field(description="The request containing the ids of the orders to be cancelled.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] CancelOrders: Cancel existing orders  # noqa: E501

        The response returns both the collection of successfully canceled orders, as well as those  that failed. For each failure, a reason is provided. It is important to check the failed set for  unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_orders_with_http_info(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The request containing the ids of the orders to be cancelled. (required)
        :type request_body: Dict[str, ResourceId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CancelOrdersResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_orders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CancelOrdersResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/cancelorders', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def cancel_orders_and_move_remaining(self, request_body : Annotated[Dict[str, CancelOrdersAndMoveRemainingRequest], Field(description="The request containing the orders to be cancelled, and the destinations of remaining quantities.")], **kwargs) -> CancelOrdersAndMoveRemainingResponse:  # noqa: E501
        ...

    @overload
    def cancel_orders_and_move_remaining(self, request_body : Annotated[Dict[str, CancelOrdersAndMoveRemainingRequest], Field(description="The request containing the orders to be cancelled, and the destinations of remaining quantities.")], async_req: Optional[bool]=True, **kwargs) -> CancelOrdersAndMoveRemainingResponse:  # noqa: E501
        ...

    @validate_arguments
    def cancel_orders_and_move_remaining(self, request_body : Annotated[Dict[str, CancelOrdersAndMoveRemainingRequest], Field(description="The request containing the orders to be cancelled, and the destinations of remaining quantities.")], async_req: Optional[bool]=None, **kwargs) -> Union[CancelOrdersAndMoveRemainingResponse, Awaitable[CancelOrdersAndMoveRemainingResponse]]:  # noqa: E501
        """[EARLY ACCESS] CancelOrdersAndMoveRemaining: Cancel existing orders and move any unplaced quantities to new orders in new blocks  # noqa: E501

        Cancels existing orders, reducing their quantities to those aleady placed. Any remaining quantities are moved  to new orders in new blocks. The placed quantities are distributed to the cancelled orders on a pro-rata basis.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_orders_and_move_remaining(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The request containing the orders to be cancelled, and the destinations of remaining quantities. (required)
        :type request_body: Dict[str, CancelOrdersAndMoveRemainingRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CancelOrdersAndMoveRemainingResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the cancel_orders_and_move_remaining_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.cancel_orders_and_move_remaining_with_http_info(request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def cancel_orders_and_move_remaining_with_http_info(self, request_body : Annotated[Dict[str, CancelOrdersAndMoveRemainingRequest], Field(description="The request containing the orders to be cancelled, and the destinations of remaining quantities.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] CancelOrdersAndMoveRemaining: Cancel existing orders and move any unplaced quantities to new orders in new blocks  # noqa: E501

        Cancels existing orders, reducing their quantities to those aleady placed. Any remaining quantities are moved  to new orders in new blocks. The placed quantities are distributed to the cancelled orders on a pro-rata basis.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_orders_and_move_remaining_with_http_info(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The request containing the orders to be cancelled, and the destinations of remaining quantities. (required)
        :type request_body: Dict[str, CancelOrdersAndMoveRemainingRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CancelOrdersAndMoveRemainingResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_orders_and_move_remaining" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CancelOrdersAndMoveRemainingResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/cancelordersandmoveremaining', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def cancel_placements(self, request_body : Annotated[Dict[str, ResourceId], Field(description="The request containing the ids of the placements to be cancelled.")], **kwargs) -> CancelPlacementsResponse:  # noqa: E501
        ...

    @overload
    def cancel_placements(self, request_body : Annotated[Dict[str, ResourceId], Field(description="The request containing the ids of the placements to be cancelled.")], async_req: Optional[bool]=True, **kwargs) -> CancelPlacementsResponse:  # noqa: E501
        ...

    @validate_arguments
    def cancel_placements(self, request_body : Annotated[Dict[str, ResourceId], Field(description="The request containing the ids of the placements to be cancelled.")], async_req: Optional[bool]=None, **kwargs) -> Union[CancelPlacementsResponse, Awaitable[CancelPlacementsResponse]]:  # noqa: E501
        """[EARLY ACCESS] CancelPlacements: Cancel existing placements  # noqa: E501

        The response returns both the collection of successfully canceled placements, as well as those  that failed. For each failure, a reason is provided. It is important to check the failed set for  unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_placements(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The request containing the ids of the placements to be cancelled. (required)
        :type request_body: Dict[str, ResourceId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CancelPlacementsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the cancel_placements_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.cancel_placements_with_http_info(request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def cancel_placements_with_http_info(self, request_body : Annotated[Dict[str, ResourceId], Field(description="The request containing the ids of the placements to be cancelled.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] CancelPlacements: Cancel existing placements  # noqa: E501

        The response returns both the collection of successfully canceled placements, as well as those  that failed. For each failure, a reason is provided. It is important to check the failed set for  unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_placements_with_http_info(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The request containing the ids of the placements to be cancelled. (required)
        :type request_body: Dict[str, ResourceId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CancelPlacementsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_placements" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CancelPlacementsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/$cancelplacements', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_orders(self, block_and_orders_create_request : Annotated[BlockAndOrdersCreateRequest, Field(description="The collection of block and orders requests.")], **kwargs) -> ResourceListOfBlockAndOrders:  # noqa: E501
        ...

    @overload
    def create_orders(self, block_and_orders_create_request : Annotated[BlockAndOrdersCreateRequest, Field(description="The collection of block and orders requests.")], async_req: Optional[bool]=True, **kwargs) -> ResourceListOfBlockAndOrders:  # noqa: E501
        ...

    @validate_arguments
    def create_orders(self, block_and_orders_create_request : Annotated[BlockAndOrdersCreateRequest, Field(description="The collection of block and orders requests.")], async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfBlockAndOrders, Awaitable[ResourceListOfBlockAndOrders]]:  # noqa: E501
        """CreateOrders: Upsert a Block and associated orders  # noqa: E501

        Create orders, and blocks if they don't already exist.  This will fail if the block exists and already references orders with differing blocking fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_orders(block_and_orders_create_request, async_req=True)
        >>> result = thread.get()

        :param block_and_orders_create_request: The collection of block and orders requests. (required)
        :type block_and_orders_create_request: BlockAndOrdersCreateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfBlockAndOrders
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_orders_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_orders_with_http_info(block_and_orders_create_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_orders_with_http_info(self, block_and_orders_create_request : Annotated[BlockAndOrdersCreateRequest, Field(description="The collection of block and orders requests.")], **kwargs) -> ApiResponse:  # noqa: E501
        """CreateOrders: Upsert a Block and associated orders  # noqa: E501

        Create orders, and blocks if they don't already exist.  This will fail if the block exists and already references orders with differing blocking fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_orders_with_http_info(block_and_orders_create_request, async_req=True)
        >>> result = thread.get()

        :param block_and_orders_create_request: The collection of block and orders requests. (required)
        :type block_and_orders_create_request: BlockAndOrdersCreateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfBlockAndOrders, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'block_and_orders_create_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_orders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['block_and_orders_create_request'] is not None:
            _body_params = _params['block_and_orders_create_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "ResourceListOfBlockAndOrders",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/createorders', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_order_history(self, scope : Annotated[StrictStr, Field(..., description="The scope of the order.")], code : Annotated[StrictStr, Field(..., description="The code of the order.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the history of the order and related entities. Defaults              to return the latest version if not specified.")] = None, **kwargs) -> ResourceListOfChangeIntervalWithOrderManagementDetail:  # noqa: E501
        ...

    @overload
    def get_order_history(self, scope : Annotated[StrictStr, Field(..., description="The scope of the order.")], code : Annotated[StrictStr, Field(..., description="The code of the order.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the history of the order and related entities. Defaults              to return the latest version if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfChangeIntervalWithOrderManagementDetail:  # noqa: E501
        ...

    @validate_arguments
    def get_order_history(self, scope : Annotated[StrictStr, Field(..., description="The scope of the order.")], code : Annotated[StrictStr, Field(..., description="The code of the order.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the history of the order and related entities. Defaults              to return the latest version if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfChangeIntervalWithOrderManagementDetail, Awaitable[ResourceListOfChangeIntervalWithOrderManagementDetail]]:  # noqa: E501
        """GetOrderHistory: Get the history of an order and related entity changes  # noqa: E501

        Get the changes that have happened to an order and related entities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_order_history(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the order. (required)
        :type scope: str
        :param code: The code of the order. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the history of the order and related entities. Defaults              to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfChangeIntervalWithOrderManagementDetail
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_order_history_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_order_history_with_http_info(scope, code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_order_history_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the order.")], code : Annotated[StrictStr, Field(..., description="The code of the order.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the history of the order and related entities. Defaults              to return the latest version if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetOrderHistory: Get the history of an order and related entity changes  # noqa: E501

        Get the changes that have happened to an order and related entities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_order_history_with_http_info(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the order. (required)
        :type scope: str
        :param code: The code of the order. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the history of the order and related entities. Defaults              to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfChangeIntervalWithOrderManagementDetail, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_history" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfChangeIntervalWithOrderManagementDetail",
            '400': "LusidValidationProblemDetails",
            '404': "str",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/order/{scope}/{code}/$history', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def move_orders(self, move_orders_to_different_blocks_request : Annotated[MoveOrdersToDifferentBlocksRequest, Field(description="The collection of order and destination block ids.")], **kwargs) -> ResourceListOfMovedOrderToDifferentBlockResponse:  # noqa: E501
        ...

    @overload
    def move_orders(self, move_orders_to_different_blocks_request : Annotated[MoveOrdersToDifferentBlocksRequest, Field(description="The collection of order and destination block ids.")], async_req: Optional[bool]=True, **kwargs) -> ResourceListOfMovedOrderToDifferentBlockResponse:  # noqa: E501
        ...

    @validate_arguments
    def move_orders(self, move_orders_to_different_blocks_request : Annotated[MoveOrdersToDifferentBlocksRequest, Field(description="The collection of order and destination block ids.")], async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfMovedOrderToDifferentBlockResponse, Awaitable[ResourceListOfMovedOrderToDifferentBlockResponse]]:  # noqa: E501
        """[EARLY ACCESS] MoveOrders: Move orders to new or existing block  # noqa: E501

        Move an order to a block, creating the block if it does not already exist.   This will fail if the block exists and already references orders with differing fields to the upsert request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.move_orders(move_orders_to_different_blocks_request, async_req=True)
        >>> result = thread.get()

        :param move_orders_to_different_blocks_request: The collection of order and destination block ids. (required)
        :type move_orders_to_different_blocks_request: MoveOrdersToDifferentBlocksRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfMovedOrderToDifferentBlockResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the move_orders_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.move_orders_with_http_info(move_orders_to_different_blocks_request, **kwargs)  # noqa: E501

    @validate_arguments
    def move_orders_with_http_info(self, move_orders_to_different_blocks_request : Annotated[MoveOrdersToDifferentBlocksRequest, Field(description="The collection of order and destination block ids.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] MoveOrders: Move orders to new or existing block  # noqa: E501

        Move an order to a block, creating the block if it does not already exist.   This will fail if the block exists and already references orders with differing fields to the upsert request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.move_orders_with_http_info(move_orders_to_different_blocks_request, async_req=True)
        >>> result = thread.get()

        :param move_orders_to_different_blocks_request: The collection of order and destination block ids. (required)
        :type move_orders_to_different_blocks_request: MoveOrdersToDifferentBlocksRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfMovedOrderToDifferentBlockResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'move_orders_to_different_blocks_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_orders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['move_orders_to_different_blocks_request'] is not None:
            _body_params = _params['move_orders_to_different_blocks_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfMovedOrderToDifferentBlockResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/moveorders', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def place_blocks(self, place_blocks_request : Annotated[Optional[PlaceBlocksRequest], Field(description="The request containing the blocks to the placed.")] = None, **kwargs) -> ResourceListOfPlacement:  # noqa: E501
        ...

    @overload
    def place_blocks(self, place_blocks_request : Annotated[Optional[PlaceBlocksRequest], Field(description="The request containing the blocks to the placed.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfPlacement:  # noqa: E501
        ...

    @validate_arguments
    def place_blocks(self, place_blocks_request : Annotated[Optional[PlaceBlocksRequest], Field(description="The request containing the blocks to the placed.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfPlacement, Awaitable[ResourceListOfPlacement]]:  # noqa: E501
        """[EARLY ACCESS] PlaceBlocks: Places blocks for a given list of placement requests.  # noqa: E501

        The referenced block's existence will be verified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.place_blocks(place_blocks_request, async_req=True)
        >>> result = thread.get()

        :param place_blocks_request: The request containing the blocks to the placed.
        :type place_blocks_request: PlaceBlocksRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfPlacement
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the place_blocks_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.place_blocks_with_http_info(place_blocks_request, **kwargs)  # noqa: E501

    @validate_arguments
    def place_blocks_with_http_info(self, place_blocks_request : Annotated[Optional[PlaceBlocksRequest], Field(description="The request containing the blocks to the placed.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] PlaceBlocks: Places blocks for a given list of placement requests.  # noqa: E501

        The referenced block's existence will be verified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.place_blocks_with_http_info(place_blocks_request, async_req=True)
        >>> result = thread.get()

        :param place_blocks_request: The request containing the blocks to the placed.
        :type place_blocks_request: PlaceBlocksRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfPlacement, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'place_blocks_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method place_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['place_blocks_request'] is not None:
            _body_params = _params['place_blocks_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfPlacement",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/placeblocks', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def run_allocation_service(self, resource_id : Annotated[List[ResourceId], Field(description="The List of Placement IDs for which you wish to allocate Executions.")], allocation_algorithm : Annotated[Optional[StrictStr], Field( description="A string representation of the allocation algorithm you would like to use to allocate shares from executions e.g. \"PR-FIFO\".  This defaults to \"PR-FIFO\".")] = None, **kwargs) -> AllocationServiceRunResponse:  # noqa: E501
        ...

    @overload
    def run_allocation_service(self, resource_id : Annotated[List[ResourceId], Field(description="The List of Placement IDs for which you wish to allocate Executions.")], allocation_algorithm : Annotated[Optional[StrictStr], Field( description="A string representation of the allocation algorithm you would like to use to allocate shares from executions e.g. \"PR-FIFO\".  This defaults to \"PR-FIFO\".")] = None, async_req: Optional[bool]=True, **kwargs) -> AllocationServiceRunResponse:  # noqa: E501
        ...

    @validate_arguments
    def run_allocation_service(self, resource_id : Annotated[List[ResourceId], Field(description="The List of Placement IDs for which you wish to allocate Executions.")], allocation_algorithm : Annotated[Optional[StrictStr], Field( description="A string representation of the allocation algorithm you would like to use to allocate shares from executions e.g. \"PR-FIFO\".  This defaults to \"PR-FIFO\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[AllocationServiceRunResponse, Awaitable[AllocationServiceRunResponse]]:  # noqa: E501
        """RunAllocationService: Runs the Allocation Service  # noqa: E501

        Allocates Executions for a given list of placements back to their originating orders using one of the LUSID algorithms, creating Allocations to record the results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_allocation_service(resource_id, allocation_algorithm, async_req=True)
        >>> result = thread.get()

        :param resource_id: The List of Placement IDs for which you wish to allocate Executions. (required)
        :type resource_id: List[ResourceId]
        :param allocation_algorithm: A string representation of the allocation algorithm you would like to use to allocate shares from executions e.g. \"PR-FIFO\".  This defaults to \"PR-FIFO\".
        :type allocation_algorithm: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AllocationServiceRunResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the run_allocation_service_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.run_allocation_service_with_http_info(resource_id, allocation_algorithm, **kwargs)  # noqa: E501

    @validate_arguments
    def run_allocation_service_with_http_info(self, resource_id : Annotated[List[ResourceId], Field(description="The List of Placement IDs for which you wish to allocate Executions.")], allocation_algorithm : Annotated[Optional[StrictStr], Field( description="A string representation of the allocation algorithm you would like to use to allocate shares from executions e.g. \"PR-FIFO\".  This defaults to \"PR-FIFO\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """RunAllocationService: Runs the Allocation Service  # noqa: E501

        Allocates Executions for a given list of placements back to their originating orders using one of the LUSID algorithms, creating Allocations to record the results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_allocation_service_with_http_info(resource_id, allocation_algorithm, async_req=True)
        >>> result = thread.get()

        :param resource_id: The List of Placement IDs for which you wish to allocate Executions. (required)
        :type resource_id: List[ResourceId]
        :param allocation_algorithm: A string representation of the allocation algorithm you would like to use to allocate shares from executions e.g. \"PR-FIFO\".  This defaults to \"PR-FIFO\".
        :type allocation_algorithm: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AllocationServiceRunResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'resource_id',
            'allocation_algorithm'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_allocation_service" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('allocation_algorithm') is not None:  # noqa: E501
            _query_params.append(('allocationAlgorithm', _params['allocation_algorithm']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['resource_id'] is not None:
            _body_params = _params['resource_id']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AllocationServiceRunResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/allocate', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def sweep_blocks(self, sweep_blocks_request : SweepBlocksRequest, **kwargs) -> SweepBlocksResponse:  # noqa: E501
        ...

    @overload
    def sweep_blocks(self, sweep_blocks_request : SweepBlocksRequest, async_req: Optional[bool]=True, **kwargs) -> SweepBlocksResponse:  # noqa: E501
        ...

    @validate_arguments
    def sweep_blocks(self, sweep_blocks_request : SweepBlocksRequest, async_req: Optional[bool]=None, **kwargs) -> Union[SweepBlocksResponse, Awaitable[SweepBlocksResponse]]:  # noqa: E501
        """[EXPERIMENTAL] SweepBlocks: Sweeps specified blocks, for each block that meets the requirements. The request may be partially successful.  # noqa: E501

        The requirements are:  <list type=\"bullet\"><term>The block exists.</term><term>All orders have state \"Closed\", \"Cancelled\", \"Canceled\" or \"Booked\".</term><term>All placements have state \"Allocated\" or \"Over-allocated\".</term><term>All allocations have state \"Closed\", \"Cancelled\", \"Canceled\" or \"Booked\".</term><term>No execution or allocation has been modified since the passed LatestAllowableModificationTime.</term></list>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sweep_blocks(sweep_blocks_request, async_req=True)
        >>> result = thread.get()

        :param sweep_blocks_request: (required)
        :type sweep_blocks_request: SweepBlocksRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SweepBlocksResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the sweep_blocks_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.sweep_blocks_with_http_info(sweep_blocks_request, **kwargs)  # noqa: E501

    @validate_arguments
    def sweep_blocks_with_http_info(self, sweep_blocks_request : SweepBlocksRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] SweepBlocks: Sweeps specified blocks, for each block that meets the requirements. The request may be partially successful.  # noqa: E501

        The requirements are:  <list type=\"bullet\"><term>The block exists.</term><term>All orders have state \"Closed\", \"Cancelled\", \"Canceled\" or \"Booked\".</term><term>All placements have state \"Allocated\" or \"Over-allocated\".</term><term>All allocations have state \"Closed\", \"Cancelled\", \"Canceled\" or \"Booked\".</term><term>No execution or allocation has been modified since the passed LatestAllowableModificationTime.</term></list>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sweep_blocks_with_http_info(sweep_blocks_request, async_req=True)
        >>> result = thread.get()

        :param sweep_blocks_request: (required)
        :type sweep_blocks_request: SweepBlocksRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SweepBlocksResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'sweep_blocks_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sweep_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['sweep_blocks_request'] is not None:
            _body_params = _params['sweep_blocks_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "SweepBlocksResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/SweepBlocks', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_orders(self, request_body : Annotated[Dict[str, OrderUpdateRequest], Field(description="The request containing the orders to be updated.")], **kwargs) -> UpdateOrdersResponse:  # noqa: E501
        ...

    @overload
    def update_orders(self, request_body : Annotated[Dict[str, OrderUpdateRequest], Field(description="The request containing the orders to be updated.")], async_req: Optional[bool]=True, **kwargs) -> UpdateOrdersResponse:  # noqa: E501
        ...

    @validate_arguments
    def update_orders(self, request_body : Annotated[Dict[str, OrderUpdateRequest], Field(description="The request containing the orders to be updated.")], async_req: Optional[bool]=None, **kwargs) -> Union[UpdateOrdersResponse, Awaitable[UpdateOrdersResponse]]:  # noqa: E501
        """[EARLY ACCESS] UpdateOrders: Update existing orders  # noqa: E501

        The response returns both the collection of successfully updated orders, as well as those  that failed. For each failure, a reason is provided. It is important to check the failed set for  unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_orders(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The request containing the orders to be updated. (required)
        :type request_body: Dict[str, OrderUpdateRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpdateOrdersResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_orders_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_orders_with_http_info(request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_orders_with_http_info(self, request_body : Annotated[Dict[str, OrderUpdateRequest], Field(description="The request containing the orders to be updated.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdateOrders: Update existing orders  # noqa: E501

        The response returns both the collection of successfully updated orders, as well as those  that failed. For each failure, a reason is provided. It is important to check the failed set for  unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_orders_with_http_info(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The request containing the orders to be updated. (required)
        :type request_body: Dict[str, OrderUpdateRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpdateOrdersResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_orders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpdateOrdersResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/updateorders', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_placements(self, request_body : Annotated[Dict[str, PlacementUpdateRequest], Field(description="The request containing the placements to be updated.")], **kwargs) -> UpdatePlacementsResponse:  # noqa: E501
        ...

    @overload
    def update_placements(self, request_body : Annotated[Dict[str, PlacementUpdateRequest], Field(description="The request containing the placements to be updated.")], async_req: Optional[bool]=True, **kwargs) -> UpdatePlacementsResponse:  # noqa: E501
        ...

    @validate_arguments
    def update_placements(self, request_body : Annotated[Dict[str, PlacementUpdateRequest], Field(description="The request containing the placements to be updated.")], async_req: Optional[bool]=None, **kwargs) -> Union[UpdatePlacementsResponse, Awaitable[UpdatePlacementsResponse]]:  # noqa: E501
        """[EARLY ACCESS] UpdatePlacements: Update existing placements  # noqa: E501

        The response returns both the collection of successfully updated placements, as well as those  that failed. For each failure, a reason is provided. It is important to check the failed set for  unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_placements(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The request containing the placements to be updated. (required)
        :type request_body: Dict[str, PlacementUpdateRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpdatePlacementsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_placements_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_placements_with_http_info(request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_placements_with_http_info(self, request_body : Annotated[Dict[str, PlacementUpdateRequest], Field(description="The request containing the placements to be updated.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdatePlacements: Update existing placements  # noqa: E501

        The response returns both the collection of successfully updated placements, as well as those  that failed. For each failure, a reason is provided. It is important to check the failed set for  unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_placements_with_http_info(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: The request containing the placements to be updated. (required)
        :type request_body: Dict[str, PlacementUpdateRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpdatePlacementsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_placements" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpdatePlacementsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/ordermanagement/$updateplacements', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
