# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from datetime import datetime
from pydantic.v1 import Field, StrictInt, StrictStr
from typing import Dict, List, Optional
from typing_extensions import Annotated
from lusid.models.access_metadata_operation import AccessMetadataOperation
from lusid.models.access_metadata_value import AccessMetadataValue
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.paged_resource_list_of_person import PagedResourceListOfPerson
from lusid.models.person import Person
from lusid.models.resource_list_of_access_metadata_value_of import ResourceListOfAccessMetadataValueOf
from lusid.models.resource_list_of_person import ResourceListOfPerson
from lusid.models.resource_list_of_property_interval import ResourceListOfPropertyInterval
from lusid.models.resource_list_of_relation import ResourceListOfRelation
from lusid.models.resource_list_of_relationship import ResourceListOfRelationship
from lusid.models.set_person_identifiers_request import SetPersonIdentifiersRequest
from lusid.models.set_person_properties_request import SetPersonPropertiesRequest
from lusid.models.upsert_person_access_metadata_request import UpsertPersonAccessMetadataRequest
from lusid.models.upsert_person_request import UpsertPersonRequest
from lusid.models.upsert_persons_response import UpsertPersonsResponse

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class PersonsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def delete_person(self, id_type_scope : Annotated[StrictStr, Field(..., description="The scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="The code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type scope and code. This together with defined              identifier type uniquely identifies the person to delete.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_person(self, id_type_scope : Annotated[StrictStr, Field(..., description="The scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="The code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type scope and code. This together with defined              identifier type uniquely identifies the person to delete.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_person(self, id_type_scope : Annotated[StrictStr, Field(..., description="The scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="The code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type scope and code. This together with defined              identifier type uniquely identifies the person to delete.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """DeletePerson: Delete person  # noqa: E501

        Delete a person. Deletion will be valid from the person's creation datetime.  This means that the person will no longer exist at any effective datetime from the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: The scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: The code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type scope and code. This together with defined              identifier type uniquely identifies the person to delete. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_person_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_person_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_person_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="The scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="The code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type scope and code. This together with defined              identifier type uniquely identifies the person to delete.")], **kwargs) -> ApiResponse:  # noqa: E501
        """DeletePerson: Delete person  # noqa: E501

        Delete a person. Deletion will be valid from the person's creation datetime.  This means that the person will no longer exist at any effective datetime from the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: The scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: The code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type scope and code. This together with defined              identifier type uniquely identifies the person to delete. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_person" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective date to delete at, if this is not supplied, it will delete all data found")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective date until which the delete is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata")] = None, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective date to delete at, if this is not supplied, it will delete all data found")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective date until which the delete is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata")] = None, async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective date to delete at, if this is not supplied, it will delete all data found")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective date until which the delete is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EARLY ACCESS] DeletePersonAccessMetadata: Delete a Person Access Metadata entry  # noqa: E501

        Deletes the Person Access Metadata entry that exactly matches the provided identifier parts.    It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person_access_metadata(id_type_scope, id_type_code, code, metadata_key, effective_at, effective_until, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param effective_at: The effective date to delete at, if this is not supplied, it will delete all data found
        :type effective_at: str
        :param effective_until: The effective date until which the delete is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_person_access_metadata_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, effective_at, effective_until, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_person_access_metadata_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective date to delete at, if this is not supplied, it will delete all data found")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective date until which the delete is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeletePersonAccessMetadata: Delete a Person Access Metadata entry  # noqa: E501

        Deletes the Person Access Metadata entry that exactly matches the provided identifier parts.    It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, effective_at, effective_until, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param effective_at: The effective date to delete at, if this is not supplied, it will delete all data found
        :type effective_at: str
        :param effective_until: The effective date until which the delete is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'metadata_key',
            'effective_at',
            'effective_until'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_person_access_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['metadata_key']:
            _path_params['metadataKey'] = _params['metadata_key']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('effective_until') is not None:  # noqa: E501
            if isinstance(_params['effective_until'], datetime):
                _query_params.append(('effectiveUntil', _params['effective_until'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('effectiveUntil', _params['effective_until']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_person_identifiers(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[List[StrictStr], Field(description="The property keys of the identifiers to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Identifiers or identifiers not specified in request will not be changed.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete the identifiers. Defaults to the current LUSID system datetime if not specified.              Must not include an effective datetime if identifiers are perpetual.")] = None, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_person_identifiers(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[List[StrictStr], Field(description="The property keys of the identifiers to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Identifiers or identifiers not specified in request will not be changed.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete the identifiers. Defaults to the current LUSID system datetime if not specified.              Must not include an effective datetime if identifiers are perpetual.")] = None, async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_person_identifiers(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[List[StrictStr], Field(description="The property keys of the identifiers to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Identifiers or identifiers not specified in request will not be changed.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete the identifiers. Defaults to the current LUSID system datetime if not specified.              Must not include an effective datetime if identifiers are perpetual.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EARLY ACCESS] DeletePersonIdentifiers: Delete Person Identifiers  # noqa: E501

        Delete identifiers that belong to the given property keys of the person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person_identifiers(id_type_scope, id_type_code, code, property_keys, effective_at, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param property_keys: The property keys of the identifiers to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Identifiers or identifiers not specified in request will not be changed. (required)
        :type property_keys: List[str]
        :param effective_at: The effective datetime or cut label at which to delete the identifiers. Defaults to the current LUSID system datetime if not specified.              Must not include an effective datetime if identifiers are perpetual.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_person_identifiers_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_person_identifiers_with_http_info(id_type_scope, id_type_code, code, property_keys, effective_at, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_person_identifiers_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[List[StrictStr], Field(description="The property keys of the identifiers to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Identifiers or identifiers not specified in request will not be changed.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete the identifiers. Defaults to the current LUSID system datetime if not specified.              Must not include an effective datetime if identifiers are perpetual.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeletePersonIdentifiers: Delete Person Identifiers  # noqa: E501

        Delete identifiers that belong to the given property keys of the person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person_identifiers_with_http_info(id_type_scope, id_type_code, code, property_keys, effective_at, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param property_keys: The property keys of the identifiers to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Identifiers or identifiers not specified in request will not be changed. (required)
        :type property_keys: List[str]
        :param effective_at: The effective datetime or cut label at which to delete the identifiers. Defaults to the current LUSID system datetime if not specified.              Must not include an effective datetime if identifiers are perpetual.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'property_keys',
            'effective_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_person_identifiers" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/identifiers', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_person_properties(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[List[StrictStr], Field(description="The property keys of the person's properties to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Properties or identifiers not specified in request will not be changed.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.              The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is              before the time-variant property exists then a failure is returned. Do not specify this parameter if any of              the properties to delete are perpetual.")] = None, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_person_properties(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[List[StrictStr], Field(description="The property keys of the person's properties to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Properties or identifiers not specified in request will not be changed.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.              The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is              before the time-variant property exists then a failure is returned. Do not specify this parameter if any of              the properties to delete are perpetual.")] = None, async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_person_properties(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[List[StrictStr], Field(description="The property keys of the person's properties to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Properties or identifiers not specified in request will not be changed.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.              The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is              before the time-variant property exists then a failure is returned. Do not specify this parameter if any of              the properties to delete are perpetual.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EARLY ACCESS] DeletePersonProperties: Delete Person Properties  # noqa: E501

        Delete all properties that belong to the given property keys of the person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person_properties(id_type_scope, id_type_code, code, property_keys, effective_at, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param property_keys: The property keys of the person's properties to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Properties or identifiers not specified in request will not be changed. (required)
        :type property_keys: List[str]
        :param effective_at: The effective datetime or cut label at which to delete time-variant properties from.              The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is              before the time-variant property exists then a failure is returned. Do not specify this parameter if any of              the properties to delete are perpetual.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_person_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_person_properties_with_http_info(id_type_scope, id_type_code, code, property_keys, effective_at, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_person_properties_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[List[StrictStr], Field(description="The property keys of the person's properties to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Properties or identifiers not specified in request will not be changed.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.              The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is              before the time-variant property exists then a failure is returned. Do not specify this parameter if any of              the properties to delete are perpetual.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeletePersonProperties: Delete Person Properties  # noqa: E501

        Delete all properties that belong to the given property keys of the person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person_properties_with_http_info(id_type_scope, id_type_code, code, property_keys, effective_at, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param property_keys: The property keys of the person's properties to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Properties or identifiers not specified in request will not be changed. (required)
        :type property_keys: List[str]
        :param effective_at: The effective datetime or cut label at which to delete time-variant properties from.              The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is              before the time-variant property exists then a failure is returned. Do not specify this parameter if any of              the properties to delete are perpetual.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'property_keys',
            'effective_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_person_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/properties', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_all_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Access Metadata")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Access Metadata")] = None, **kwargs) -> Dict[str, List[AccessMetadataValue]]:  # noqa: E501
        ...

    @overload
    def get_all_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Access Metadata")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Access Metadata")] = None, async_req: Optional[bool]=True, **kwargs) -> Dict[str, List[AccessMetadataValue]]:  # noqa: E501
        ...

    @validate_arguments
    def get_all_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Access Metadata")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Access Metadata")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Dict[str, List[AccessMetadataValue]], Awaitable[Dict[str, List[AccessMetadataValue]]]]:  # noqa: E501
        """[EARLY ACCESS] GetAllPersonAccessMetadata: Get Access Metadata rules for a Person  # noqa: E501

        Pass the Scope and Code of the Person identifier along with the person code parameter to retrieve the associated Access Metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_person_access_metadata(id_type_scope, id_type_code, code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, List[AccessMetadataValue]]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_all_person_access_metadata_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_all_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, effective_at, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_all_person_access_metadata_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Access Metadata")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Access Metadata")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetAllPersonAccessMetadata: Get Access Metadata rules for a Person  # noqa: E501

        Pass the Scope and Code of the Person identifier along with the person code parameter to retrieve the associated Access Metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, List[AccessMetadataValue]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'effective_at',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_person_access_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, List[AccessMetadataValue]]",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_person(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto the person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the person. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the person. Defaults to return the latest version of the person if not specified.")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the person in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, **kwargs) -> Person:  # noqa: E501
        ...

    @overload
    def get_person(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto the person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the person. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the person. Defaults to return the latest version of the person if not specified.")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the person in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, async_req: Optional[bool]=True, **kwargs) -> Person:  # noqa: E501
        ...

    @validate_arguments
    def get_person(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto the person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the person. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the person. Defaults to return the latest version of the person if not specified.")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the person in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Person, Awaitable[Person]]:  # noqa: E501
        """[EARLY ACCESS] GetPerson: Get Person  # noqa: E501

        Retrieve the definition of a person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person(id_type_scope, id_type_code, code, property_keys, effective_at, as_at, relationship_definition_ids, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param property_keys: A list of property keys from the \"Person\" domain to decorate onto the person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".
        :type property_keys: List[str]
        :param effective_at: The effective datetime or cut label at which to retrieve the person. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the person. Defaults to return the latest version of the person if not specified.
        :type as_at: datetime
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the person in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Person
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_person_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_person_with_http_info(id_type_scope, id_type_code, code, property_keys, effective_at, as_at, relationship_definition_ids, **kwargs)  # noqa: E501

    @validate_arguments
    def get_person_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified scope and code. This together with stated identifier type uniquely              identifies the person.")], property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto the person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the person. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the person. Defaults to return the latest version of the person if not specified.")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the person in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetPerson: Get Person  # noqa: E501

        Retrieve the definition of a person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_with_http_info(id_type_scope, id_type_code, code, property_keys, effective_at, as_at, relationship_definition_ids, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param property_keys: A list of property keys from the \"Person\" domain to decorate onto the person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".
        :type property_keys: List[str]
        :param effective_at: The effective datetime or cut label at which to retrieve the person. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the person. Defaults to return the latest version of the person if not specified.
        :type as_at: datetime
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the person in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Person, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'property_keys',
            'effective_at',
            'as_at',
            'relationship_definition_ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('relationship_definition_ids') is not None:  # noqa: E501
            _query_params.append(('relationshipDefinitionIds', _params['relationship_definition_ids']))
            _collection_formats['relationshipDefinitionIds'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Person",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_person_access_metadata_by_key(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Access Metadata")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Access Metadata")] = None, **kwargs) -> List[AccessMetadataValue]:  # noqa: E501
        ...

    @overload
    def get_person_access_metadata_by_key(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Access Metadata")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Access Metadata")] = None, async_req: Optional[bool]=True, **kwargs) -> List[AccessMetadataValue]:  # noqa: E501
        ...

    @validate_arguments
    def get_person_access_metadata_by_key(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Access Metadata")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Access Metadata")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[List[AccessMetadataValue], Awaitable[List[AccessMetadataValue]]]:  # noqa: E501
        """[EARLY ACCESS] GetPersonAccessMetadataByKey: Get an entry identified by a metadataKey in the Access Metadata of a Person  # noqa: E501

        Get a specific Person Access Metadata by specifying the corresponding identifier parts and Person code                No matching will be performed through this endpoint. To retrieve an entry, it is necessary to specify, exactly, the identifier of the entry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_access_metadata_by_key(id_type_scope, id_type_code, code, metadata_key, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[AccessMetadataValue]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_person_access_metadata_by_key_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_person_access_metadata_by_key_with_http_info(id_type_scope, id_type_code, code, metadata_key, effective_at, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_person_access_metadata_by_key_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Access Metadata")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Access Metadata")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetPersonAccessMetadataByKey: Get an entry identified by a metadataKey in the Access Metadata of a Person  # noqa: E501

        Get a specific Person Access Metadata by specifying the corresponding identifier parts and Person code                No matching will be performed through this endpoint. To retrieve an entry, it is necessary to specify, exactly, the identifier of the entry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_access_metadata_by_key_with_http_info(id_type_scope, id_type_code, code, metadata_key, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[AccessMetadataValue], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'metadata_key',
            'effective_at',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person_access_metadata_by_key" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['metadata_key']:
            _path_params['metadataKey'] = _params['metadata_key']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "List[AccessMetadataValue]",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_person_property_time_series(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely identifies the person.")], property_key : Annotated[StrictStr, Field(..., description="The property key of the property that will have its history shown. These must be in the format {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\".              Each property must be from the \"Person\" domain.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the person's property history. Defaults to return the current datetime if not supplied.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties from a previous call to get property time series.              This value is returned from the previous call. If a pagination token is provided the filter and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, **kwargs) -> ResourceListOfPropertyInterval:  # noqa: E501
        ...

    @overload
    def get_person_property_time_series(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely identifies the person.")], property_key : Annotated[StrictStr, Field(..., description="The property key of the property that will have its history shown. These must be in the format {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\".              Each property must be from the \"Person\" domain.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the person's property history. Defaults to return the current datetime if not supplied.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties from a previous call to get property time series.              This value is returned from the previous call. If a pagination token is provided the filter and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfPropertyInterval:  # noqa: E501
        ...

    @validate_arguments
    def get_person_property_time_series(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely identifies the person.")], property_key : Annotated[StrictStr, Field(..., description="The property key of the property that will have its history shown. These must be in the format {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\".              Each property must be from the \"Person\" domain.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the person's property history. Defaults to return the current datetime if not supplied.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties from a previous call to get property time series.              This value is returned from the previous call. If a pagination token is provided the filter and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfPropertyInterval, Awaitable[ResourceListOfPropertyInterval]]:  # noqa: E501
        """[EARLY ACCESS] GetPersonPropertyTimeSeries: Get Person Property Time Series  # noqa: E501

        List the complete time series of a person property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_property_time_series(id_type_scope, id_type_code, code, property_key, as_at, filter, page, limit, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely identifies the person. (required)
        :type code: str
        :param property_key: The property key of the property that will have its history shown. These must be in the format {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\".              Each property must be from the \"Person\" domain. (required)
        :type property_key: str
        :param as_at: The asAt datetime at which to list the person's property history. Defaults to return the current datetime if not supplied.
        :type as_at: datetime
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param page: The pagination token to use to continue listing properties from a previous call to get property time series.              This value is returned from the previous call. If a pagination token is provided the filter and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfPropertyInterval
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_person_property_time_series_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_person_property_time_series_with_http_info(id_type_scope, id_type_code, code, property_key, as_at, filter, page, limit, **kwargs)  # noqa: E501

    @validate_arguments
    def get_person_property_time_series_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely identifies the person.")], property_key : Annotated[StrictStr, Field(..., description="The property key of the property that will have its history shown. These must be in the format {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\".              Each property must be from the \"Person\" domain.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the person's property history. Defaults to return the current datetime if not supplied.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties from a previous call to get property time series.              This value is returned from the previous call. If a pagination token is provided the filter and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetPersonPropertyTimeSeries: Get Person Property Time Series  # noqa: E501

        List the complete time series of a person property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_property_time_series_with_http_info(id_type_scope, id_type_code, code, property_key, as_at, filter, page, limit, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely identifies the person. (required)
        :type code: str
        :param property_key: The property key of the property that will have its history shown. These must be in the format {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\".              Each property must be from the \"Person\" domain. (required)
        :type property_key: str
        :param as_at: The asAt datetime at which to list the person's property history. Defaults to return the current datetime if not supplied.
        :type as_at: datetime
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param page: The pagination token to use to continue listing properties from a previous call to get property time series.              This value is returned from the previous call. If a pagination token is provided the filter and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfPropertyInterval, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'property_key',
            'as_at',
            'filter',
            'page',
            'limit'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person_property_time_series" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('property_key') is not None:  # noqa: E501
            _query_params.append(('propertyKey', _params['property_key']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfPropertyInterval",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/properties/time-series', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_person_relations(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relations. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the person's relations. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the relations. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[List[StrictStr]], Field(description="Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relations. If not applicable, provide an empty array.")] = None, **kwargs) -> ResourceListOfRelation:  # noqa: E501
        ...

    @overload
    def get_person_relations(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relations. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the person's relations. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the relations. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[List[StrictStr]], Field(description="Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relations. If not applicable, provide an empty array.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfRelation:  # noqa: E501
        ...

    @validate_arguments
    def get_person_relations(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relations. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the person's relations. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the relations. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[List[StrictStr]], Field(description="Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relations. If not applicable, provide an empty array.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfRelation, Awaitable[ResourceListOfRelation]]:  # noqa: E501
        """[EARLY ACCESS] GetPersonRelations: Get Relations for Person  # noqa: E501

        Get relations for the specified person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_relations(id_type_scope, id_type_code, code, effective_at, as_at, filter, identifier_types, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to get relations. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the person's relations. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the relations. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relations. If not applicable, provide an empty array.
        :type identifier_types: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfRelation
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_person_relations_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_person_relations_with_http_info(id_type_scope, id_type_code, code, effective_at, as_at, filter, identifier_types, **kwargs)  # noqa: E501

    @validate_arguments
    def get_person_relations_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relations. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the person's relations. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the relations. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[List[StrictStr]], Field(description="Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relations. If not applicable, provide an empty array.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetPersonRelations: Get Relations for Person  # noqa: E501

        Get relations for the specified person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_relations_with_http_info(id_type_scope, id_type_code, code, effective_at, as_at, filter, identifier_types, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to get relations. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the person's relations. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the relations. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relations. If not applicable, provide an empty array.
        :type identifier_types: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfRelation, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'effective_at',
            'as_at',
            'filter',
            'identifier_types'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person_relations" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('identifier_types') is not None:  # noqa: E501
            _query_params.append(('identifierTypes', _params['identifier_types']))
            _collection_formats['identifierTypes'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfRelation",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/relations', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_person_relationships(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person's identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person's identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter relationships. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[List[StrictStr]], Field(description="Identifier types (as property keys) used for referencing Persons or Legal Entities.              These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example              'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.")] = None, **kwargs) -> ResourceListOfRelationship:  # noqa: E501
        ...

    @overload
    def get_person_relationships(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person's identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person's identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter relationships. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[List[StrictStr]], Field(description="Identifier types (as property keys) used for referencing Persons or Legal Entities.              These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example              'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfRelationship:  # noqa: E501
        ...

    @validate_arguments
    def get_person_relationships(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person's identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person's identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter relationships. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[List[StrictStr]], Field(description="Identifier types (as property keys) used for referencing Persons or Legal Entities.              These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example              'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfRelationship, Awaitable[ResourceListOfRelationship]]:  # noqa: E501
        """[EARLY ACCESS] GetPersonRelationships: Get Relationships for Person  # noqa: E501

        Get relationships for the specified person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_relationships(id_type_scope, id_type_code, code, effective_at, as_at, filter, identifier_types, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person's identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person's identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifier types (as property keys) used for referencing Persons or Legal Entities.              These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example              'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.
        :type identifier_types: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfRelationship
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_person_relationships_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_person_relationships_with_http_info(id_type_scope, id_type_code, code, effective_at, as_at, filter, identifier_types, **kwargs)  # noqa: E501

    @validate_arguments
    def get_person_relationships_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person's identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person's identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter relationships. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[List[StrictStr]], Field(description="Identifier types (as property keys) used for referencing Persons or Legal Entities.              These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example              'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetPersonRelationships: Get Relationships for Person  # noqa: E501

        Get relationships for the specified person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_relationships_with_http_info(id_type_scope, id_type_code, code, effective_at, as_at, filter, identifier_types, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person's identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person's identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifier types (as property keys) used for referencing Persons or Legal Entities.              These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example              'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.
        :type identifier_types: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfRelationship, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'effective_at',
            'as_at',
            'filter',
            'identifier_types'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person_relationships" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('identifier_types') is not None:  # noqa: E501
            _query_params.append(('identifierTypes', _params['identifier_types']))
            _collection_formats['identifierTypes'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfRelationship",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/relationships', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_all_persons(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 5000 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               For example, to filter on the display name, use \"displayName eq 'John'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, **kwargs) -> ResourceListOfPerson:  # noqa: E501
        ...

    @overload
    def list_all_persons(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 5000 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               For example, to filter on the display name, use \"displayName eq 'John'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfPerson:  # noqa: E501
        ...

    @validate_arguments
    def list_all_persons(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 5000 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               For example, to filter on the display name, use \"displayName eq 'John'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfPerson, Awaitable[ResourceListOfPerson]]:  # noqa: E501
        """[EARLY ACCESS] ListAllPersons: List All Persons  # noqa: E501

        List all persons which the user is entitled to see.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_all_persons(effective_at, as_at, page, limit, filter, property_keys, relationship_definition_ids, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 5000 if not specified.
        :type limit: int
        :param filter: Expression to filter the result set.               For example, to filter on the display name, use \"displayName eq 'John'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param property_keys: A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".
        :type property_keys: List[str]
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfPerson
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_all_persons_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_all_persons_with_http_info(effective_at, as_at, page, limit, filter, property_keys, relationship_definition_ids, **kwargs)  # noqa: E501

    @validate_arguments
    def list_all_persons_with_http_info(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 5000 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               For example, to filter on the display name, use \"displayName eq 'John'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListAllPersons: List All Persons  # noqa: E501

        List all persons which the user is entitled to see.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_all_persons_with_http_info(effective_at, as_at, page, limit, filter, property_keys, relationship_definition_ids, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 5000 if not specified.
        :type limit: int
        :param filter: Expression to filter the result set.               For example, to filter on the display name, use \"displayName eq 'John'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param property_keys: A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".
        :type property_keys: List[str]
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfPerson, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'property_keys',
            'relationship_definition_ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_persons" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('relationship_definition_ids') is not None:  # noqa: E501
            _query_params.append(('relationshipDefinitionIds', _params['relationship_definition_ids']))
            _collection_formats['relationshipDefinitionIds'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfPerson",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_persons(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               For example, to filter on the LUPID, use \"lusidPersonId eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, **kwargs) -> PagedResourceListOfPerson:  # noqa: E501
        ...

    @overload
    def list_persons(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               For example, to filter on the LUPID, use \"lusidPersonId eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfPerson:  # noqa: E501
        ...

    @validate_arguments
    def list_persons(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               For example, to filter on the LUPID, use \"lusidPersonId eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfPerson, Awaitable[PagedResourceListOfPerson]]:  # noqa: E501
        """[EARLY ACCESS] ListPersons: List Persons  # noqa: E501

        List persons which have identifiers of a specific identifier type's scope and code, and satisfies filter criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_persons(id_type_scope, id_type_code, effective_at, as_at, page, limit, filter, property_keys, relationship_definition_ids, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param effective_at: The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the result set.               For example, to filter on the LUPID, use \"lusidPersonId eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param property_keys: A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".
        :type property_keys: List[str]
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfPerson
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_persons_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_persons_with_http_info(id_type_scope, id_type_code, effective_at, as_at, page, limit, filter, property_keys, relationship_definition_ids, **kwargs)  # noqa: E501

    @validate_arguments
    def list_persons_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               For example, to filter on the LUPID, use \"lusidPersonId eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[List[StrictStr]], Field(description="A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".")] = None, relationship_definition_ids : Annotated[Optional[List[StrictStr]], Field(description="A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListPersons: List Persons  # noqa: E501

        List persons which have identifiers of a specific identifier type's scope and code, and satisfies filter criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_persons_with_http_info(id_type_scope, id_type_code, effective_at, as_at, page, limit, filter, property_keys, relationship_definition_ids, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param effective_at: The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing persons from a previous call to list persons. This              value is returned from the previous call. If a pagination token is provided the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the result set.               For example, to filter on the LUPID, use \"lusidPersonId eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param property_keys: A list of property keys from the \"Person\" domain to decorate onto each person,               or from any domain that supports relationships to decorate onto related entities.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\".
        :type property_keys: List[str]
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the persons in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfPerson, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'property_keys',
            'relationship_definition_ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_persons" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('relationship_definition_ids') is not None:  # noqa: E501
            _query_params.append(('relationshipDefinitionIds', _params['relationship_definition_ids']))
            _collection_formats['relationshipDefinitionIds'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfPerson",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def patch_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], access_metadata_operation : Annotated[List[AccessMetadataOperation], Field(description="The Json Patch document")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to upsert the Access Metadata")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata")] = None, **kwargs) -> Dict[str, List[AccessMetadataValue]]:  # noqa: E501
        ...

    @overload
    def patch_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], access_metadata_operation : Annotated[List[AccessMetadataOperation], Field(description="The Json Patch document")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to upsert the Access Metadata")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata")] = None, async_req: Optional[bool]=True, **kwargs) -> Dict[str, List[AccessMetadataValue]]:  # noqa: E501
        ...

    @validate_arguments
    def patch_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], access_metadata_operation : Annotated[List[AccessMetadataOperation], Field(description="The Json Patch document")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to upsert the Access Metadata")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Dict[str, List[AccessMetadataValue]], Awaitable[Dict[str, List[AccessMetadataValue]]]]:  # noqa: E501
        """[EARLY ACCESS] PatchPersonAccessMetadata: Patch Access Metadata rules for a Person.  # noqa: E501

        Patch Person Access Metadata Rules in a single scope.  The behaviour is defined by the JSON Patch specification.                Currently only 'add' is a supported operation on the patch document.    Currently only valid metadata keys are supported paths on the patch document.                The response will return any affected Person Access Metadata rules or a failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_person_access_metadata(id_type_scope, id_type_code, code, access_metadata_operation, effective_at, effective_until, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param access_metadata_operation: The Json Patch document (required)
        :type access_metadata_operation: List[AccessMetadataOperation]
        :param effective_at: The effectiveAt datetime at which to upsert the Access Metadata
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, List[AccessMetadataValue]]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the patch_person_access_metadata_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.patch_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, access_metadata_operation, effective_at, effective_until, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_person_access_metadata_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], access_metadata_operation : Annotated[List[AccessMetadataOperation], Field(description="The Json Patch document")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to upsert the Access Metadata")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] PatchPersonAccessMetadata: Patch Access Metadata rules for a Person.  # noqa: E501

        Patch Person Access Metadata Rules in a single scope.  The behaviour is defined by the JSON Patch specification.                Currently only 'add' is a supported operation on the patch document.    Currently only valid metadata keys are supported paths on the patch document.                The response will return any affected Person Access Metadata rules or a failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, access_metadata_operation, effective_at, effective_until, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param access_metadata_operation: The Json Patch document (required)
        :type access_metadata_operation: List[AccessMetadataOperation]
        :param effective_at: The effectiveAt datetime at which to upsert the Access Metadata
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, List[AccessMetadataValue]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'access_metadata_operation',
            'effective_at',
            'effective_until'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_person_access_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('effective_until') is not None:  # noqa: E501
            if isinstance(_params['effective_until'], datetime):
                _query_params.append(('effectiveUntil', _params['effective_until'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('effectiveUntil', _params['effective_until']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['access_metadata_operation'] is not None:
            _body_params = _params['access_metadata_operation']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, List[AccessMetadataValue]]",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_person_identifiers(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], set_person_identifiers_request : Annotated[SetPersonIdentifiersRequest, Field(description="Request containing identifiers to set for the person. Identifiers not specified in request will not be changed.")], **kwargs) -> Person:  # noqa: E501
        ...

    @overload
    def set_person_identifiers(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], set_person_identifiers_request : Annotated[SetPersonIdentifiersRequest, Field(description="Request containing identifiers to set for the person. Identifiers not specified in request will not be changed.")], async_req: Optional[bool]=True, **kwargs) -> Person:  # noqa: E501
        ...

    @validate_arguments
    def set_person_identifiers(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], set_person_identifiers_request : Annotated[SetPersonIdentifiersRequest, Field(description="Request containing identifiers to set for the person. Identifiers not specified in request will not be changed.")], async_req: Optional[bool]=None, **kwargs) -> Union[Person, Awaitable[Person]]:  # noqa: E501
        """[EARLY ACCESS] SetPersonIdentifiers: Set Person Identifiers  # noqa: E501

        Set identifiers of the person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_person_identifiers(id_type_scope, id_type_code, code, set_person_identifiers_request, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param set_person_identifiers_request: Request containing identifiers to set for the person. Identifiers not specified in request will not be changed. (required)
        :type set_person_identifiers_request: SetPersonIdentifiersRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Person
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_person_identifiers_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_person_identifiers_with_http_info(id_type_scope, id_type_code, code, set_person_identifiers_request, **kwargs)  # noqa: E501

    @validate_arguments
    def set_person_identifiers_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], set_person_identifiers_request : Annotated[SetPersonIdentifiersRequest, Field(description="Request containing identifiers to set for the person. Identifiers not specified in request will not be changed.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] SetPersonIdentifiers: Set Person Identifiers  # noqa: E501

        Set identifiers of the person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_person_identifiers_with_http_info(id_type_scope, id_type_code, code, set_person_identifiers_request, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param set_person_identifiers_request: Request containing identifiers to set for the person. Identifiers not specified in request will not be changed. (required)
        :type set_person_identifiers_request: SetPersonIdentifiersRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Person, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'set_person_identifiers_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_person_identifiers" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['set_person_identifiers_request'] is not None:
            _body_params = _params['set_person_identifiers_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Person",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/identifiers', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_person_properties(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], set_person_properties_request : Annotated[SetPersonPropertiesRequest, Field(description="Request containing properties to set for the person. Properties not specified in request will not be changed.")], **kwargs) -> Person:  # noqa: E501
        ...

    @overload
    def set_person_properties(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], set_person_properties_request : Annotated[SetPersonPropertiesRequest, Field(description="Request containing properties to set for the person. Properties not specified in request will not be changed.")], async_req: Optional[bool]=True, **kwargs) -> Person:  # noqa: E501
        ...

    @validate_arguments
    def set_person_properties(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], set_person_properties_request : Annotated[SetPersonPropertiesRequest, Field(description="Request containing properties to set for the person. Properties not specified in request will not be changed.")], async_req: Optional[bool]=None, **kwargs) -> Union[Person, Awaitable[Person]]:  # noqa: E501
        """[EARLY ACCESS] SetPersonProperties: Set Person Properties  # noqa: E501

        Set properties of the person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_person_properties(id_type_scope, id_type_code, code, set_person_properties_request, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param set_person_properties_request: Request containing properties to set for the person. Properties not specified in request will not be changed. (required)
        :type set_person_properties_request: SetPersonPropertiesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Person
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_person_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_person_properties_with_http_info(id_type_scope, id_type_code, code, set_person_properties_request, **kwargs)  # noqa: E501

    @validate_arguments
    def set_person_properties_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier type.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier type.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person.")], set_person_properties_request : Annotated[SetPersonPropertiesRequest, Field(description="Request containing properties to set for the person. Properties not specified in request will not be changed.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] SetPersonProperties: Set Person Properties  # noqa: E501

        Set properties of the person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_person_properties_with_http_info(id_type_scope, id_type_code, code, set_person_properties_request, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier type. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier type. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :type code: str
        :param set_person_properties_request: Request containing properties to set for the person. Properties not specified in request will not be changed. (required)
        :type set_person_properties_request: SetPersonPropertiesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Person, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'set_person_properties_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_person_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['set_person_properties_request'] is not None:
            _body_params = _params['set_person_properties_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Person",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/properties', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_person(self, upsert_person_request : Annotated[UpsertPersonRequest, Field(description="Request to create or update a person.")], **kwargs) -> Person:  # noqa: E501
        ...

    @overload
    def upsert_person(self, upsert_person_request : Annotated[UpsertPersonRequest, Field(description="Request to create or update a person.")], async_req: Optional[bool]=True, **kwargs) -> Person:  # noqa: E501
        ...

    @validate_arguments
    def upsert_person(self, upsert_person_request : Annotated[UpsertPersonRequest, Field(description="Request to create or update a person.")], async_req: Optional[bool]=None, **kwargs) -> Union[Person, Awaitable[Person]]:  # noqa: E501
        """UpsertPerson: Upsert Person  # noqa: E501

        Create or update a new person under the specified scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_person(upsert_person_request, async_req=True)
        >>> result = thread.get()

        :param upsert_person_request: Request to create or update a person. (required)
        :type upsert_person_request: UpsertPersonRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Person
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_person_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_person_with_http_info(upsert_person_request, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_person_with_http_info(self, upsert_person_request : Annotated[UpsertPersonRequest, Field(description="Request to create or update a person.")], **kwargs) -> ApiResponse:  # noqa: E501
        """UpsertPerson: Upsert Person  # noqa: E501

        Create or update a new person under the specified scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_person_with_http_info(upsert_person_request, async_req=True)
        >>> result = thread.get()

        :param upsert_person_request: Request to create or update a person. (required)
        :type upsert_person_request: UpsertPersonRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Person, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'upsert_person_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_person" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_person_request'] is not None:
            _body_params = _params['upsert_person_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "Person",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], upsert_person_access_metadata_request : Annotated[UpsertPersonAccessMetadataRequest, Field(description="The Person Access Metadata entry to upsert")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to upsert the Access Metadata")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata")] = None, **kwargs) -> ResourceListOfAccessMetadataValueOf:  # noqa: E501
        ...

    @overload
    def upsert_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], upsert_person_access_metadata_request : Annotated[UpsertPersonAccessMetadataRequest, Field(description="The Person Access Metadata entry to upsert")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to upsert the Access Metadata")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfAccessMetadataValueOf:  # noqa: E501
        ...

    @validate_arguments
    def upsert_person_access_metadata(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], upsert_person_access_metadata_request : Annotated[UpsertPersonAccessMetadataRequest, Field(description="The Person Access Metadata entry to upsert")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to upsert the Access Metadata")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfAccessMetadataValueOf, Awaitable[ResourceListOfAccessMetadataValueOf]]:  # noqa: E501
        """[EARLY ACCESS] UpsertPersonAccessMetadata: Upsert a Person Access Metadata entry associated with a specific metadataKey. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Person Access Metadata entry in a single scope. An item will be updated if it already exists  and inserted if it does not.                The response will return the successfully updated or inserted Person Access Metadata rule or failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_person_access_metadata(id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, effective_at, effective_until, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param upsert_person_access_metadata_request: The Person Access Metadata entry to upsert (required)
        :type upsert_person_access_metadata_request: UpsertPersonAccessMetadataRequest
        :param effective_at: The effectiveAt datetime at which to upsert the Access Metadata
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfAccessMetadataValueOf
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_person_access_metadata_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, effective_at, effective_until, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_person_access_metadata_with_http_info(self, id_type_scope : Annotated[StrictStr, Field(..., description="Scope of the person identifier.")], id_type_code : Annotated[StrictStr, Field(..., description="Code of the person identifier.")], code : Annotated[StrictStr, Field(..., description="Code of the person under specified identifier type's scope and code.")], metadata_key : Annotated[StrictStr, Field(..., description="Key of the metadata entry to retrieve")], upsert_person_access_metadata_request : Annotated[UpsertPersonAccessMetadataRequest, Field(description="The Person Access Metadata entry to upsert")], effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to upsert the Access Metadata")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpsertPersonAccessMetadata: Upsert a Person Access Metadata entry associated with a specific metadataKey. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Person Access Metadata entry in a single scope. An item will be updated if it already exists  and inserted if it does not.                The response will return the successfully updated or inserted Person Access Metadata rule or failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, effective_at, effective_until, async_req=True)
        >>> result = thread.get()

        :param id_type_scope: Scope of the person identifier. (required)
        :type id_type_scope: str
        :param id_type_code: Code of the person identifier. (required)
        :type id_type_code: str
        :param code: Code of the person under specified identifier type's scope and code. (required)
        :type code: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param upsert_person_access_metadata_request: The Person Access Metadata entry to upsert (required)
        :type upsert_person_access_metadata_request: UpsertPersonAccessMetadataRequest
        :param effective_at: The effectiveAt datetime at which to upsert the Access Metadata
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfAccessMetadataValueOf, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_type_scope',
            'id_type_code',
            'code',
            'metadata_key',
            'upsert_person_access_metadata_request',
            'effective_at',
            'effective_until'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_person_access_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_type_scope']:
            _path_params['idTypeScope'] = _params['id_type_scope']

        if _params['id_type_code']:
            _path_params['idTypeCode'] = _params['id_type_code']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['metadata_key']:
            _path_params['metadataKey'] = _params['metadata_key']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('effective_until') is not None:  # noqa: E501
            if isinstance(_params['effective_until'], datetime):
                _query_params.append(('effectiveUntil', _params['effective_until'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('effectiveUntil', _params['effective_until']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_person_access_metadata_request'] is not None:
            _body_params = _params['upsert_person_access_metadata_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfAccessMetadataValueOf",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_persons(self, success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial")], request_body : Annotated[Dict[str, UpsertPersonRequest], Field(description="A collection of requests to create or update Person(s).")], **kwargs) -> UpsertPersonsResponse:  # noqa: E501
        ...

    @overload
    def upsert_persons(self, success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial")], request_body : Annotated[Dict[str, UpsertPersonRequest], Field(description="A collection of requests to create or update Person(s).")], async_req: Optional[bool]=True, **kwargs) -> UpsertPersonsResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_persons(self, success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial")], request_body : Annotated[Dict[str, UpsertPersonRequest], Field(description="A collection of requests to create or update Person(s).")], async_req: Optional[bool]=None, **kwargs) -> Union[UpsertPersonsResponse, Awaitable[UpsertPersonsResponse]]:  # noqa: E501
        """[EARLY ACCESS] UpsertPersons: Batch upsert Persons  # noqa: E501

        Create or updates a collection of person(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_persons(success_mode, request_body, async_req=True)
        >>> result = thread.get()

        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial (required)
        :type success_mode: str
        :param request_body: A collection of requests to create or update Person(s). (required)
        :type request_body: Dict[str, UpsertPersonRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertPersonsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_persons_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_persons_with_http_info(success_mode, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_persons_with_http_info(self, success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial")], request_body : Annotated[Dict[str, UpsertPersonRequest], Field(description="A collection of requests to create or update Person(s).")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpsertPersons: Batch upsert Persons  # noqa: E501

        Create or updates a collection of person(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_persons_with_http_info(success_mode, request_body, async_req=True)
        >>> result = thread.get()

        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial (required)
        :type success_mode: str
        :param request_body: A collection of requests to create or update Person(s). (required)
        :type request_body: Dict[str, UpsertPersonRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertPersonsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'success_mode',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_persons" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('success_mode') is not None:  # noqa: E501
            _query_params.append(('successMode', _params['success_mode']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "UpsertPersonsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/persons/$batchUpsert', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
