# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from datetime import datetime
from pydantic.v1 import Field, StrictInt, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from lusid.models.create_relational_dataset_definition_request import CreateRelationalDatasetDefinitionRequest
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.paged_resource_list_of_relational_dataset_definition import PagedResourceListOfRelationalDatasetDefinition
from lusid.models.relational_dataset_definition import RelationalDatasetDefinition
from lusid.models.update_relational_dataset_definition_request import UpdateRelationalDatasetDefinitionRequest
from lusid.models.update_relational_dataset_details import UpdateRelationalDatasetDetails
from lusid.models.update_relational_dataset_field_schema import UpdateRelationalDatasetFieldSchema

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class RelationalDatasetDefinitionApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_relational_dataset_definition(self, create_relational_dataset_definition_request : Annotated[CreateRelationalDatasetDefinitionRequest, Field(description="The relational dataset definition to create.")], **kwargs) -> RelationalDatasetDefinition:  # noqa: E501
        ...

    @overload
    def create_relational_dataset_definition(self, create_relational_dataset_definition_request : Annotated[CreateRelationalDatasetDefinitionRequest, Field(description="The relational dataset definition to create.")], async_req: Optional[bool]=True, **kwargs) -> RelationalDatasetDefinition:  # noqa: E501
        ...

    @validate_arguments
    def create_relational_dataset_definition(self, create_relational_dataset_definition_request : Annotated[CreateRelationalDatasetDefinitionRequest, Field(description="The relational dataset definition to create.")], async_req: Optional[bool]=None, **kwargs) -> Union[RelationalDatasetDefinition, Awaitable[RelationalDatasetDefinition]]:  # noqa: E501
        """[EARLY ACCESS] CreateRelationalDatasetDefinition: Create a Relational Dataset Definition  # noqa: E501

        Create a new relational dataset definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_relational_dataset_definition(create_relational_dataset_definition_request, async_req=True)
        >>> result = thread.get()

        :param create_relational_dataset_definition_request: The relational dataset definition to create. (required)
        :type create_relational_dataset_definition_request: CreateRelationalDatasetDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelationalDatasetDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_relational_dataset_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_relational_dataset_definition_with_http_info(create_relational_dataset_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_relational_dataset_definition_with_http_info(self, create_relational_dataset_definition_request : Annotated[CreateRelationalDatasetDefinitionRequest, Field(description="The relational dataset definition to create.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] CreateRelationalDatasetDefinition: Create a Relational Dataset Definition  # noqa: E501

        Create a new relational dataset definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_relational_dataset_definition_with_http_info(create_relational_dataset_definition_request, async_req=True)
        >>> result = thread.get()

        :param create_relational_dataset_definition_request: The relational dataset definition to create. (required)
        :type create_relational_dataset_definition_request: CreateRelationalDatasetDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelationalDatasetDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_relational_dataset_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_relational_dataset_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_relational_dataset_definition_request'] is not None:
            _body_params = _params['create_relational_dataset_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "RelationalDatasetDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/relationaldatasetdefinitions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_relational_dataset_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_relational_dataset_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_relational_dataset_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EARLY ACCESS] DeleteRelationalDatasetDefinition: Delete a Relational Dataset Definition  # noqa: E501

        Delete a relational dataset definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_relational_dataset_definition(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the relational dataset definition. (required)
        :type scope: str
        :param code: The code of the relational dataset definition. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_relational_dataset_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_relational_dataset_definition_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_relational_dataset_definition_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeleteRelationalDatasetDefinition: Delete a Relational Dataset Definition  # noqa: E501

        Delete a relational dataset definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_relational_dataset_definition_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the relational dataset definition. (required)
        :type scope: str
        :param code: The code of the relational dataset definition. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_relational_dataset_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/relationaldatasetdefinitions/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_relational_dataset_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the relational dataset definition. Defaults to return the latest version if not specified.")] = None, **kwargs) -> RelationalDatasetDefinition:  # noqa: E501
        ...

    @overload
    def get_relational_dataset_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the relational dataset definition. Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> RelationalDatasetDefinition:  # noqa: E501
        ...

    @validate_arguments
    def get_relational_dataset_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the relational dataset definition. Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[RelationalDatasetDefinition, Awaitable[RelationalDatasetDefinition]]:  # noqa: E501
        """[EARLY ACCESS] GetRelationalDatasetDefinition: Get a Relational Dataset Definition  # noqa: E501

        Retrieve a relational dataset definition by its identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_relational_dataset_definition(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the relational dataset definition. (required)
        :type scope: str
        :param code: The code of the relational dataset definition. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the relational dataset definition. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelationalDatasetDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_relational_dataset_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_relational_dataset_definition_with_http_info(scope, code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_relational_dataset_definition_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the relational dataset definition. Defaults to return the latest version if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetRelationalDatasetDefinition: Get a Relational Dataset Definition  # noqa: E501

        Retrieve a relational dataset definition by its identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_relational_dataset_definition_with_http_info(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the relational dataset definition. (required)
        :type scope: str
        :param code: The code of the relational dataset definition. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the relational dataset definition. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelationalDatasetDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_relational_dataset_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "RelationalDatasetDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/relationaldatasetdefinitions/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_relational_dataset_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the relational dataset definitions. Defaults to return the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing relational dataset definitions from a previous call to list relational dataset definitions.")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, **kwargs) -> PagedResourceListOfRelationalDatasetDefinition:  # noqa: E501
        ...

    @overload
    def list_relational_dataset_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the relational dataset definitions. Defaults to return the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing relational dataset definitions from a previous call to list relational dataset definitions.")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfRelationalDatasetDefinition:  # noqa: E501
        ...

    @validate_arguments
    def list_relational_dataset_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the relational dataset definitions. Defaults to return the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing relational dataset definitions from a previous call to list relational dataset definitions.")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfRelationalDatasetDefinition, Awaitable[PagedResourceListOfRelationalDatasetDefinition]]:  # noqa: E501
        """[EARLY ACCESS] ListRelationalDatasetDefinitions: List Relational Dataset Definitions  # noqa: E501

        List all relational dataset definitions matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_relational_dataset_definitions(as_at, page, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the relational dataset definitions. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing relational dataset definitions from a previous call to list relational dataset definitions.
        :type page: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfRelationalDatasetDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_relational_dataset_definitions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_relational_dataset_definitions_with_http_info(as_at, page, sort_by, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_relational_dataset_definitions_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the relational dataset definitions. Defaults to return the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing relational dataset definitions from a previous call to list relational dataset definitions.")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListRelationalDatasetDefinitions: List Relational Dataset Definitions  # noqa: E501

        List all relational dataset definitions matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_relational_dataset_definitions_with_http_info(as_at, page, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the relational dataset definitions. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing relational dataset definitions from a previous call to list relational dataset definitions.
        :type page: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfRelationalDatasetDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'sort_by',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_relational_dataset_definitions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfRelationalDatasetDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/relationaldatasetdefinitions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_relational_dataset_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_definition_request : Annotated[Optional[UpdateRelationalDatasetDefinitionRequest], Field(description="The updated relational dataset definition.")] = None, **kwargs) -> RelationalDatasetDefinition:  # noqa: E501
        ...

    @overload
    def update_relational_dataset_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_definition_request : Annotated[Optional[UpdateRelationalDatasetDefinitionRequest], Field(description="The updated relational dataset definition.")] = None, async_req: Optional[bool]=True, **kwargs) -> RelationalDatasetDefinition:  # noqa: E501
        ...

    @validate_arguments
    def update_relational_dataset_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_definition_request : Annotated[Optional[UpdateRelationalDatasetDefinitionRequest], Field(description="The updated relational dataset definition.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[RelationalDatasetDefinition, Awaitable[RelationalDatasetDefinition]]:  # noqa: E501
        """[EARLY ACCESS] UpdateRelationalDatasetDefinition: Update a Relational Dataset Definition  # noqa: E501

        Update an existing relational dataset definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_relational_dataset_definition(scope, code, update_relational_dataset_definition_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the relational dataset definition. (required)
        :type scope: str
        :param code: The code of the relational dataset definition. (required)
        :type code: str
        :param update_relational_dataset_definition_request: The updated relational dataset definition.
        :type update_relational_dataset_definition_request: UpdateRelationalDatasetDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelationalDatasetDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_relational_dataset_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_relational_dataset_definition_with_http_info(scope, code, update_relational_dataset_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_relational_dataset_definition_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_definition_request : Annotated[Optional[UpdateRelationalDatasetDefinitionRequest], Field(description="The updated relational dataset definition.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdateRelationalDatasetDefinition: Update a Relational Dataset Definition  # noqa: E501

        Update an existing relational dataset definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_relational_dataset_definition_with_http_info(scope, code, update_relational_dataset_definition_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the relational dataset definition. (required)
        :type scope: str
        :param code: The code of the relational dataset definition. (required)
        :type code: str
        :param update_relational_dataset_definition_request: The updated relational dataset definition.
        :type update_relational_dataset_definition_request: UpdateRelationalDatasetDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelationalDatasetDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'update_relational_dataset_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_relational_dataset_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_relational_dataset_definition_request'] is not None:
            _body_params = _params['update_relational_dataset_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "RelationalDatasetDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/relationaldatasetdefinitions/{scope}/{code}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_relational_dataset_details(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_details : Annotated[Optional[UpdateRelationalDatasetDetails], Field(description="The updated details of the relational dataset.")] = None, **kwargs) -> RelationalDatasetDefinition:  # noqa: E501
        ...

    @overload
    def update_relational_dataset_details(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_details : Annotated[Optional[UpdateRelationalDatasetDetails], Field(description="The updated details of the relational dataset.")] = None, async_req: Optional[bool]=True, **kwargs) -> RelationalDatasetDefinition:  # noqa: E501
        ...

    @validate_arguments
    def update_relational_dataset_details(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_details : Annotated[Optional[UpdateRelationalDatasetDetails], Field(description="The updated details of the relational dataset.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[RelationalDatasetDefinition, Awaitable[RelationalDatasetDefinition]]:  # noqa: E501
        """[EARLY ACCESS] UpdateRelationalDatasetDetails: Update Relational Dataset Details: DisplayName, Description and ApplicableEntityTypes  # noqa: E501

        Update an existing relational dataset definition.  Applicable only to the definitions that are already in use i.e. contain DataPoints associated with this definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_relational_dataset_details(scope, code, update_relational_dataset_details, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the relational dataset definition. (required)
        :type scope: str
        :param code: The code of the relational dataset definition. (required)
        :type code: str
        :param update_relational_dataset_details: The updated details of the relational dataset.
        :type update_relational_dataset_details: UpdateRelationalDatasetDetails
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelationalDatasetDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_relational_dataset_details_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_relational_dataset_details_with_http_info(scope, code, update_relational_dataset_details, **kwargs)  # noqa: E501

    @validate_arguments
    def update_relational_dataset_details_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_details : Annotated[Optional[UpdateRelationalDatasetDetails], Field(description="The updated details of the relational dataset.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdateRelationalDatasetDetails: Update Relational Dataset Details: DisplayName, Description and ApplicableEntityTypes  # noqa: E501

        Update an existing relational dataset definition.  Applicable only to the definitions that are already in use i.e. contain DataPoints associated with this definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_relational_dataset_details_with_http_info(scope, code, update_relational_dataset_details, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the relational dataset definition. (required)
        :type scope: str
        :param code: The code of the relational dataset definition. (required)
        :type code: str
        :param update_relational_dataset_details: The updated details of the relational dataset.
        :type update_relational_dataset_details: UpdateRelationalDatasetDetails
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelationalDatasetDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'update_relational_dataset_details'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_relational_dataset_details" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_relational_dataset_details'] is not None:
            _body_params = _params['update_relational_dataset_details']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "RelationalDatasetDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/relationaldatasetdefinitions/{scope}/{code}/details/$update', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_relational_dataset_field_schema(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_field_schema : Annotated[Optional[UpdateRelationalDatasetFieldSchema], Field(description="Relational dataset fields to add, update or remove.")] = None, **kwargs) -> RelationalDatasetDefinition:  # noqa: E501
        ...

    @overload
    def update_relational_dataset_field_schema(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_field_schema : Annotated[Optional[UpdateRelationalDatasetFieldSchema], Field(description="Relational dataset fields to add, update or remove.")] = None, async_req: Optional[bool]=True, **kwargs) -> RelationalDatasetDefinition:  # noqa: E501
        ...

    @validate_arguments
    def update_relational_dataset_field_schema(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_field_schema : Annotated[Optional[UpdateRelationalDatasetFieldSchema], Field(description="Relational dataset fields to add, update or remove.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[RelationalDatasetDefinition, Awaitable[RelationalDatasetDefinition]]:  # noqa: E501
        """[EARLY ACCESS] UpdateRelationalDatasetFieldSchema: Update Relational Dataset Field Schema  # noqa: E501

        Update an existing relational dataset definition with the new field schema.  Applicable only to the definitions that are already in use i.e. contain DataPoints associated with this definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_relational_dataset_field_schema(scope, code, update_relational_dataset_field_schema, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the relational dataset definition. (required)
        :type scope: str
        :param code: The code of the relational dataset definition. (required)
        :type code: str
        :param update_relational_dataset_field_schema: Relational dataset fields to add, update or remove.
        :type update_relational_dataset_field_schema: UpdateRelationalDatasetFieldSchema
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelationalDatasetDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_relational_dataset_field_schema_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_relational_dataset_field_schema_with_http_info(scope, code, update_relational_dataset_field_schema, **kwargs)  # noqa: E501

    @validate_arguments
    def update_relational_dataset_field_schema_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the relational dataset definition.")], code : Annotated[StrictStr, Field(..., description="The code of the relational dataset definition.")], update_relational_dataset_field_schema : Annotated[Optional[UpdateRelationalDatasetFieldSchema], Field(description="Relational dataset fields to add, update or remove.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdateRelationalDatasetFieldSchema: Update Relational Dataset Field Schema  # noqa: E501

        Update an existing relational dataset definition with the new field schema.  Applicable only to the definitions that are already in use i.e. contain DataPoints associated with this definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_relational_dataset_field_schema_with_http_info(scope, code, update_relational_dataset_field_schema, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the relational dataset definition. (required)
        :type scope: str
        :param code: The code of the relational dataset definition. (required)
        :type code: str
        :param update_relational_dataset_field_schema: Relational dataset fields to add, update or remove.
        :type update_relational_dataset_field_schema: UpdateRelationalDatasetFieldSchema
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelationalDatasetDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'update_relational_dataset_field_schema'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_relational_dataset_field_schema" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_relational_dataset_field_schema'] is not None:
            _body_params = _params['update_relational_dataset_field_schema']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "RelationalDatasetDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/relationaldatasetdefinitions/{scope}/{code}/fieldschema/$update', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
