# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from pydantic.v1 import Field, StrictInt
from typing import Optional
from typing_extensions import Annotated
from lusid.models.create_sequence_request import CreateSequenceRequest
from lusid.models.next_value_in_sequence_response import NextValueInSequenceResponse
from lusid.models.paged_resource_list_of_sequence_definition import PagedResourceListOfSequenceDefinition
from lusid.models.sequence_definition import SequenceDefinition

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class SequencesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_sequence(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], create_sequence_request : Annotated[CreateSequenceRequest, Field(description="Request to create sequence")], **kwargs) -> SequenceDefinition:  # noqa: E501
        ...

    @overload
    def create_sequence(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], create_sequence_request : Annotated[CreateSequenceRequest, Field(description="Request to create sequence")], async_req: Optional[bool]=True, **kwargs) -> SequenceDefinition:  # noqa: E501
        ...

    @validate_arguments
    def create_sequence(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], create_sequence_request : Annotated[CreateSequenceRequest, Field(description="Request to create sequence")], async_req: Optional[bool]=None, **kwargs) -> Union[SequenceDefinition, Awaitable[SequenceDefinition]]:  # noqa: E501
        """[EARLY ACCESS] CreateSequence: Create a new sequence  # noqa: E501

        Create a new sequence  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sequence(scope, create_sequence_request, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the sequence. (required)
        :type scope: str
        :param create_sequence_request: Request to create sequence (required)
        :type create_sequence_request: CreateSequenceRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SequenceDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_sequence_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_sequence_with_http_info(scope, create_sequence_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_sequence_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], create_sequence_request : Annotated[CreateSequenceRequest, Field(description="Request to create sequence")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] CreateSequence: Create a new sequence  # noqa: E501

        Create a new sequence  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sequence_with_http_info(scope, create_sequence_request, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the sequence. (required)
        :type scope: str
        :param create_sequence_request: Request to create sequence (required)
        :type create_sequence_request: CreateSequenceRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SequenceDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'create_sequence_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sequence" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_sequence_request'] is not None:
            _body_params = _params['create_sequence_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "SequenceDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/sequences/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_sequence(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], code : Annotated[StrictStr, Field(..., description="Code of the sequence. This together with stated scope uniquely              identifies the sequence.")], **kwargs) -> SequenceDefinition:  # noqa: E501
        ...

    @overload
    def get_sequence(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], code : Annotated[StrictStr, Field(..., description="Code of the sequence. This together with stated scope uniquely              identifies the sequence.")], async_req: Optional[bool]=True, **kwargs) -> SequenceDefinition:  # noqa: E501
        ...

    @validate_arguments
    def get_sequence(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], code : Annotated[StrictStr, Field(..., description="Code of the sequence. This together with stated scope uniquely              identifies the sequence.")], async_req: Optional[bool]=None, **kwargs) -> Union[SequenceDefinition, Awaitable[SequenceDefinition]]:  # noqa: E501
        """[EARLY ACCESS] GetSequence: Get a specified sequence  # noqa: E501

        Return the details of a specified sequence  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sequence(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the sequence. (required)
        :type scope: str
        :param code: Code of the sequence. This together with stated scope uniquely              identifies the sequence. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SequenceDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_sequence_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_sequence_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def get_sequence_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], code : Annotated[StrictStr, Field(..., description="Code of the sequence. This together with stated scope uniquely              identifies the sequence.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetSequence: Get a specified sequence  # noqa: E501

        Return the details of a specified sequence  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sequence_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the sequence. (required)
        :type scope: str
        :param code: Code of the sequence. This together with stated scope uniquely              identifies the sequence. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SequenceDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sequence" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "SequenceDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/sequences/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_sequences(self, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing sequences from a previous call to list sequences. This  value is returned from the previous call.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 500 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> PagedResourceListOfSequenceDefinition:  # noqa: E501
        ...

    @overload
    def list_sequences(self, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing sequences from a previous call to list sequences. This  value is returned from the previous call.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 500 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfSequenceDefinition:  # noqa: E501
        ...

    @validate_arguments
    def list_sequences(self, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing sequences from a previous call to list sequences. This  value is returned from the previous call.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 500 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfSequenceDefinition, Awaitable[PagedResourceListOfSequenceDefinition]]:  # noqa: E501
        """[EARLY ACCESS] ListSequences: List Sequences  # noqa: E501

        List sequences which satisfies filtering criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_sequences(page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param page: The pagination token to use to continue listing sequences from a previous call to list sequences. This  value is returned from the previous call.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 500 if not specified.
        :type limit: int
        :param filter: Expression to filter the result set.               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfSequenceDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_sequences_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_sequences_with_http_info(page, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_sequences_with_http_info(self, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing sequences from a previous call to list sequences. This  value is returned from the previous call.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 500 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListSequences: List Sequences  # noqa: E501

        List sequences which satisfies filtering criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_sequences_with_http_info(page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param page: The pagination token to use to continue listing sequences from a previous call to list sequences. This  value is returned from the previous call.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 500 if not specified.
        :type limit: int
        :param filter: Expression to filter the result set.               Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfSequenceDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'page',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sequences" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfSequenceDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/sequences', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def next(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], code : Annotated[StrictStr, Field(..., description="Code of the sequence. This together with stated scope uniquely              identifies the sequence.")], batch : Annotated[Optional[StrictInt], Field(description="Number of sequences items to return for the specified sequence. Default to 1 if not specified.")] = None, **kwargs) -> NextValueInSequenceResponse:  # noqa: E501
        ...

    @overload
    def next(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], code : Annotated[StrictStr, Field(..., description="Code of the sequence. This together with stated scope uniquely              identifies the sequence.")], batch : Annotated[Optional[StrictInt], Field(description="Number of sequences items to return for the specified sequence. Default to 1 if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> NextValueInSequenceResponse:  # noqa: E501
        ...

    @validate_arguments
    def next(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], code : Annotated[StrictStr, Field(..., description="Code of the sequence. This together with stated scope uniquely              identifies the sequence.")], batch : Annotated[Optional[StrictInt], Field(description="Number of sequences items to return for the specified sequence. Default to 1 if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[NextValueInSequenceResponse, Awaitable[NextValueInSequenceResponse]]:  # noqa: E501
        """[EARLY ACCESS] Next: Get next values from sequence  # noqa: E501

        Get the next set of values from a specified sequence  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.next(scope, code, batch, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the sequence. (required)
        :type scope: str
        :param code: Code of the sequence. This together with stated scope uniquely              identifies the sequence. (required)
        :type code: str
        :param batch: Number of sequences items to return for the specified sequence. Default to 1 if not specified.
        :type batch: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: NextValueInSequenceResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the next_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.next_with_http_info(scope, code, batch, **kwargs)  # noqa: E501

    @validate_arguments
    def next_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the sequence.")], code : Annotated[StrictStr, Field(..., description="Code of the sequence. This together with stated scope uniquely              identifies the sequence.")], batch : Annotated[Optional[StrictInt], Field(description="Number of sequences items to return for the specified sequence. Default to 1 if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] Next: Get next values from sequence  # noqa: E501

        Get the next set of values from a specified sequence  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.next_with_http_info(scope, code, batch, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the sequence. (required)
        :type scope: str
        :param code: Code of the sequence. This together with stated scope uniquely              identifies the sequence. (required)
        :type code: str
        :param batch: Number of sequences items to return for the specified sequence. Default to 1 if not specified.
        :type batch: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(NextValueInSequenceResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'batch'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method next" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('batch') is not None:  # noqa: E501
            _query_params.append(('batch', _params['batch']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "NextValueInSequenceResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/sequences/{scope}/{code}/next', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
