# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.link import Link
from lusid.models.valuation_point_data_response import ValuationPointDataResponse

class AcceptEstimateValuationPointResponse(BaseModel):
    """
    The Valuation Point Data Response for AcceptEstimate called on the Fund and specified date.  # noqa: E501
    """
    href:  Optional[StrictStr] = Field(None,alias="href", description="The specific Uniform Resource Identifier (URI) for this resource at the requested effective and asAt datetime.") 
    candidate_valuation_point: ValuationPointDataResponse = Field(alias="candidateValuationPoint")
    latest_valuation_point: Optional[ValuationPointDataResponse] = Field(default=None, alias="latestValuationPoint")
    links: Optional[List[Link]] = None
    __properties = ["href", "candidateValuationPoint", "latestValuationPoint", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AcceptEstimateValuationPointResponse:
        """Create an instance of AcceptEstimateValuationPointResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of candidate_valuation_point
        if self.candidate_valuation_point:
            _dict['candidateValuationPoint'] = self.candidate_valuation_point.to_dict()
        # override the default output from pydantic by calling `to_dict()` of latest_valuation_point
        if self.latest_valuation_point:
            _dict['latestValuationPoint'] = self.latest_valuation_point.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AcceptEstimateValuationPointResponse:
        """Create an instance of AcceptEstimateValuationPointResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AcceptEstimateValuationPointResponse.parse_obj(obj)

        _obj = AcceptEstimateValuationPointResponse.parse_obj({
            "href": obj.get("href"),
            "candidate_valuation_point": ValuationPointDataResponse.from_dict(obj.get("candidateValuationPoint")) if obj.get("candidateValuationPoint") is not None else None,
            "latest_valuation_point": ValuationPointDataResponse.from_dict(obj.get("latestValuationPoint")) if obj.get("latestValuationPoint") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

AcceptEstimateValuationPointResponse.update_forward_refs()
