# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.append_market_data import AppendMarketData
from lusid.models.complex_market_data_id import ComplexMarketDataId

class AppendComplexMarketDataRequest(BaseModel):
    """
    The details of the point to be appended to a complex market data item.  # noqa: E501
    """
    market_data_id: ComplexMarketDataId = Field(alias="marketDataId")
    append_market_data: AppendMarketData = Field(alias="appendMarketData")
    __properties = ["marketDataId", "appendMarketData"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AppendComplexMarketDataRequest:
        """Create an instance of AppendComplexMarketDataRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of market_data_id
        if self.market_data_id:
            _dict['marketDataId'] = self.market_data_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of append_market_data
        if self.append_market_data:
            _dict['appendMarketData'] = self.append_market_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AppendComplexMarketDataRequest:
        """Create an instance of AppendComplexMarketDataRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AppendComplexMarketDataRequest.parse_obj(obj)

        _obj = AppendComplexMarketDataRequest.parse_obj({
            "market_data_id": ComplexMarketDataId.from_dict(obj.get("marketDataId")) if obj.get("marketDataId") is not None else None,
            "append_market_data": AppendMarketData.from_dict(obj.get("appendMarketData")) if obj.get("appendMarketData") is not None else None
        })
        return _obj

AppendComplexMarketDataRequest.update_forward_refs()
