# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class ApplicableEntity(BaseModel):
    """
    ApplicableEntity
    """
    entity_type:  StrictStr = Field(...,alias="entityType", description="The type of entity (e.g., Instrument, Portfolio) that this DataSeries applies to.") 
    entity_scope:  Optional[StrictStr] = Field(None,alias="entityScope", description="The scope of the entity.") 
    identifier_scope:  Optional[StrictStr] = Field(None,alias="identifierScope", description="The scope of the identifier used to uniquely identify the entity.") 
    identifier_type:  Optional[StrictStr] = Field(None,alias="identifierType", description="The type of identifier (e.g., Figi, Isin) used to uniquely identify the entity.") 
    identifier_value:  Optional[StrictStr] = Field(None,alias="identifierValue", description="The value of the identifier used to uniquely identify the entity.") 
    __properties = ["entityType", "entityScope", "identifierScope", "identifierType", "identifierValue"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApplicableEntity:
        """Create an instance of ApplicableEntity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if entity_scope (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_scope is None and "entity_scope" in self.__fields_set__:
            _dict['entityScope'] = None

        # set to None if identifier_scope (nullable) is None
        # and __fields_set__ contains the field
        if self.identifier_scope is None and "identifier_scope" in self.__fields_set__:
            _dict['identifierScope'] = None

        # set to None if identifier_type (nullable) is None
        # and __fields_set__ contains the field
        if self.identifier_type is None and "identifier_type" in self.__fields_set__:
            _dict['identifierType'] = None

        # set to None if identifier_value (nullable) is None
        # and __fields_set__ contains the field
        if self.identifier_value is None and "identifier_value" in self.__fields_set__:
            _dict['identifierValue'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApplicableEntity:
        """Create an instance of ApplicableEntity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApplicableEntity.parse_obj(obj)

        _obj = ApplicableEntity.parse_obj({
            "entity_type": obj.get("entityType"),
            "entity_scope": obj.get("entityScope"),
            "identifier_scope": obj.get("identifierScope"),
            "identifier_type": obj.get("identifierType"),
            "identifier_value": obj.get("identifierValue")
        })
        return _obj

ApplicableEntity.update_forward_refs()
