# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.generated_event_diagnostics import GeneratedEventDiagnostics
from lusid.models.instrument_event_holder import InstrumentEventHolder
from lusid.models.resource_id import ResourceId
from lusid.models.transaction import Transaction
from lusid.models.transaction_diagnostics import TransactionDiagnostics

class ApplicableInstrumentEvent(BaseModel):
    """
    Represents applicable instrument event.  # noqa: E501
    """
    portfolio_id: ResourceId = Field(alias="portfolioId")
    holding_id: StrictInt = Field(alias="holdingId")
    lusid_instrument_id:  StrictStr = Field(...,alias="lusidInstrumentId") 
    instrument_scope:  StrictStr = Field(...,alias="instrumentScope") 
    instrument_type:  StrictStr = Field(...,alias="instrumentType") 
    instrument_event_type:  StrictStr = Field(...,alias="instrumentEventType") 
    instrument_event_id:  StrictStr = Field(...,alias="instrumentEventId") 
    generated_event: Optional[InstrumentEventHolder] = Field(default=None, alias="generatedEvent")
    generated_event_diagnostics: Optional[GeneratedEventDiagnostics] = Field(default=None, alias="generatedEventDiagnostics")
    loaded_event: Optional[InstrumentEventHolder] = Field(default=None, alias="loadedEvent")
    applied_instrument_event_instruction_id:  Optional[StrictStr] = Field(None,alias="appliedInstrumentEventInstructionId") 
    transactions: Optional[List[Transaction]] = None
    transaction_diagnostics: Optional[TransactionDiagnostics] = Field(default=None, alias="transactionDiagnostics")
    __properties = ["portfolioId", "holdingId", "lusidInstrumentId", "instrumentScope", "instrumentType", "instrumentEventType", "instrumentEventId", "generatedEvent", "generatedEventDiagnostics", "loadedEvent", "appliedInstrumentEventInstructionId", "transactions", "transactionDiagnostics"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApplicableInstrumentEvent:
        """Create an instance of ApplicableInstrumentEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of portfolio_id
        if self.portfolio_id:
            _dict['portfolioId'] = self.portfolio_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of generated_event
        if self.generated_event:
            _dict['generatedEvent'] = self.generated_event.to_dict()
        # override the default output from pydantic by calling `to_dict()` of generated_event_diagnostics
        if self.generated_event_diagnostics:
            _dict['generatedEventDiagnostics'] = self.generated_event_diagnostics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of loaded_event
        if self.loaded_event:
            _dict['loadedEvent'] = self.loaded_event.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in transactions (list)
        _items = []
        if self.transactions:
            for _item in self.transactions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transactions'] = _items
        # override the default output from pydantic by calling `to_dict()` of transaction_diagnostics
        if self.transaction_diagnostics:
            _dict['transactionDiagnostics'] = self.transaction_diagnostics.to_dict()
        # set to None if applied_instrument_event_instruction_id (nullable) is None
        # and __fields_set__ contains the field
        if self.applied_instrument_event_instruction_id is None and "applied_instrument_event_instruction_id" in self.__fields_set__:
            _dict['appliedInstrumentEventInstructionId'] = None

        # set to None if transactions (nullable) is None
        # and __fields_set__ contains the field
        if self.transactions is None and "transactions" in self.__fields_set__:
            _dict['transactions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApplicableInstrumentEvent:
        """Create an instance of ApplicableInstrumentEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApplicableInstrumentEvent.parse_obj(obj)

        _obj = ApplicableInstrumentEvent.parse_obj({
            "portfolio_id": ResourceId.from_dict(obj.get("portfolioId")) if obj.get("portfolioId") is not None else None,
            "holding_id": obj.get("holdingId"),
            "lusid_instrument_id": obj.get("lusidInstrumentId"),
            "instrument_scope": obj.get("instrumentScope"),
            "instrument_type": obj.get("instrumentType"),
            "instrument_event_type": obj.get("instrumentEventType"),
            "instrument_event_id": obj.get("instrumentEventId"),
            "generated_event": InstrumentEventHolder.from_dict(obj.get("generatedEvent")) if obj.get("generatedEvent") is not None else None,
            "generated_event_diagnostics": GeneratedEventDiagnostics.from_dict(obj.get("generatedEventDiagnostics")) if obj.get("generatedEventDiagnostics") is not None else None,
            "loaded_event": InstrumentEventHolder.from_dict(obj.get("loadedEvent")) if obj.get("loadedEvent") is not None else None,
            "applied_instrument_event_instruction_id": obj.get("appliedInstrumentEventInstructionId"),
            "transactions": [Transaction.from_dict(_item) for _item in obj.get("transactions")] if obj.get("transactions") is not None else None,
            "transaction_diagnostics": TransactionDiagnostics.from_dict(obj.get("transactionDiagnostics")) if obj.get("transactionDiagnostics") is not None else None
        })
        return _obj

ApplicableInstrumentEvent.update_forward_refs()
