# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.group_reconciliation_user_review_add import GroupReconciliationUserReviewAdd
from lusid.models.group_reconciliation_user_review_remove import GroupReconciliationUserReviewRemove

class BatchUpdateUserReviewForComparisonResultRequest(BaseModel):
    """
    BatchUpdateUserReviewForComparisonResultRequest
    """
    comparison_result_id:  StrictStr = Field(...,alias="comparisonResultId", description="Comparison result identifier, encoded value for core attribute results, aggregate attribute results, reconciliation type and run instanceId.") 
    user_review_add: Optional[GroupReconciliationUserReviewAdd] = Field(default=None, alias="userReviewAdd")
    user_review_remove: Optional[GroupReconciliationUserReviewRemove] = Field(default=None, alias="userReviewRemove")
    __properties = ["comparisonResultId", "userReviewAdd", "userReviewRemove"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BatchUpdateUserReviewForComparisonResultRequest:
        """Create an instance of BatchUpdateUserReviewForComparisonResultRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of user_review_add
        if self.user_review_add:
            _dict['userReviewAdd'] = self.user_review_add.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_review_remove
        if self.user_review_remove:
            _dict['userReviewRemove'] = self.user_review_remove.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BatchUpdateUserReviewForComparisonResultRequest:
        """Create an instance of BatchUpdateUserReviewForComparisonResultRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BatchUpdateUserReviewForComparisonResultRequest.parse_obj(obj)

        _obj = BatchUpdateUserReviewForComparisonResultRequest.parse_obj({
            "comparison_result_id": obj.get("comparisonResultId"),
            "user_review_add": GroupReconciliationUserReviewAdd.from_dict(obj.get("userReviewAdd")) if obj.get("userReviewAdd") is not None else None,
            "user_review_remove": GroupReconciliationUserReviewRemove.from_dict(obj.get("userReviewRemove")) if obj.get("userReviewRemove") is not None else None
        })
        return _obj

BatchUpdateUserReviewForComparisonResultRequest.update_forward_refs()
