# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.access_metadata_value import AccessMetadataValue
from lusid.models.resource_id import ResourceId

class BatchUpsertPortfolioAccessMetadataResponseItem(BaseModel):
    """
    BatchUpsertPortfolioAccessMetadataResponseItem
    """
    portfolio_id: ResourceId = Field(alias="portfolioId")
    metadata: Dict[str, Optional[List[AccessMetadataValue]]]
    __properties = ["portfolioId", "metadata"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BatchUpsertPortfolioAccessMetadataResponseItem:
        """Create an instance of BatchUpsertPortfolioAccessMetadataResponseItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of portfolio_id
        if self.portfolio_id:
            _dict['portfolioId'] = self.portfolio_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in metadata (dict of array)
        _field_dict_of_array = {}
        if self.metadata:
            for _key in self.metadata:
                if self.metadata[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.metadata[_key]
                    ]
            _dict['metadata'] = _field_dict_of_array
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BatchUpsertPortfolioAccessMetadataResponseItem:
        """Create an instance of BatchUpsertPortfolioAccessMetadataResponseItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BatchUpsertPortfolioAccessMetadataResponseItem.parse_obj(obj)

        _obj = BatchUpsertPortfolioAccessMetadataResponseItem.parse_obj({
            "portfolio_id": ResourceId.from_dict(obj.get("portfolioId")) if obj.get("portfolioId") is not None else None,
            "metadata": dict(
                (_k,
                        [AccessMetadataValue.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("metadata").items()
            )
        })
        return _obj

BatchUpsertPortfolioAccessMetadataResponseItem.update_forward_refs()
