# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.currency_and_amount import CurrencyAndAmount
from lusid.models.data_model_membership import DataModelMembership
from lusid.models.link import Link
from lusid.models.perpetual_property import PerpetualProperty
from lusid.models.resource_id import ResourceId
from lusid.models.version import Version

class Block(BaseModel):
    """
    A block of orders for the same instrument, intended to record for example a trader's aggregation  of outstanding orders at a given time.  # noqa: E501
    """
    id: ResourceId
    order_ids: List[ResourceId] = Field(description="The related order ids.", alias="orderIds")
    properties: Optional[Dict[str, PerpetualProperty]] = Field(default=None, description="Client-defined properties associated with this block.")
    instrument_identifiers: Dict[str, Optional[StrictStr]] = Field(description="The instrument ordered.", alias="instrumentIdentifiers")
    lusid_instrument_id:  StrictStr = Field(...,alias="lusidInstrumentId", description="The LUSID instrument id for the instrument ordered.") 
    quantity: Union[StrictFloat, StrictInt] = Field(description="The total quantity of given instrument ordered.")
    side:  StrictStr = Field(...,alias="side", description="The client's representation of the block's side (buy, sell, short, etc)") 
    type:  StrictStr = Field(...,alias="type", description="The block order's type (examples: Limit, Market, ...)") 
    time_in_force:  StrictStr = Field(...,alias="timeInForce", description="The block orders' time in force (examples: Day, GoodTilCancel, ...)") 
    created_date: datetime = Field(description="The date on which the block was made", alias="createdDate")
    limit_price: Optional[CurrencyAndAmount] = Field(default=None, alias="limitPrice")
    stop_price: Optional[CurrencyAndAmount] = Field(default=None, alias="stopPrice")
    is_swept: StrictBool = Field(description="Swept blocks are considered no longer of active interest, and no longer take part in various order management processes", alias="isSwept")
    version: Optional[Version] = None
    data_model_membership: Optional[DataModelMembership] = Field(default=None, alias="dataModelMembership")
    links: Optional[List[Link]] = None
    __properties = ["id", "orderIds", "properties", "instrumentIdentifiers", "lusidInstrumentId", "quantity", "side", "type", "timeInForce", "createdDate", "limitPrice", "stopPrice", "isSwept", "version", "dataModelMembership", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Block:
        """Create an instance of Block from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in order_ids (list)
        _items = []
        if self.order_ids:
            for _item in self.order_ids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orderIds'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of limit_price
        if self.limit_price:
            _dict['limitPrice'] = self.limit_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stop_price
        if self.stop_price:
            _dict['stopPrice'] = self.stop_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_model_membership
        if self.data_model_membership:
            _dict['dataModelMembership'] = self.data_model_membership.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Block:
        """Create an instance of Block from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Block.parse_obj(obj)

        _obj = Block.parse_obj({
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "order_ids": [ResourceId.from_dict(_item) for _item in obj.get("orderIds")] if obj.get("orderIds") is not None else None,
            "properties": dict(
                (_k, PerpetualProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None,
            "instrument_identifiers": obj.get("instrumentIdentifiers"),
            "lusid_instrument_id": obj.get("lusidInstrumentId"),
            "quantity": obj.get("quantity"),
            "side": obj.get("side"),
            "type": obj.get("type"),
            "time_in_force": obj.get("timeInForce"),
            "created_date": obj.get("createdDate"),
            "limit_price": CurrencyAndAmount.from_dict(obj.get("limitPrice")) if obj.get("limitPrice") is not None else None,
            "stop_price": CurrencyAndAmount.from_dict(obj.get("stopPrice")) if obj.get("stopPrice") is not None else None,
            "is_swept": obj.get("isSwept"),
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "data_model_membership": DataModelMembership.from_dict(obj.get("dataModelMembership")) if obj.get("dataModelMembership") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

Block.update_forward_refs()
