# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.settlement_problem import SettlementProblem

class CategorySettlementStatus(BaseModel):
    """
    CategorySettlementStatus
    """
    status:  StrictStr = Field(...,alias="status", description="The Status of the settlement category - 'Settled', 'Part Settled' or 'Unsettled'.") 
    is_overdue: StrictBool = Field(description="Whether the category has any overdue movements", alias="isOverdue")
    problems: List[SettlementProblem] = Field(description="Instruction level detail of rejected or invalid settlement instructions")
    __properties = ["status", "isOverdue", "problems"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CategorySettlementStatus:
        """Create an instance of CategorySettlementStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in problems (list)
        _items = []
        if self.problems:
            for _item in self.problems:
                if _item:
                    _items.append(_item.to_dict())
            _dict['problems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CategorySettlementStatus:
        """Create an instance of CategorySettlementStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CategorySettlementStatus.parse_obj(obj)

        _obj = CategorySettlementStatus.parse_obj({
            "status": obj.get("status"),
            "is_overdue": obj.get("isOverdue"),
            "problems": [SettlementProblem.from_dict(_item) for _item in obj.get("problems")] if obj.get("problems") is not None else None
        })
        return _obj

CategorySettlementStatus.update_forward_refs()
