# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.check_definition_rule import CheckDefinitionRule

class CheckDefinitionRuleSet(BaseModel):
    """
    CheckDefinitionRuleSet
    """
    rule_set_key:  Optional[StrictStr] = Field(None,alias="ruleSetKey", description="The Key of the Rule Set.") 
    display_name:  Optional[StrictStr] = Field(None,alias="displayName", description="The name of the Rule Set.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="A description for the Rule Set.") 
    rule_set_filter:  Optional[StrictStr] = Field(None,alias="ruleSetFilter", description="A filter for the Rule Set to filter entity instances the rule set applies to.") 
    rules: Optional[List[CheckDefinitionRule]] = Field(default=None, description="A collection of rules for the Rule Set.")
    __properties = ["ruleSetKey", "displayName", "description", "ruleSetFilter", "rules"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CheckDefinitionRuleSet:
        """Create an instance of CheckDefinitionRuleSet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in rules (list)
        _items = []
        if self.rules:
            for _item in self.rules:
                if _item:
                    _items.append(_item.to_dict())
            _dict['rules'] = _items
        # set to None if rule_set_key (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_set_key is None and "rule_set_key" in self.__fields_set__:
            _dict['ruleSetKey'] = None

        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if rule_set_filter (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_set_filter is None and "rule_set_filter" in self.__fields_set__:
            _dict['ruleSetFilter'] = None

        # set to None if rules (nullable) is None
        # and __fields_set__ contains the field
        if self.rules is None and "rules" in self.__fields_set__:
            _dict['rules'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CheckDefinitionRuleSet:
        """Create an instance of CheckDefinitionRuleSet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CheckDefinitionRuleSet.parse_obj(obj)

        _obj = CheckDefinitionRuleSet.parse_obj({
            "rule_set_key": obj.get("ruleSetKey"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "rule_set_filter": obj.get("ruleSetFilter"),
            "rules": [CheckDefinitionRule.from_dict(_item) for _item in obj.get("rules")] if obj.get("rules") is not None else None
        })
        return _obj

CheckDefinitionRuleSet.update_forward_refs()
