# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class CleardownModuleRule(BaseModel):
    """
    A Cleardown rule  # noqa: E501
    """
    rule_id:  StrictStr = Field(...,alias="ruleId", description="The identifier for the Cleardown Rule.") 
    general_ledger_account_code:  StrictStr = Field(...,alias="generalLedgerAccountCode", description="The account to post the residual P&L to.") 
    rule_filter:  StrictStr = Field(...,alias="ruleFilter", description="The filter syntax for the Cleardown Rule. See https://support.lusid.com/knowledgebase/article/KA-02140 for more information on filter syntax.") 
    __properties = ["ruleId", "generalLedgerAccountCode", "ruleFilter"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CleardownModuleRule:
        """Create an instance of CleardownModuleRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CleardownModuleRule:
        """Create an instance of CleardownModuleRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CleardownModuleRule.parse_obj(obj)

        _obj = CleardownModuleRule.parse_obj({
            "rule_id": obj.get("ruleId"),
            "general_ledger_account_code": obj.get("generalLedgerAccountCode"),
            "rule_filter": obj.get("ruleFilter")
        })
        return _obj

CleardownModuleRule.update_forward_refs()
