# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.collateral_instrument import CollateralInstrument

class Collateral(BaseModel):
    """
    Representation of the collateral of a repurchase agreement, along with related details of the agreement.  # noqa: E501
    """
    buyer_receives_cashflows: StrictBool = Field(description="Does the buyer of the FlexibleRepo receive the cashflows from any collateral instruments, or do they get paid to the seller.", alias="buyerReceivesCashflows")
    buyer_receives_corporate_action_payments: StrictBool = Field(description="Does the buyer of the FlexibleRepo receive any dividend or cash payments as the result of a corporate action  on any of the collateral instruments, or are these amounts paid to the seller.  Referred to as \"manufactured payments\" in the UK, and valid only under a repo with GMRA in Europe", alias="buyerReceivesCorporateActionPayments")
    collateral_instruments: Optional[List[CollateralInstrument]] = Field(default=None, description="List of any collateral instruments.", alias="collateralInstruments")
    collateral_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Total value of the collateral before any margin or haircut applied.  Can be provided instead of PurchasePrice, so that PurchasePrice can be inferred from the CollateralValue and one of  Haircut or Margin.", alias="collateralValue")
    __properties = ["buyerReceivesCashflows", "buyerReceivesCorporateActionPayments", "collateralInstruments", "collateralValue"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Collateral:
        """Create an instance of Collateral from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in collateral_instruments (list)
        _items = []
        if self.collateral_instruments:
            for _item in self.collateral_instruments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['collateralInstruments'] = _items
        # set to None if collateral_instruments (nullable) is None
        # and __fields_set__ contains the field
        if self.collateral_instruments is None and "collateral_instruments" in self.__fields_set__:
            _dict['collateralInstruments'] = None

        # set to None if collateral_value (nullable) is None
        # and __fields_set__ contains the field
        if self.collateral_value is None and "collateral_value" in self.__fields_set__:
            _dict['collateralValue'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Collateral:
        """Create an instance of Collateral from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Collateral.parse_obj(obj)

        _obj = Collateral.parse_obj({
            "buyer_receives_cashflows": obj.get("buyerReceivesCashflows"),
            "buyer_receives_corporate_action_payments": obj.get("buyerReceivesCorporateActionPayments"),
            "collateral_instruments": [CollateralInstrument.from_dict(_item) for _item in obj.get("collateralInstruments")] if obj.get("collateralInstruments") is not None else None,
            "collateral_value": obj.get("collateralValue")
        })
        return _obj

Collateral.update_forward_refs()
