# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.mastered_instrument import MasteredInstrument

class CollateralInstrument(BaseModel):
    """
    Wrapper for one instrument in a larger collateral basket, as part of a repurchase agreement modelled as a FlexibleRepo.  # noqa: E501
    """
    units: Union[StrictFloat, StrictInt] = Field(description="The amount of the instrument in the basket for this repurchase agreement.")
    instrument: MasteredInstrument
    __properties = ["units", "instrument"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CollateralInstrument:
        """Create an instance of CollateralInstrument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of instrument
        if self.instrument:
            _dict['instrument'] = self.instrument.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CollateralInstrument:
        """Create an instance of CollateralInstrument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CollateralInstrument.parse_obj(obj)

        _obj = CollateralInstrument.parse_obj({
            "units": obj.get("units"),
            "instrument": MasteredInstrument.from_dict(obj.get("instrument")) if obj.get("instrument") is not None else None
        })
        return _obj

CollateralInstrument.update_forward_refs()
