# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.resource_id import ResourceId
from lusid.models.version import Version

class CompleteRelation(BaseModel):
    """
    Representation of a relation containing details of source and target entities, and both outward and inward descriptions.  # noqa: E501
    """
    href:  Optional[StrictStr] = Field(None,alias="href") 
    version: Optional[Version] = None
    relation_definition_id: ResourceId = Field(alias="relationDefinitionId")
    source_entity_id: Dict[str, Optional[StrictStr]] = Field(alias="sourceEntityId")
    target_entity_id: Dict[str, Optional[StrictStr]] = Field(alias="targetEntityId")
    outward_description:  StrictStr = Field(...,alias="outwardDescription") 
    inward_description:  StrictStr = Field(...,alias="inwardDescription") 
    effective_from: Optional[datetime] = Field(default=None, alias="effectiveFrom")
    __properties = ["href", "version", "relationDefinitionId", "sourceEntityId", "targetEntityId", "outwardDescription", "inwardDescription", "effectiveFrom"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompleteRelation:
        """Create an instance of CompleteRelation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of relation_definition_id
        if self.relation_definition_id:
            _dict['relationDefinitionId'] = self.relation_definition_id.to_dict()
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteRelation:
        """Create an instance of CompleteRelation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CompleteRelation.parse_obj(obj)

        _obj = CompleteRelation.parse_obj({
            "href": obj.get("href"),
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "relation_definition_id": ResourceId.from_dict(obj.get("relationDefinitionId")) if obj.get("relationDefinitionId") is not None else None,
            "source_entity_id": obj.get("sourceEntityId"),
            "target_entity_id": obj.get("targetEntityId"),
            "outward_description": obj.get("outwardDescription"),
            "inward_description": obj.get("inwardDescription"),
            "effective_from": obj.get("effectiveFrom")
        })
        return _obj

CompleteRelation.update_forward_refs()
