# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.resource_id import ResourceId

class ComplianceRuleUpsertRequest(BaseModel):
    """
    ComplianceRuleUpsertRequest
    """
    scope:  StrictStr = Field(...,alias="scope", description="") 
    code:  Optional[StrictStr] = Field(None,alias="code", description="") 
    display_name:  Optional[StrictStr] = Field(None,alias="displayName", description="") 
    type:  StrictStr = Field(...,alias="type", description="") 
    property_key:  Optional[StrictStr] = Field(None,alias="propertyKey", description="") 
    value:  Optional[StrictStr] = Field(None,alias="value", description="") 
    lower_bound: Union[StrictFloat, StrictInt] = Field(alias="lowerBound")
    upper_bound: Union[StrictFloat, StrictInt] = Field(alias="upperBound")
    schedule:  StrictStr = Field(...,alias="schedule", description="") 
    hard_requirement: StrictBool = Field(alias="hardRequirement")
    target_portfolio_ids: List[ResourceId] = Field(alias="targetPortfolioIds")
    description:  Optional[StrictStr] = Field(None,alias="description", description="") 
    address_key:  Optional[StrictStr] = Field(None,alias="addressKey", description="") 
    __properties = ["scope", "code", "displayName", "type", "propertyKey", "value", "lowerBound", "upperBound", "schedule", "hardRequirement", "targetPortfolioIds", "description", "addressKey"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ComplianceRuleUpsertRequest:
        """Create an instance of ComplianceRuleUpsertRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in target_portfolio_ids (list)
        _items = []
        if self.target_portfolio_ids:
            for _item in self.target_portfolio_ids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['targetPortfolioIds'] = _items
        # set to None if code (nullable) is None
        # and __fields_set__ contains the field
        if self.code is None and "code" in self.__fields_set__:
            _dict['code'] = None

        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if property_key (nullable) is None
        # and __fields_set__ contains the field
        if self.property_key is None and "property_key" in self.__fields_set__:
            _dict['propertyKey'] = None

        # set to None if value (nullable) is None
        # and __fields_set__ contains the field
        if self.value is None and "value" in self.__fields_set__:
            _dict['value'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if address_key (nullable) is None
        # and __fields_set__ contains the field
        if self.address_key is None and "address_key" in self.__fields_set__:
            _dict['addressKey'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ComplianceRuleUpsertRequest:
        """Create an instance of ComplianceRuleUpsertRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ComplianceRuleUpsertRequest.parse_obj(obj)

        _obj = ComplianceRuleUpsertRequest.parse_obj({
            "scope": obj.get("scope"),
            "code": obj.get("code"),
            "display_name": obj.get("displayName"),
            "type": obj.get("type"),
            "property_key": obj.get("propertyKey"),
            "value": obj.get("value"),
            "lower_bound": obj.get("lowerBound"),
            "upper_bound": obj.get("upperBound"),
            "schedule": obj.get("schedule"),
            "hard_requirement": obj.get("hardRequirement"),
            "target_portfolio_ids": [ResourceId.from_dict(_item) for _item in obj.get("targetPortfolioIds")] if obj.get("targetPortfolioIds") is not None else None,
            "description": obj.get("description"),
            "address_key": obj.get("addressKey")
        })
        return _obj

ComplianceRuleUpsertRequest.update_forward_refs()
