# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.corporate_action_transition import CorporateActionTransition

class CorporateAction(BaseModel):
    """
    A corporate action  # noqa: E501
    """
    corporate_action_code:  StrictStr = Field(...,alias="corporateActionCode", description="The unique identifier of this corporate action") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="The description of the corporate action.") 
    announcement_date: Optional[datetime] = Field(default=None, description="The announcement date of the corporate action", alias="announcementDate")
    ex_date: Optional[datetime] = Field(default=None, description="The ex date of the corporate action", alias="exDate")
    record_date: Optional[datetime] = Field(default=None, description="The record date of the corporate action", alias="recordDate")
    payment_date: Optional[datetime] = Field(default=None, description="The payment date of the corporate action", alias="paymentDate")
    transitions: Optional[List[CorporateActionTransition]] = Field(default=None, description="The transitions that result from this corporate action")
    __properties = ["corporateActionCode", "description", "announcementDate", "exDate", "recordDate", "paymentDate", "transitions"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CorporateAction:
        """Create an instance of CorporateAction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in transitions (list)
        _items = []
        if self.transitions:
            for _item in self.transitions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transitions'] = _items
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if transitions (nullable) is None
        # and __fields_set__ contains the field
        if self.transitions is None and "transitions" in self.__fields_set__:
            _dict['transitions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CorporateAction:
        """Create an instance of CorporateAction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CorporateAction.parse_obj(obj)

        _obj = CorporateAction.parse_obj({
            "corporate_action_code": obj.get("corporateActionCode"),
            "description": obj.get("description"),
            "announcement_date": obj.get("announcementDate"),
            "ex_date": obj.get("exDate"),
            "record_date": obj.get("recordDate"),
            "payment_date": obj.get("paymentDate"),
            "transitions": [CorporateActionTransition.from_dict(_item) for _item in obj.get("transitions")] if obj.get("transitions") is not None else None
        })
        return _obj

CorporateAction.update_forward_refs()
