# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.custom_entity_field_definition import CustomEntityFieldDefinition

class CreateCustomEntityTypeRequest(BaseModel):
    """
    CreateCustomEntityTypeRequest
    """
    entity_type_name:  StrictStr = Field(...,alias="entityTypeName", description="A name for the custom entity type. This will be prefixed with “~” and returned as “entityType”, which is the identifier for the custom entity type.") 
    display_name:  StrictStr = Field(...,alias="displayName", description="A display label for the custom entity type.") 
    description:  StrictStr = Field(...,alias="description", description="A description for the custom entity type.") 
    field_schema: List[CustomEntityFieldDefinition] = Field(description="The description of the fields on the custom entity type.", alias="fieldSchema")
    __properties = ["entityTypeName", "displayName", "description", "fieldSchema"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateCustomEntityTypeRequest:
        """Create an instance of CreateCustomEntityTypeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in field_schema (list)
        _items = []
        if self.field_schema:
            for _item in self.field_schema:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fieldSchema'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateCustomEntityTypeRequest:
        """Create an instance of CreateCustomEntityTypeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateCustomEntityTypeRequest.parse_obj(obj)

        _obj = CreateCustomEntityTypeRequest.parse_obj({
            "entity_type_name": obj.get("entityTypeName"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "field_schema": [CustomEntityFieldDefinition.from_dict(_item) for _item in obj.get("fieldSchema")] if obj.get("fieldSchema") is not None else None
        })
        return _obj

CreateCustomEntityTypeRequest.update_forward_refs()
