# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.model_property import ModelProperty
from lusid.models.resource_id import ResourceId

class CreatePortfolioGroupRequest(BaseModel):
    """
    CreatePortfolioGroupRequest
    """
    code:  StrictStr = Field(...,alias="code", description="The code that the portfolio group will be created with. Together with the scope this uniquely identifies the portfolio group.") 
    created: Optional[datetime] = Field(default=None, description="The effective datetime at which the portfolio group was created. Defaults to the current LUSID system datetime if not specified.")
    values: Optional[List[ResourceId]] = Field(default=None, description="The resource identifiers of the portfolios to be contained within the portfolio group.")
    sub_groups: Optional[List[ResourceId]] = Field(default=None, description="The resource identifiers of the portfolio groups to be contained within the portfolio group as sub groups.", alias="subGroups")
    properties: Optional[Dict[str, ModelProperty]] = Field(default=None, description="A set of unique group properties to add to the portfolio group. Each property must be from the 'PortfolioGroup' domain and should be identified by its key which has the format {domain}/{scope}/{code}, e.g. 'PortfolioGroup/Manager/Id'. These properties must be pre-defined.")
    display_name:  StrictStr = Field(...,alias="displayName", description="The name of the portfolio group.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="A long form description of the portfolio group.") 
    __properties = ["code", "created", "values", "subGroups", "properties", "displayName", "description"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreatePortfolioGroupRequest:
        """Create an instance of CreatePortfolioGroupRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in values (list)
        _items = []
        if self.values:
            for _item in self.values:
                if _item:
                    _items.append(_item.to_dict())
            _dict['values'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sub_groups (list)
        _items = []
        if self.sub_groups:
            for _item in self.sub_groups:
                if _item:
                    _items.append(_item.to_dict())
            _dict['subGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # set to None if created (nullable) is None
        # and __fields_set__ contains the field
        if self.created is None and "created" in self.__fields_set__:
            _dict['created'] = None

        # set to None if values (nullable) is None
        # and __fields_set__ contains the field
        if self.values is None and "values" in self.__fields_set__:
            _dict['values'] = None

        # set to None if sub_groups (nullable) is None
        # and __fields_set__ contains the field
        if self.sub_groups is None and "sub_groups" in self.__fields_set__:
            _dict['subGroups'] = None

        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreatePortfolioGroupRequest:
        """Create an instance of CreatePortfolioGroupRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreatePortfolioGroupRequest.parse_obj(obj)

        _obj = CreatePortfolioGroupRequest.parse_obj({
            "code": obj.get("code"),
            "created": obj.get("created"),
            "values": [ResourceId.from_dict(_item) for _item in obj.get("values")] if obj.get("values") is not None else None,
            "sub_groups": [ResourceId.from_dict(_item) for _item in obj.get("subGroups")] if obj.get("subGroups") is not None else None,
            "properties": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None,
            "display_name": obj.get("displayName"),
            "description": obj.get("description")
        })
        return _obj

CreatePortfolioGroupRequest.update_forward_refs()
