# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.configuration_recipe import ConfigurationRecipe
from lusid.models.resource_id import ResourceId

class CreateRecipeRequest(BaseModel):
    """
    Specification class to request for the creation/supplementing of a configuration recipe  # noqa: E501
    """
    recipe_creation_market_data_scopes: List[StrictStr] = Field(description="The scopes in which the recipe creation would look for quotes/data.", alias="recipeCreationMarketDataScopes")
    recipe_id: Optional[ResourceId] = Field(default=None, alias="recipeId")
    inline_recipe: Optional[ConfigurationRecipe] = Field(default=None, alias="inlineRecipe")
    as_at: Optional[datetime] = Field(default=None, description="The asAt date to use", alias="asAt")
    effective_at:  StrictStr = Field(...,alias="effectiveAt", description="The market data time, i.e. the recipe generated will look for rules with this effectiveAt.") 
    __properties = ["recipeCreationMarketDataScopes", "recipeId", "inlineRecipe", "asAt", "effectiveAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateRecipeRequest:
        """Create an instance of CreateRecipeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of recipe_id
        if self.recipe_id:
            _dict['recipeId'] = self.recipe_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of inline_recipe
        if self.inline_recipe:
            _dict['inlineRecipe'] = self.inline_recipe.to_dict()
        # set to None if as_at (nullable) is None
        # and __fields_set__ contains the field
        if self.as_at is None and "as_at" in self.__fields_set__:
            _dict['asAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateRecipeRequest:
        """Create an instance of CreateRecipeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateRecipeRequest.parse_obj(obj)

        _obj = CreateRecipeRequest.parse_obj({
            "recipe_creation_market_data_scopes": obj.get("recipeCreationMarketDataScopes"),
            "recipe_id": ResourceId.from_dict(obj.get("recipeId")) if obj.get("recipeId") is not None else None,
            "inline_recipe": ConfigurationRecipe.from_dict(obj.get("inlineRecipe")) if obj.get("inlineRecipe") is not None else None,
            "as_at": obj.get("asAt"),
            "effective_at": obj.get("effectiveAt")
        })
        return _obj

CreateRecipeRequest.update_forward_refs()
