# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.resource_id import ResourceId

class CreditSupportAnnex(BaseModel):
    """
    Entity to capture the calculable and queryable methods and practices of determining and transferring collateral  to a counterparty as part of margining of transactions. These typically come from a particular ISDA agreement  that is in place between the two counterparties.  # noqa: E501
    """
    reference_currency:  StrictStr = Field(...,alias="referenceCurrency", description="The base, or reference, currency against which MtM value and exposure should be calculated  and in which the CSA parameters are defined if the currency is not otherwise explicitly stated.") 
    collateral_currencies: List[StrictStr] = Field(description="The set of currencies within which it is acceptable to post cash collateral.", alias="collateralCurrencies")
    isda_agreement_version:  StrictStr = Field(...,alias="isdaAgreementVersion", description="The transactions will take place with reference to a particular ISDA master agreement. This  will likely be either the ISDA 1992 or ISDA 2002 agremeents or ISDA close-out 2009.") 
    margin_call_frequency:  StrictStr = Field(...,alias="marginCallFrequency", description="The tenor, e.g. daily (1D) or biweekly (2W), at which frequency a margin call will be made, calculations  made and money transferred to readjust. The calculation might also require a specific time for valuation and notification.") 
    valuation_agent:  StrictStr = Field(...,alias="valuationAgent", description="Are the calculations performed by the institutions's counterparty or the institution trading with them.") 
    threshold_amount: Union[StrictFloat, StrictInt] = Field(description="At what level of exposure does collateral need to be posted. Will typically be zero for banks.  Should be stated in reference currency", alias="thresholdAmount")
    rounding_decimal_places: StrictInt = Field(description="Where a calculation needs to be rounded to a specific number of decimal places,  this states the number that that requires.", alias="roundingDecimalPlaces")
    initial_margin_amount: Union[StrictFloat, StrictInt] = Field(description="The initial margin that is required. In the reference currency", alias="initialMarginAmount")
    minimum_transfer_amount: Union[StrictFloat, StrictInt] = Field(description="The minimum amount, in the reference currency, that must be transferred when required.", alias="minimumTransferAmount")
    id: ResourceId
    __properties = ["referenceCurrency", "collateralCurrencies", "isdaAgreementVersion", "marginCallFrequency", "valuationAgent", "thresholdAmount", "roundingDecimalPlaces", "initialMarginAmount", "minimumTransferAmount", "id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreditSupportAnnex:
        """Create an instance of CreditSupportAnnex from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreditSupportAnnex:
        """Create an instance of CreditSupportAnnex from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreditSupportAnnex.parse_obj(obj)

        _obj = CreditSupportAnnex.parse_obj({
            "reference_currency": obj.get("referenceCurrency"),
            "collateral_currencies": obj.get("collateralCurrencies"),
            "isda_agreement_version": obj.get("isdaAgreementVersion"),
            "margin_call_frequency": obj.get("marginCallFrequency"),
            "valuation_agent": obj.get("valuationAgent"),
            "threshold_amount": obj.get("thresholdAmount"),
            "rounding_decimal_places": obj.get("roundingDecimalPlaces"),
            "initial_margin_amount": obj.get("initialMarginAmount"),
            "minimum_transfer_amount": obj.get("minimumTransferAmount"),
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None
        })
        return _obj

CreditSupportAnnex.update_forward_refs()
