# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class CustomEntityField(BaseModel):
    """
    CustomEntityField
    """
    name:  StrictStr = Field(...,alias="name", description="The name of the field in the custom entity type definition.") 
    value: Optional[Any] = Field(default=None, description="The value for the field.")
    effective_from: Optional[datetime] = Field(default=None, description="The effective datetime from which the field's value is valid. For timeVariant fields, this defaults to the beginning of time.", alias="effectiveFrom")
    effective_until: Optional[datetime] = Field(default=None, description="The effective datetime until which the field's value is valid. If not supplied, the value will be valid indefinitely or until the next “effectiveFrom” date of the field.", alias="effectiveUntil")
    __properties = ["name", "value", "effectiveFrom", "effectiveUntil"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CustomEntityField:
        """Create an instance of CustomEntityField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if value (nullable) is None
        # and __fields_set__ contains the field
        if self.value is None and "value" in self.__fields_set__:
            _dict['value'] = None

        # set to None if effective_from (nullable) is None
        # and __fields_set__ contains the field
        if self.effective_from is None and "effective_from" in self.__fields_set__:
            _dict['effectiveFrom'] = None

        # set to None if effective_until (nullable) is None
        # and __fields_set__ contains the field
        if self.effective_until is None and "effective_until" in self.__fields_set__:
            _dict['effectiveUntil'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CustomEntityField:
        """Create an instance of CustomEntityField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CustomEntityField.parse_obj(obj)

        _obj = CustomEntityField.parse_obj({
            "name": obj.get("name"),
            "value": obj.get("value"),
            "effective_from": obj.get("effectiveFrom"),
            "effective_until": obj.get("effectiveUntil")
        })
        return _obj

CustomEntityField.update_forward_refs()
