# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.data_definition import DataDefinition

class DataMapping(BaseModel):
    """
    When importing data from an external source there are essentially three levels of interaction with LUSID.  (1) The data is a raw document that LUSID does not understand. You can store and retrieve it but it does not full interact with other documents inside LUSID  (2) The data has a map from fields and paths to 'properties' in LUSID. In essence, LUSID can then treat the data as weakly typed (decimal, string) data that can be returned through queries      and where various aggregation requests will then work.  (3) The data is fully translatable into LUSID and understood, in some sense, natively. This means that it can be used for context sensitive calculations such as pricing or risk calculations.  The data map object is designed to allow data to transition from step 1 to 2 and in some cases as an alternative for step 2 to 3.  # noqa: E501
    """
    data_definitions: Optional[List[DataDefinition]] = Field(default=None, description="A map from LUSID item keys to data definitions that define the names, types and degree of uniqueness of data provided to LUSID in structured data stores.", alias="dataDefinitions")
    __properties = ["dataDefinitions"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DataMapping:
        """Create an instance of DataMapping from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in data_definitions (list)
        _items = []
        if self.data_definitions:
            for _item in self.data_definitions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dataDefinitions'] = _items
        # set to None if data_definitions (nullable) is None
        # and __fields_set__ contains the field
        if self.data_definitions is None and "data_definitions" in self.__fields_set__:
            _dict['dataDefinitions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DataMapping:
        """Create an instance of DataMapping from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DataMapping.parse_obj(obj)

        _obj = DataMapping.parse_obj({
            "data_definitions": [DataDefinition.from_dict(_item) for _item in obj.get("dataDefinitions")] if obj.get("dataDefinitions") is not None else None
        })
        return _obj

DataMapping.update_forward_refs()
