# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.lusid_entity_result import LusidEntityResult

class DataQualityCheckResult(BaseModel):
    """
    Represents the result of a data quality check operation  # noqa: E501
    """
    check_definition_scope:  Optional[StrictStr] = Field(None,alias="checkDefinitionScope", description="The scope of the check definition") 
    check_definition_code:  Optional[StrictStr] = Field(None,alias="checkDefinitionCode", description="The code of the check definition") 
    check_definition_display_name:  Optional[StrictStr] = Field(None,alias="checkDefinitionDisplayName", description="The display name of the check definition") 
    check_run_as_at: Optional[datetime] = Field(default=None, description="The timestamp when the check was run", alias="checkRunAsAt")
    result_type:  Optional[StrictStr] = Field(None,alias="resultType", description="The type of result from the check") 
    rule_set_key:  Optional[StrictStr] = Field(None,alias="ruleSetKey", description="The key identifying the ruleset") 
    rule_set_display_name:  Optional[StrictStr] = Field(None,alias="ruleSetDisplayName", description="The display name of the ruleset") 
    rule_key:  Optional[StrictStr] = Field(None,alias="ruleKey", description="The key identifying the rule (for RuleInvalid, RuleBreached, RuleBreachesOverLimit)") 
    rule_display_name:  Optional[StrictStr] = Field(None,alias="ruleDisplayName", description="The display name of the rule (for RuleInvalid, RuleBreached, RuleBreachesOverLimit)") 
    rule_description:  Optional[StrictStr] = Field(None,alias="ruleDescription", description="The description of the rule (for RuleInvalid, RuleBreached, RuleBreachesOverLimit)") 
    rule_formula:  Optional[StrictStr] = Field(None,alias="ruleFormula", description="The formula of the rule (for RuleInvalid, RuleBreached, RuleBreachesOverLimit)") 
    severity: Optional[StrictInt] = Field(default=None, description="The severity level")
    lusid_entity: Optional[LusidEntityResult] = Field(default=None, alias="lusidEntity")
    count_rule_breaches: Optional[StrictInt] = Field(default=None, description="The count of rule breaches (1 for RuleBreached, multiple for RuleBreachesOverLimit)", alias="countRuleBreaches")
    error_detail:  Optional[StrictStr] = Field(None,alias="errorDetail", description="Error details (for RulesetInvalid, RuleInvalid)") 
    result_id:  Optional[StrictStr] = Field(None,alias="resultId", description="Unique identifier for the result in format: {{GUID of Check Definition}}-{{resultType}}-{{rulesetKey}}-{{ruleKey}}-{{entity GUID}}") 
    __properties = ["checkDefinitionScope", "checkDefinitionCode", "checkDefinitionDisplayName", "checkRunAsAt", "resultType", "ruleSetKey", "ruleSetDisplayName", "ruleKey", "ruleDisplayName", "ruleDescription", "ruleFormula", "severity", "lusidEntity", "countRuleBreaches", "errorDetail", "resultId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DataQualityCheckResult:
        """Create an instance of DataQualityCheckResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of lusid_entity
        if self.lusid_entity:
            _dict['lusidEntity'] = self.lusid_entity.to_dict()
        # set to None if check_definition_scope (nullable) is None
        # and __fields_set__ contains the field
        if self.check_definition_scope is None and "check_definition_scope" in self.__fields_set__:
            _dict['checkDefinitionScope'] = None

        # set to None if check_definition_code (nullable) is None
        # and __fields_set__ contains the field
        if self.check_definition_code is None and "check_definition_code" in self.__fields_set__:
            _dict['checkDefinitionCode'] = None

        # set to None if check_definition_display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.check_definition_display_name is None and "check_definition_display_name" in self.__fields_set__:
            _dict['checkDefinitionDisplayName'] = None

        # set to None if result_type (nullable) is None
        # and __fields_set__ contains the field
        if self.result_type is None and "result_type" in self.__fields_set__:
            _dict['resultType'] = None

        # set to None if rule_set_key (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_set_key is None and "rule_set_key" in self.__fields_set__:
            _dict['ruleSetKey'] = None

        # set to None if rule_set_display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_set_display_name is None and "rule_set_display_name" in self.__fields_set__:
            _dict['ruleSetDisplayName'] = None

        # set to None if rule_key (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_key is None and "rule_key" in self.__fields_set__:
            _dict['ruleKey'] = None

        # set to None if rule_display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_display_name is None and "rule_display_name" in self.__fields_set__:
            _dict['ruleDisplayName'] = None

        # set to None if rule_description (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_description is None and "rule_description" in self.__fields_set__:
            _dict['ruleDescription'] = None

        # set to None if rule_formula (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_formula is None and "rule_formula" in self.__fields_set__:
            _dict['ruleFormula'] = None

        # set to None if severity (nullable) is None
        # and __fields_set__ contains the field
        if self.severity is None and "severity" in self.__fields_set__:
            _dict['severity'] = None

        # set to None if count_rule_breaches (nullable) is None
        # and __fields_set__ contains the field
        if self.count_rule_breaches is None and "count_rule_breaches" in self.__fields_set__:
            _dict['countRuleBreaches'] = None

        # set to None if error_detail (nullable) is None
        # and __fields_set__ contains the field
        if self.error_detail is None and "error_detail" in self.__fields_set__:
            _dict['errorDetail'] = None

        # set to None if result_id (nullable) is None
        # and __fields_set__ contains the field
        if self.result_id is None and "result_id" in self.__fields_set__:
            _dict['resultId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DataQualityCheckResult:
        """Create an instance of DataQualityCheckResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DataQualityCheckResult.parse_obj(obj)

        _obj = DataQualityCheckResult.parse_obj({
            "check_definition_scope": obj.get("checkDefinitionScope"),
            "check_definition_code": obj.get("checkDefinitionCode"),
            "check_definition_display_name": obj.get("checkDefinitionDisplayName"),
            "check_run_as_at": obj.get("checkRunAsAt"),
            "result_type": obj.get("resultType"),
            "rule_set_key": obj.get("ruleSetKey"),
            "rule_set_display_name": obj.get("ruleSetDisplayName"),
            "rule_key": obj.get("ruleKey"),
            "rule_display_name": obj.get("ruleDisplayName"),
            "rule_description": obj.get("ruleDescription"),
            "rule_formula": obj.get("ruleFormula"),
            "severity": obj.get("severity"),
            "lusid_entity": LusidEntityResult.from_dict(obj.get("lusidEntity")) if obj.get("lusidEntity") is not None else None,
            "count_rule_breaches": obj.get("countRuleBreaches"),
            "error_detail": obj.get("errorDetail"),
            "result_id": obj.get("resultId")
        })
        return _obj

DataQualityCheckResult.update_forward_refs()
