# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.link import Link
from lusid.models.staged_modifications_info import StagedModificationsInfo

class DeleteInstrumentsResponse(BaseModel):
    """
    DeleteInstrumentsResponse
    """
    href:  Optional[StrictStr] = Field(None,alias="href", description="The specific Uniform Resource Identifier (URI) for this resource at the requested effective and asAt datetime.") 
    as_at: datetime = Field(description="The as-at datetime at which the instrument was deleted.", alias="asAt")
    staged: Optional[Dict[str, StagedModificationsInfo]] = Field(default=None, description="Information about the pending staged modifications for the current entity.")
    links: Optional[List[Link]] = None
    __properties = ["href", "asAt", "staged", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DeleteInstrumentsResponse:
        """Create an instance of DeleteInstrumentsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "staged",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in staged (dict)
        _field_dict = {}
        if self.staged:
            for _key in self.staged:
                if self.staged[_key]:
                    _field_dict[_key] = self.staged[_key].to_dict()
            _dict['staged'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if staged (nullable) is None
        # and __fields_set__ contains the field
        if self.staged is None and "staged" in self.__fields_set__:
            _dict['staged'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DeleteInstrumentsResponse:
        """Create an instance of DeleteInstrumentsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DeleteInstrumentsResponse.parse_obj(obj)

        _obj = DeleteInstrumentsResponse.parse_obj({
            "href": obj.get("href"),
            "as_at": obj.get("asAt"),
            "staged": dict(
                (_k, StagedModificationsInfo.from_dict(_v))
                for _k, _v in obj.get("staged").items()
            )
            if obj.get("staged") is not None
            else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

DeleteInstrumentsResponse.update_forward_refs()
