# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.link import Link
from lusid.models.staged_modifications_info import StagedModificationsInfo

class DeletedEntityResponse(BaseModel):
    """
    DeletedEntityResponse
    """
    href:  Optional[StrictStr] = Field(None,alias="href", description="The specific Uniform Resource Identifier (URI) for this resource at the requested effective and asAt datetime.") 
    effective_from: Optional[datetime] = Field(default=None, description="The effective datetime at which the deletion became valid. May be null in the case where multiple date times are applicable.", alias="effectiveFrom")
    as_at: datetime = Field(description="The asAt datetime at which the deletion was committed to LUSID.", alias="asAt")
    entity_type:  Optional[StrictStr] = Field(None,alias="entityType", description="The type of the entity that the deleted response applies to.") 
    entity_unique_id:  Optional[StrictStr] = Field(None,alias="entityUniqueId", description="The unique Id of the entity that the deleted response applies to.") 
    staged_modifications: Optional[StagedModificationsInfo] = Field(default=None, alias="stagedModifications")
    links: Optional[List[Link]] = None
    __properties = ["href", "effectiveFrom", "asAt", "entityType", "entityUniqueId", "stagedModifications", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DeletedEntityResponse:
        """Create an instance of DeletedEntityResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of staged_modifications
        if self.staged_modifications:
            _dict['stagedModifications'] = self.staged_modifications.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if effective_from (nullable) is None
        # and __fields_set__ contains the field
        if self.effective_from is None and "effective_from" in self.__fields_set__:
            _dict['effectiveFrom'] = None

        # set to None if entity_type (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_type is None and "entity_type" in self.__fields_set__:
            _dict['entityType'] = None

        # set to None if entity_unique_id (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_unique_id is None and "entity_unique_id" in self.__fields_set__:
            _dict['entityUniqueId'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DeletedEntityResponse:
        """Create an instance of DeletedEntityResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DeletedEntityResponse.parse_obj(obj)

        _obj = DeletedEntityResponse.parse_obj({
            "href": obj.get("href"),
            "effective_from": obj.get("effectiveFrom"),
            "as_at": obj.get("asAt"),
            "entity_type": obj.get("entityType"),
            "entity_unique_id": obj.get("entityUniqueId"),
            "staged_modifications": StagedModificationsInfo.from_dict(obj.get("stagedModifications")) if obj.get("stagedModifications") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

DeletedEntityResponse.update_forward_refs()
