# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.address_key_filter import AddressKeyFilter

class DependencySourceFilter(BaseModel):
    """
    Encapsulates parts of a market data rule relating not to the nature of the market data requested, but rather the nature of the thing (instrument/model) that is requesting it.  In the first instance, this includes the instrument type, asset class, and the currency of the underlying instrument.  This can be used to differentiate requests for market data according to the source of the request. See MarketDataSpecificRule.  # noqa: E501
    """
    instrument_type:  Optional[StrictStr] = Field(None,alias="instrumentType", description="Specify that a rule should only apply if the market data is requested by an instrument of a given instrument type.  If null, then no filtering on instrument type is applied.") 
    asset_class:  Optional[StrictStr] = Field(None,alias="assetClass", description="Specify that a rule should only apply if the market data is requested by an instrument of a given asset class.  If null, then no filtering on asset class is applied.") 
    dom_ccy:  Optional[StrictStr] = Field(None,alias="domCcy", description="Specify that a rule should only apply if the market data is requested by an instrument with a given domestic currency.  If null, then no filtering on currency is applied.") 
    long_or_short_indicator:  Optional[StrictStr] = Field(None,alias="longOrShortIndicator", description="Specify that a rule should apply if the market data is requested by a model with a given long or short indicator.  If none, then no filtering on LongOrShortIndicator is applied.") 
    address_key_filters: Optional[List[AddressKeyFilter]] = Field(default=None, description="Specify that a rule should apply if the market data is requested by an instrument with features or properties  satisfying all the given address key filters. If an empty list is given, no additional filtering is done.", alias="addressKeyFilters")
    __properties = ["instrumentType", "assetClass", "domCcy", "longOrShortIndicator", "addressKeyFilters"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DependencySourceFilter:
        """Create an instance of DependencySourceFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in address_key_filters (list)
        _items = []
        if self.address_key_filters:
            for _item in self.address_key_filters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['addressKeyFilters'] = _items
        # set to None if instrument_type (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_type is None and "instrument_type" in self.__fields_set__:
            _dict['instrumentType'] = None

        # set to None if asset_class (nullable) is None
        # and __fields_set__ contains the field
        if self.asset_class is None and "asset_class" in self.__fields_set__:
            _dict['assetClass'] = None

        # set to None if dom_ccy (nullable) is None
        # and __fields_set__ contains the field
        if self.dom_ccy is None and "dom_ccy" in self.__fields_set__:
            _dict['domCcy'] = None

        # set to None if long_or_short_indicator (nullable) is None
        # and __fields_set__ contains the field
        if self.long_or_short_indicator is None and "long_or_short_indicator" in self.__fields_set__:
            _dict['longOrShortIndicator'] = None

        # set to None if address_key_filters (nullable) is None
        # and __fields_set__ contains the field
        if self.address_key_filters is None and "address_key_filters" in self.__fields_set__:
            _dict['addressKeyFilters'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DependencySourceFilter:
        """Create an instance of DependencySourceFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DependencySourceFilter.parse_obj(obj)

        _obj = DependencySourceFilter.parse_obj({
            "instrument_type": obj.get("instrumentType"),
            "asset_class": obj.get("assetClass"),
            "dom_ccy": obj.get("domCcy"),
            "long_or_short_indicator": obj.get("longOrShortIndicator"),
            "address_key_filters": [AddressKeyFilter.from_dict(_item) for _item in obj.get("addressKeyFilters")] if obj.get("addressKeyFilters") is not None else None
        })
        return _obj

DependencySourceFilter.update_forward_refs()
