# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class DerivationFormulaExplainRequest(BaseModel):
    """
    DerivationFormulaExplainRequest
    """
    entity_type:  StrictStr = Field(...,alias="entityType", description="The type of the entity for which the derived property or partial formula is to be resolved against.") 
    scope:  Optional[StrictStr] = Field(None,alias="scope", description="(Optional) The scope that entity exists in. If no scope is provided, the default scope for the entity type will be used.") 
    code:  Optional[StrictStr] = Field(None,alias="code", description="(Optional) The code of the entity, to be provided for entities that support scope/code retrieval. If no code or identifier is provided, the logical evaluation tree without resolved values is returned.") 
    identifier: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="(Optional). An identifier key/value pair that uniquely identifies the entity to explain the derived property for. This can be either an instrument identifier, or an identifier property. If no code or identifier is provided, the logical evaluation tree without resolved values is returned.")
    property_key:  Optional[StrictStr] = Field(None,alias="propertyKey", description="(Optional) The key of the derived property to get an explanation for. This takes the format {domain}/{scope}/{code}. One of either property key or partial formula must be provided.") 
    partial_formula:  Optional[StrictStr] = Field(None,alias="partialFormula", description="(Optional) A partial derivation formula to get an explanation for. Can be provided in lieu of a property key. One of either property key or partial formula must be provided.") 
    __properties = ["entityType", "scope", "code", "identifier", "propertyKey", "partialFormula"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DerivationFormulaExplainRequest:
        """Create an instance of DerivationFormulaExplainRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if scope (nullable) is None
        # and __fields_set__ contains the field
        if self.scope is None and "scope" in self.__fields_set__:
            _dict['scope'] = None

        # set to None if code (nullable) is None
        # and __fields_set__ contains the field
        if self.code is None and "code" in self.__fields_set__:
            _dict['code'] = None

        # set to None if identifier (nullable) is None
        # and __fields_set__ contains the field
        if self.identifier is None and "identifier" in self.__fields_set__:
            _dict['identifier'] = None

        # set to None if property_key (nullable) is None
        # and __fields_set__ contains the field
        if self.property_key is None and "property_key" in self.__fields_set__:
            _dict['propertyKey'] = None

        # set to None if partial_formula (nullable) is None
        # and __fields_set__ contains the field
        if self.partial_formula is None and "partial_formula" in self.__fields_set__:
            _dict['partialFormula'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DerivationFormulaExplainRequest:
        """Create an instance of DerivationFormulaExplainRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DerivationFormulaExplainRequest.parse_obj(obj)

        _obj = DerivationFormulaExplainRequest.parse_obj({
            "entity_type": obj.get("entityType"),
            "scope": obj.get("scope"),
            "code": obj.get("code"),
            "identifier": obj.get("identifier"),
            "property_key": obj.get("propertyKey"),
            "partial_formula": obj.get("partialFormula")
        })
        return _obj

DerivationFormulaExplainRequest.update_forward_refs()
