# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.link import Link
from lusid.models.property_value import PropertyValue

class DerivedPropertyComponent(BaseModel):
    """
    DerivedPropertyComponent
    """
    component:  Optional[StrictStr] = Field(None,alias="component", description="The component of the formula which is being evaluated.") 
    type:  Optional[StrictStr] = Field(None,alias="type", description="The type of the formula component. This can be a Literal, Variable, DerivedProperty, or PartialFormula.") 
    value: Optional[PropertyValue] = None
    derivation_formula:  Optional[StrictStr] = Field(None,alias="derivationFormula", description="The derivation formula of the component. This field will only be populated if the component is a derived property.") 
    sub_components: Optional[List[DerivedPropertyComponent]] = Field(default=None, description="Any sub-components of this formula. If this formula cannot be further decomposed, this collection will be null.", alias="subComponents")
    links: Optional[List[Link]] = None
    __properties = ["component", "type", "value", "derivationFormula", "subComponents", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DerivedPropertyComponent:
        """Create an instance of DerivedPropertyComponent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of value
        if self.value:
            _dict['value'] = self.value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sub_components (list)
        _items = []
        if self.sub_components:
            for _item in self.sub_components:
                if _item:
                    _items.append(_item.to_dict())
            _dict['subComponents'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if component (nullable) is None
        # and __fields_set__ contains the field
        if self.component is None and "component" in self.__fields_set__:
            _dict['component'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if derivation_formula (nullable) is None
        # and __fields_set__ contains the field
        if self.derivation_formula is None and "derivation_formula" in self.__fields_set__:
            _dict['derivationFormula'] = None

        # set to None if sub_components (nullable) is None
        # and __fields_set__ contains the field
        if self.sub_components is None and "sub_components" in self.__fields_set__:
            _dict['subComponents'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DerivedPropertyComponent:
        """Create an instance of DerivedPropertyComponent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DerivedPropertyComponent.parse_obj(obj)

        _obj = DerivedPropertyComponent.parse_obj({
            "component": obj.get("component"),
            "type": obj.get("type"),
            "value": PropertyValue.from_dict(obj.get("value")) if obj.get("value") is not None else None,
            "derivation_formula": obj.get("derivationFormula"),
            "sub_components": [DerivedPropertyComponent.from_dict(_item) for _item in obj.get("subComponents")] if obj.get("subComponents") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

DerivedPropertyComponent.update_forward_refs()
