# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.compounding import Compounding
from lusid.models.ex_dividend_configuration import ExDividendConfiguration
from lusid.models.flow_convention_name import FlowConventionName
from lusid.models.flow_conventions import FlowConventions
from lusid.models.index_convention import IndexConvention
from lusid.models.schedule import Schedule

class FloatSchedule(Schedule):
    """
    Schedule for floating rate coupon payments.  # noqa: E501
    """
    start_date: Optional[datetime] = Field(default=None, description="Date from which LUSID starts generating the payment schedule.", alias="startDate")
    maturity_date: Optional[datetime] = Field(default=None, description="Last date of the payment generation schedule. May not necessarily be the maturity date  of the underlying instrument (e.g. in case the instrument has multiple payment schedules).", alias="maturityDate")
    flow_conventions: Optional[FlowConventions] = Field(default=None, alias="flowConventions")
    convention_name: Optional[FlowConventionName] = Field(default=None, alias="conventionName")
    ex_dividend_days: Optional[StrictInt] = Field(default=None, description="Optional. Number of calendar days in the ex-dividend period.  If the settlement date falls in the ex-dividend period then the coupon paid is zero and the accrued interest is negative.  If set, this must be a non-negative number.  If not set, or set to 0, then there is no ex-dividend period.                NOTE: This field is deprecated.  If you wish to set the ExDividendDays on a bond, please use the ExDividendConfiguration.", alias="exDividendDays")
    index_convention_name: Optional[FlowConventionName] = Field(default=None, alias="indexConventionName")
    index_conventions: Optional[IndexConvention] = Field(default=None, alias="indexConventions")
    notional: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Scaling factor, the quantity outstanding on which the rate will be paid.")
    payment_currency:  StrictStr = Field(...,alias="paymentCurrency", description="Payment currency. This does not have to be the same as the nominal bond or observation/reset currency.") 
    spread: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Spread over floating rate given as a fraction.")
    stub_type:  Optional[StrictStr] = Field(None,alias="stubType", description="When a payment schedule doesn't have regular payment intervals just because of the  first and/or last coupons of the schedule, we call those irregular coupons stubs.  This configuration specifies what type of stub is used when building the schedule  Supported values are:  None = this is a regular payment schedule with no stubs. DO NOT use it with irregular schedules or you will get incorrect and unexpected behaviour.  ShortFront = this is an irregular payment schedule where only the first coupon is irregular, and covers a payment period that is shorter than the regular payment period.  ShortBack = this is an irregular payment schedule where only the last coupon is irregular, and covers a payment period that is shorter than the regular payment period.  LongFront = this is an irregular payment schedule where only the first coupon is irregular, and covers a payment period that is longer than the regular payment period.  LongBack = this is an irregular payment schedule where only the last coupon is irregular, and covers a payment period that is longer than the regular payment period.  Both = this is an irregular payment schedule where both the first and the last coupons are irregular, and the length of these periods is calculated based on the first coupon payment date that should have been explicitly set.") 
    ex_dividend_configuration: Optional[ExDividendConfiguration] = Field(default=None, alias="exDividendConfiguration")
    compounding: Optional[Compounding] = None
    reset_convention:  Optional[StrictStr] = Field(None,alias="resetConvention", description="Control how resets are generated relative to payment convention(s).    Supported string (enumeration) values are: [InAdvance, InArrears].  Defaults to \"InAdvance\" if not set.") 
    use_annualised_direct_rates: Optional[StrictBool] = Field(default=None, description="Flag indicating whether to use daily updated annualised interest  rates for calculating the accrued interest. Defaults to false.", alias="useAnnualisedDirectRates")
    cap_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The maximum floating rate which a cashflow can accrue.", alias="capRate")
    floor_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The minimum floating rate which a cashflow can accrue.", alias="floorRate")
    schedule_type:  StrictStr = Field(...,alias="scheduleType", description="The available values are: FixedSchedule, FloatSchedule, OptionalitySchedule, StepSchedule, Exercise, FxRateSchedule, FxLinkedNotionalSchedule, BondConversionSchedule, Invalid") 
    additional_properties: Dict[str, Any] = {}
    __properties = ["scheduleType", "startDate", "maturityDate", "flowConventions", "conventionName", "exDividendDays", "indexConventionName", "indexConventions", "notional", "paymentCurrency", "spread", "stubType", "exDividendConfiguration", "compounding", "resetConvention", "useAnnualisedDirectRates", "capRate", "floorRate"]

    @validator('schedule_type')
    def schedule_type_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'FloatSchedule' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse',
                                    'Library',
                                    'LibraryResponse',
                                    'DayRegularity',
                                    'RelativeMonthRegularity',
                                    'SpecificMonthRegularity',
                                    'WeekRegularity',
                                    'YearRegularity']:
           return value
        
        # Only validate the 'type' property of the class
        if "schedule_type" != "type":
            return value

        if value not in ['FixedSchedule', 'FloatSchedule', 'OptionalitySchedule', 'StepSchedule', 'Exercise', 'FxRateSchedule', 'FxLinkedNotionalSchedule', 'BondConversionSchedule', 'Invalid']:
            raise ValueError("must be one of enum values ('FixedSchedule', 'FloatSchedule', 'OptionalitySchedule', 'StepSchedule', 'Exercise', 'FxRateSchedule', 'FxLinkedNotionalSchedule', 'BondConversionSchedule', 'Invalid')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FloatSchedule:
        """Create an instance of FloatSchedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "additional_properties"
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of flow_conventions
        if self.flow_conventions:
            _dict['flowConventions'] = self.flow_conventions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of convention_name
        if self.convention_name:
            _dict['conventionName'] = self.convention_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of index_convention_name
        if self.index_convention_name:
            _dict['indexConventionName'] = self.index_convention_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of index_conventions
        if self.index_conventions:
            _dict['indexConventions'] = self.index_conventions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ex_dividend_configuration
        if self.ex_dividend_configuration:
            _dict['exDividendConfiguration'] = self.ex_dividend_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compounding
        if self.compounding:
            _dict['compounding'] = self.compounding.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if ex_dividend_days (nullable) is None
        # and __fields_set__ contains the field
        if self.ex_dividend_days is None and "ex_dividend_days" in self.__fields_set__:
            _dict['exDividendDays'] = None

        # set to None if stub_type (nullable) is None
        # and __fields_set__ contains the field
        if self.stub_type is None and "stub_type" in self.__fields_set__:
            _dict['stubType'] = None

        # set to None if reset_convention (nullable) is None
        # and __fields_set__ contains the field
        if self.reset_convention is None and "reset_convention" in self.__fields_set__:
            _dict['resetConvention'] = None

        # set to None if cap_rate (nullable) is None
        # and __fields_set__ contains the field
        if self.cap_rate is None and "cap_rate" in self.__fields_set__:
            _dict['capRate'] = None

        # set to None if floor_rate (nullable) is None
        # and __fields_set__ contains the field
        if self.floor_rate is None and "floor_rate" in self.__fields_set__:
            _dict['floorRate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FloatSchedule:
        """Create an instance of FloatSchedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FloatSchedule.parse_obj(obj)

        _obj = FloatSchedule.parse_obj({
            "schedule_type": obj.get("scheduleType"),
            "start_date": obj.get("startDate"),
            "maturity_date": obj.get("maturityDate"),
            "flow_conventions": FlowConventions.from_dict(obj.get("flowConventions")) if obj.get("flowConventions") is not None else None,
            "convention_name": FlowConventionName.from_dict(obj.get("conventionName")) if obj.get("conventionName") is not None else None,
            "ex_dividend_days": obj.get("exDividendDays"),
            "index_convention_name": FlowConventionName.from_dict(obj.get("indexConventionName")) if obj.get("indexConventionName") is not None else None,
            "index_conventions": IndexConvention.from_dict(obj.get("indexConventions")) if obj.get("indexConventions") is not None else None,
            "notional": obj.get("notional"),
            "payment_currency": obj.get("paymentCurrency"),
            "spread": obj.get("spread"),
            "stub_type": obj.get("stubType"),
            "ex_dividend_configuration": ExDividendConfiguration.from_dict(obj.get("exDividendConfiguration")) if obj.get("exDividendConfiguration") is not None else None,
            "compounding": Compounding.from_dict(obj.get("compounding")) if obj.get("compounding") is not None else None,
            "reset_convention": obj.get("resetConvention"),
            "use_annualised_direct_rates": obj.get("useAnnualisedDirectRates"),
            "cap_rate": obj.get("capRate"),
            "floor_rate": obj.get("floorRate")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj

FloatSchedule.update_forward_refs()
