# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.component_filter import ComponentFilter
from lusid.models.external_fee_component_filter import ExternalFeeComponentFilter
from lusid.models.model_property import ModelProperty

class FundConfigurationRequest(BaseModel):
    """
    FundConfigurationRequest
    """
    code:  StrictStr = Field(...,alias="code", description="") 
    display_name:  Optional[StrictStr] = Field(None,alias="displayName", description="The name of the Fund.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="A description for the Fund.") 
    dealing_filters: List[ComponentFilter] = Field(description="The set of filters used to decide which JE lines are included in the dealing.", alias="dealingFilters")
    pnl_filters: List[ComponentFilter] = Field(description="The set of filters used to decide which JE lines are included in the PnL.", alias="pnlFilters")
    back_out_filters: List[ComponentFilter] = Field(description="The set of filters used to decide which JE lines are included in the back outs.", alias="backOutFilters")
    external_fee_filters: Optional[List[ExternalFeeComponentFilter]] = Field(default=None, description="The set of filters used to decide which JE lines are used for inputting fees from an external source.", alias="externalFeeFilters")
    properties: Optional[Dict[str, ModelProperty]] = Field(default=None, description="A set of properties for the Fund Configuration.")
    __properties = ["code", "displayName", "description", "dealingFilters", "pnlFilters", "backOutFilters", "externalFeeFilters", "properties"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FundConfigurationRequest:
        """Create an instance of FundConfigurationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in dealing_filters (list)
        _items = []
        if self.dealing_filters:
            for _item in self.dealing_filters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dealingFilters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pnl_filters (list)
        _items = []
        if self.pnl_filters:
            for _item in self.pnl_filters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['pnlFilters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in back_out_filters (list)
        _items = []
        if self.back_out_filters:
            for _item in self.back_out_filters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['backOutFilters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in external_fee_filters (list)
        _items = []
        if self.external_fee_filters:
            for _item in self.external_fee_filters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['externalFeeFilters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if external_fee_filters (nullable) is None
        # and __fields_set__ contains the field
        if self.external_fee_filters is None and "external_fee_filters" in self.__fields_set__:
            _dict['externalFeeFilters'] = None

        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FundConfigurationRequest:
        """Create an instance of FundConfigurationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FundConfigurationRequest.parse_obj(obj)

        _obj = FundConfigurationRequest.parse_obj({
            "code": obj.get("code"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "dealing_filters": [ComponentFilter.from_dict(_item) for _item in obj.get("dealingFilters")] if obj.get("dealingFilters") is not None else None,
            "pnl_filters": [ComponentFilter.from_dict(_item) for _item in obj.get("pnlFilters")] if obj.get("pnlFilters") is not None else None,
            "back_out_filters": [ComponentFilter.from_dict(_item) for _item in obj.get("backOutFilters")] if obj.get("backOutFilters") is not None else None,
            "external_fee_filters": [ExternalFeeComponentFilter.from_dict(_item) for _item in obj.get("externalFeeFilters")] if obj.get("externalFeeFilters") is not None else None,
            "properties": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None
        })
        return _obj

FundConfigurationRequest.update_forward_refs()
