# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.instrument_event import InstrumentEvent

class FxForwardSettlementEvent(InstrumentEvent):
    """
    Settlement for FX Forward, including NDF and deliverable.  # noqa: E501
    """
    maturity_date: Optional[datetime] = Field(default=None, description="Maturity date of the forward", alias="maturityDate")
    dom_amount_per_unit: Union[StrictFloat, StrictInt] = Field(description="Amount per unit in the DomCcy (domestic currency)", alias="domAmountPerUnit")
    dom_ccy:  StrictStr = Field(...,alias="domCcy", description="The domestic currency of the forward") 
    fgn_amount_per_unit: Union[StrictFloat, StrictInt] = Field(description="Amount per unit in the FgnCcy (foreign currency)", alias="fgnAmountPerUnit")
    fgn_ccy:  StrictStr = Field(...,alias="fgnCcy", description="The foreign currency of the forward.") 
    is_ndf: StrictBool = Field(description="Is this settlement corresponding to a deliverable forward, or an NDF", alias="isNdf")
    fixing_date: Optional[datetime] = Field(default=None, description="Optional.  Required if the event is an NDF (i.e. if IsNdf = true).  Date of the FxRate fixings.", alias="fixingDate")
    settlement_ccy:  Optional[StrictStr] = Field(None,alias="settlementCcy", description="Optional.  Required if the event is an NDF (i.e. if IsNdf = true).  May be set to either DomCcy or FgnCcy, or a third currency.") 
    cash_flow_per_unit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Optional.  Required if the event is an NDF (i.e. if IsNdf = true).  CashFlow per unit.  Paid in the SettlementCcy.", alias="cashFlowPerUnit")
    domestic_to_foreign_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Domestic currency to foreign currency FX rate.  Not required, only used to override quotes.", alias="domesticToForeignRate")
    domestic_to_settlement_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Domestic currency to settlement currency FX rate  Not required, only used to override quotes.", alias="domesticToSettlementRate")
    foreign_to_settlement_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Foreign currency to settlement currency FX rate  Not required, only used to override quotes.", alias="foreignToSettlementRate")
    instrument_event_type:  StrictStr = Field(...,alias="instrumentEventType", description="The Type of Event. The available values are: TransitionEvent, InformationalEvent, OpenEvent, CloseEvent, StockSplitEvent, BondDefaultEvent, CashDividendEvent, AmortisationEvent, CashFlowEvent, ExerciseEvent, ResetEvent, TriggerEvent, RawVendorEvent, InformationalErrorEvent, BondCouponEvent, DividendReinvestmentEvent, AccumulationEvent, BondPrincipalEvent, DividendOptionEvent, MaturityEvent, FxForwardSettlementEvent, ExpiryEvent, ScripDividendEvent, StockDividendEvent, ReverseStockSplitEvent, CapitalDistributionEvent, SpinOffEvent, MergerEvent, FutureExpiryEvent, SwapCashFlowEvent, SwapPrincipalEvent, CreditPremiumCashFlowEvent, CdsCreditEvent, CdxCreditEvent, MbsCouponEvent, MbsPrincipalEvent, BonusIssueEvent, MbsPrincipalWriteOffEvent, MbsInterestDeferralEvent, MbsInterestShortfallEvent, TenderEvent, CallOnIntermediateSecuritiesEvent, IntermediateSecuritiesDistributionEvent, OptionExercisePhysicalEvent, OptionExerciseCashEvent, ProtectionPayoutCashFlowEvent, TermDepositInterestEvent, TermDepositPrincipalEvent, EarlyRedemptionEvent, FutureMarkToMarketEvent, AdjustGlobalCommitmentEvent, ContractInitialisationEvent, DrawdownEvent, LoanInterestRepaymentEvent, UpdateDepositAmountEvent, LoanPrincipalRepaymentEvent, DepositInterestPaymentEvent, DepositCloseEvent, LoanFacilityContractRolloverEvent, RepurchaseOfferEvent, RepoPartialClosureEvent, RepoCashFlowEvent, FlexibleRepoInterestPaymentEvent, FlexibleRepoCashFlowEvent, FlexibleRepoCollateralEvent, ConversionEvent, FlexibleRepoPartialClosureEvent, FlexibleRepoFullClosureEvent, CapletFloorletCashFlowEvent, EarlyCloseOutEvent") 
    additional_properties: Dict[str, Any] = {}
    __properties = ["instrumentEventType", "maturityDate", "domAmountPerUnit", "domCcy", "fgnAmountPerUnit", "fgnCcy", "isNdf", "fixingDate", "settlementCcy", "cashFlowPerUnit", "domesticToForeignRate", "domesticToSettlementRate", "foreignToSettlementRate"]

    @validator('instrument_event_type')
    def instrument_event_type_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'FxForwardSettlementEvent' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse',
                                    'Library',
                                    'LibraryResponse',
                                    'DayRegularity',
                                    'RelativeMonthRegularity',
                                    'SpecificMonthRegularity',
                                    'WeekRegularity',
                                    'YearRegularity']:
           return value
        
        # Only validate the 'type' property of the class
        if "instrument_event_type" != "type":
            return value

        if value not in ['TransitionEvent', 'InformationalEvent', 'OpenEvent', 'CloseEvent', 'StockSplitEvent', 'BondDefaultEvent', 'CashDividendEvent', 'AmortisationEvent', 'CashFlowEvent', 'ExerciseEvent', 'ResetEvent', 'TriggerEvent', 'RawVendorEvent', 'InformationalErrorEvent', 'BondCouponEvent', 'DividendReinvestmentEvent', 'AccumulationEvent', 'BondPrincipalEvent', 'DividendOptionEvent', 'MaturityEvent', 'FxForwardSettlementEvent', 'ExpiryEvent', 'ScripDividendEvent', 'StockDividendEvent', 'ReverseStockSplitEvent', 'CapitalDistributionEvent', 'SpinOffEvent', 'MergerEvent', 'FutureExpiryEvent', 'SwapCashFlowEvent', 'SwapPrincipalEvent', 'CreditPremiumCashFlowEvent', 'CdsCreditEvent', 'CdxCreditEvent', 'MbsCouponEvent', 'MbsPrincipalEvent', 'BonusIssueEvent', 'MbsPrincipalWriteOffEvent', 'MbsInterestDeferralEvent', 'MbsInterestShortfallEvent', 'TenderEvent', 'CallOnIntermediateSecuritiesEvent', 'IntermediateSecuritiesDistributionEvent', 'OptionExercisePhysicalEvent', 'OptionExerciseCashEvent', 'ProtectionPayoutCashFlowEvent', 'TermDepositInterestEvent', 'TermDepositPrincipalEvent', 'EarlyRedemptionEvent', 'FutureMarkToMarketEvent', 'AdjustGlobalCommitmentEvent', 'ContractInitialisationEvent', 'DrawdownEvent', 'LoanInterestRepaymentEvent', 'UpdateDepositAmountEvent', 'LoanPrincipalRepaymentEvent', 'DepositInterestPaymentEvent', 'DepositCloseEvent', 'LoanFacilityContractRolloverEvent', 'RepurchaseOfferEvent', 'RepoPartialClosureEvent', 'RepoCashFlowEvent', 'FlexibleRepoInterestPaymentEvent', 'FlexibleRepoCashFlowEvent', 'FlexibleRepoCollateralEvent', 'ConversionEvent', 'FlexibleRepoPartialClosureEvent', 'FlexibleRepoFullClosureEvent', 'CapletFloorletCashFlowEvent', 'EarlyCloseOutEvent']:
            raise ValueError("must be one of enum values ('TransitionEvent', 'InformationalEvent', 'OpenEvent', 'CloseEvent', 'StockSplitEvent', 'BondDefaultEvent', 'CashDividendEvent', 'AmortisationEvent', 'CashFlowEvent', 'ExerciseEvent', 'ResetEvent', 'TriggerEvent', 'RawVendorEvent', 'InformationalErrorEvent', 'BondCouponEvent', 'DividendReinvestmentEvent', 'AccumulationEvent', 'BondPrincipalEvent', 'DividendOptionEvent', 'MaturityEvent', 'FxForwardSettlementEvent', 'ExpiryEvent', 'ScripDividendEvent', 'StockDividendEvent', 'ReverseStockSplitEvent', 'CapitalDistributionEvent', 'SpinOffEvent', 'MergerEvent', 'FutureExpiryEvent', 'SwapCashFlowEvent', 'SwapPrincipalEvent', 'CreditPremiumCashFlowEvent', 'CdsCreditEvent', 'CdxCreditEvent', 'MbsCouponEvent', 'MbsPrincipalEvent', 'BonusIssueEvent', 'MbsPrincipalWriteOffEvent', 'MbsInterestDeferralEvent', 'MbsInterestShortfallEvent', 'TenderEvent', 'CallOnIntermediateSecuritiesEvent', 'IntermediateSecuritiesDistributionEvent', 'OptionExercisePhysicalEvent', 'OptionExerciseCashEvent', 'ProtectionPayoutCashFlowEvent', 'TermDepositInterestEvent', 'TermDepositPrincipalEvent', 'EarlyRedemptionEvent', 'FutureMarkToMarketEvent', 'AdjustGlobalCommitmentEvent', 'ContractInitialisationEvent', 'DrawdownEvent', 'LoanInterestRepaymentEvent', 'UpdateDepositAmountEvent', 'LoanPrincipalRepaymentEvent', 'DepositInterestPaymentEvent', 'DepositCloseEvent', 'LoanFacilityContractRolloverEvent', 'RepurchaseOfferEvent', 'RepoPartialClosureEvent', 'RepoCashFlowEvent', 'FlexibleRepoInterestPaymentEvent', 'FlexibleRepoCashFlowEvent', 'FlexibleRepoCollateralEvent', 'ConversionEvent', 'FlexibleRepoPartialClosureEvent', 'FlexibleRepoFullClosureEvent', 'CapletFloorletCashFlowEvent', 'EarlyCloseOutEvent')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FxForwardSettlementEvent:
        """Create an instance of FxForwardSettlementEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "foreign_to_settlement_rate",
                            "additional_properties"
                          },
                          exclude_none=True)
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if fixing_date (nullable) is None
        # and __fields_set__ contains the field
        if self.fixing_date is None and "fixing_date" in self.__fields_set__:
            _dict['fixingDate'] = None

        # set to None if settlement_ccy (nullable) is None
        # and __fields_set__ contains the field
        if self.settlement_ccy is None and "settlement_ccy" in self.__fields_set__:
            _dict['settlementCcy'] = None

        # set to None if cash_flow_per_unit (nullable) is None
        # and __fields_set__ contains the field
        if self.cash_flow_per_unit is None and "cash_flow_per_unit" in self.__fields_set__:
            _dict['cashFlowPerUnit'] = None

        # set to None if domestic_to_foreign_rate (nullable) is None
        # and __fields_set__ contains the field
        if self.domestic_to_foreign_rate is None and "domestic_to_foreign_rate" in self.__fields_set__:
            _dict['domesticToForeignRate'] = None

        # set to None if domestic_to_settlement_rate (nullable) is None
        # and __fields_set__ contains the field
        if self.domestic_to_settlement_rate is None and "domestic_to_settlement_rate" in self.__fields_set__:
            _dict['domesticToSettlementRate'] = None

        # set to None if foreign_to_settlement_rate (nullable) is None
        # and __fields_set__ contains the field
        if self.foreign_to_settlement_rate is None and "foreign_to_settlement_rate" in self.__fields_set__:
            _dict['foreignToSettlementRate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FxForwardSettlementEvent:
        """Create an instance of FxForwardSettlementEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FxForwardSettlementEvent.parse_obj(obj)

        _obj = FxForwardSettlementEvent.parse_obj({
            "instrument_event_type": obj.get("instrumentEventType"),
            "maturity_date": obj.get("maturityDate"),
            "dom_amount_per_unit": obj.get("domAmountPerUnit"),
            "dom_ccy": obj.get("domCcy"),
            "fgn_amount_per_unit": obj.get("fgnAmountPerUnit"),
            "fgn_ccy": obj.get("fgnCcy"),
            "is_ndf": obj.get("isNdf"),
            "fixing_date": obj.get("fixingDate"),
            "settlement_ccy": obj.get("settlementCcy"),
            "cash_flow_per_unit": obj.get("cashFlowPerUnit"),
            "domestic_to_foreign_rate": obj.get("domesticToForeignRate"),
            "domestic_to_settlement_rate": obj.get("domesticToSettlementRate"),
            "foreign_to_settlement_rate": obj.get("foreignToSettlementRate")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj

FxForwardSettlementEvent.update_forward_refs()
