# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.group_reconciliation_comparison_rule_string_value_map import GroupReconciliationComparisonRuleStringValueMap
from lusid.models.group_reconciliation_core_comparison_rule_operand import GroupReconciliationCoreComparisonRuleOperand

class GroupReconciliationCoreAttributeRule(BaseModel):
    """
    GroupReconciliationCoreAttributeRule
    """
    left: GroupReconciliationCoreComparisonRuleOperand
    right: GroupReconciliationCoreComparisonRuleOperand
    allowable_string_mappings: Optional[List[GroupReconciliationComparisonRuleStringValueMap]] = Field(default=None, description="The string mappings to use when comparing", alias="allowableStringMappings")
    is_comparison_case_sensitive: StrictBool = Field(description="Whether the compare keys and strings mappings case sensitive or not", alias="isComparisonCaseSensitive")
    __properties = ["left", "right", "allowableStringMappings", "isComparisonCaseSensitive"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GroupReconciliationCoreAttributeRule:
        """Create an instance of GroupReconciliationCoreAttributeRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of left
        if self.left:
            _dict['left'] = self.left.to_dict()
        # override the default output from pydantic by calling `to_dict()` of right
        if self.right:
            _dict['right'] = self.right.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in allowable_string_mappings (list)
        _items = []
        if self.allowable_string_mappings:
            for _item in self.allowable_string_mappings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['allowableStringMappings'] = _items
        # set to None if allowable_string_mappings (nullable) is None
        # and __fields_set__ contains the field
        if self.allowable_string_mappings is None and "allowable_string_mappings" in self.__fields_set__:
            _dict['allowableStringMappings'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GroupReconciliationCoreAttributeRule:
        """Create an instance of GroupReconciliationCoreAttributeRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GroupReconciliationCoreAttributeRule.parse_obj(obj)

        _obj = GroupReconciliationCoreAttributeRule.parse_obj({
            "left": GroupReconciliationCoreComparisonRuleOperand.from_dict(obj.get("left")) if obj.get("left") is not None else None,
            "right": GroupReconciliationCoreComparisonRuleOperand.from_dict(obj.get("right")) if obj.get("right") is not None else None,
            "allowable_string_mappings": [GroupReconciliationComparisonRuleStringValueMap.from_dict(_item) for _item in obj.get("allowableStringMappings")] if obj.get("allowableStringMappings") is not None else None,
            "is_comparison_case_sensitive": obj.get("isComparisonCaseSensitive")
        })
        return _obj

GroupReconciliationCoreAttributeRule.update_forward_refs()
