# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.group_reconciliation_dates import GroupReconciliationDates
from lusid.models.group_reconciliation_instance_id import GroupReconciliationInstanceId
from lusid.models.group_reconciliation_result_statuses import GroupReconciliationResultStatuses
from lusid.models.group_reconciliation_result_types import GroupReconciliationResultTypes
from lusid.models.group_reconciliation_review_statuses import GroupReconciliationReviewStatuses
from lusid.models.group_reconciliation_run_details import GroupReconciliationRunDetails
from lusid.models.link import Link
from lusid.models.resource_id import ResourceId

class GroupReconciliationSummary(BaseModel):
    """
    GroupReconciliationSummary
    """
    run_details: Optional[GroupReconciliationRunDetails] = Field(default=None, alias="runDetails")
    group_reconciliation_definition_id: Optional[ResourceId] = Field(default=None, alias="groupReconciliationDefinitionId")
    reconciliation_type:  StrictStr = Field(...,alias="reconciliationType", description="The type of reconciliation to perform. \"Holding\" | \"Transaction\" | \"Valuation\"") 
    instance_id: GroupReconciliationInstanceId = Field(alias="instanceId")
    dates_reconciled: GroupReconciliationDates = Field(alias="datesReconciled")
    reconciliation_run_as_at: datetime = Field(description="The date and time the reconciliation was run", alias="reconciliationRunAsAt")
    count_comparison_results: StrictInt = Field(description="The total number of comparison results with this InstanceId and ReconciliationType", alias="countComparisonResults")
    link_comparison_results: Optional[Link] = Field(default=None, alias="linkComparisonResults")
    result_types: Optional[GroupReconciliationResultTypes] = Field(default=None, alias="resultTypes")
    result_statuses: Optional[GroupReconciliationResultStatuses] = Field(default=None, alias="resultStatuses")
    review_statuses: Optional[GroupReconciliationReviewStatuses] = Field(default=None, alias="reviewStatuses")
    __properties = ["runDetails", "groupReconciliationDefinitionId", "reconciliationType", "instanceId", "datesReconciled", "reconciliationRunAsAt", "countComparisonResults", "linkComparisonResults", "resultTypes", "resultStatuses", "reviewStatuses"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GroupReconciliationSummary:
        """Create an instance of GroupReconciliationSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of run_details
        if self.run_details:
            _dict['runDetails'] = self.run_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of group_reconciliation_definition_id
        if self.group_reconciliation_definition_id:
            _dict['groupReconciliationDefinitionId'] = self.group_reconciliation_definition_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instance_id
        if self.instance_id:
            _dict['instanceId'] = self.instance_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dates_reconciled
        if self.dates_reconciled:
            _dict['datesReconciled'] = self.dates_reconciled.to_dict()
        # override the default output from pydantic by calling `to_dict()` of link_comparison_results
        if self.link_comparison_results:
            _dict['linkComparisonResults'] = self.link_comparison_results.to_dict()
        # override the default output from pydantic by calling `to_dict()` of result_types
        if self.result_types:
            _dict['resultTypes'] = self.result_types.to_dict()
        # override the default output from pydantic by calling `to_dict()` of result_statuses
        if self.result_statuses:
            _dict['resultStatuses'] = self.result_statuses.to_dict()
        # override the default output from pydantic by calling `to_dict()` of review_statuses
        if self.review_statuses:
            _dict['reviewStatuses'] = self.review_statuses.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GroupReconciliationSummary:
        """Create an instance of GroupReconciliationSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GroupReconciliationSummary.parse_obj(obj)

        _obj = GroupReconciliationSummary.parse_obj({
            "run_details": GroupReconciliationRunDetails.from_dict(obj.get("runDetails")) if obj.get("runDetails") is not None else None,
            "group_reconciliation_definition_id": ResourceId.from_dict(obj.get("groupReconciliationDefinitionId")) if obj.get("groupReconciliationDefinitionId") is not None else None,
            "reconciliation_type": obj.get("reconciliationType"),
            "instance_id": GroupReconciliationInstanceId.from_dict(obj.get("instanceId")) if obj.get("instanceId") is not None else None,
            "dates_reconciled": GroupReconciliationDates.from_dict(obj.get("datesReconciled")) if obj.get("datesReconciled") is not None else None,
            "reconciliation_run_as_at": obj.get("reconciliationRunAsAt"),
            "count_comparison_results": obj.get("countComparisonResults"),
            "link_comparison_results": Link.from_dict(obj.get("linkComparisonResults")) if obj.get("linkComparisonResults") is not None else None,
            "result_types": GroupReconciliationResultTypes.from_dict(obj.get("resultTypes")) if obj.get("resultTypes") is not None else None,
            "result_statuses": GroupReconciliationResultStatuses.from_dict(obj.get("resultStatuses")) if obj.get("resultStatuses") is not None else None,
            "review_statuses": GroupReconciliationReviewStatuses.from_dict(obj.get("reviewStatuses")) if obj.get("reviewStatuses") is not None else None
        })
        return _obj

GroupReconciliationSummary.update_forward_refs()
