# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.data_model_membership import DataModelMembership
from lusid.models.link import Link
from lusid.models.lusid_instrument import LusidInstrument
from lusid.models.model_property import ModelProperty
from lusid.models.relationship import Relationship
from lusid.models.resource_id import ResourceId
from lusid.models.settlement_cycle import SettlementCycle
from lusid.models.staged_modifications_info import StagedModificationsInfo
from lusid.models.version import Version

class Instrument(BaseModel):
    """
    A list of instruments.  # noqa: E501
    """
    href:  Optional[StrictStr] = Field(None,alias="href", description="The specific Uniform Resource Identifier (URI) for this resource at the requested effective and asAt datetime.") 
    scope:  Optional[StrictStr] = Field(None,alias="scope", description="The scope in which the instrument lies.") 
    lusid_instrument_id:  StrictStr = Field(...,alias="lusidInstrumentId", description="The unique LUSID Instrument Identifier (LUID) of the instrument.") 
    version: Version
    staged_modifications: Optional[StagedModificationsInfo] = Field(default=None, alias="stagedModifications")
    name:  StrictStr = Field(...,alias="name", description="The name of the instrument.") 
    identifiers: Dict[str, Optional[StrictStr]] = Field(description="The set of identifiers that can be used to identify the instrument.")
    properties: Optional[List[ModelProperty]] = Field(default=None, description="The requested instrument properties. These will be from the 'Instrument' domain.")
    lookthrough_portfolio: Optional[ResourceId] = Field(default=None, alias="lookthroughPortfolio")
    instrument_definition: Optional[LusidInstrument] = Field(default=None, alias="instrumentDefinition")
    state:  StrictStr = Field(...,alias="state", description="The state of of the instrument at the asAt datetime of this version of the instrument definition. The available values are: Active, Inactive, Deleted") 
    asset_class:  Optional[StrictStr] = Field(None,alias="assetClass", description="The nominal asset class of the instrument, e.g. InterestRates, FX, Inflation, Equities, Credit, Commodities, etc. The available values are: InterestRates, FX, Inflation, Equities, Credit, Commodities, Money, Unknown") 
    dom_ccy:  Optional[StrictStr] = Field(None,alias="domCcy", description="The domestic currency, meaning the currency in which the instrument would typically be expected to pay cashflows, e.g. a share in AAPL being USD.") 
    relationships: Optional[List[Relationship]] = Field(default=None, description="A set of relationships associated to the instrument.")
    settlement_cycle: Optional[SettlementCycle] = Field(default=None, alias="settlementCycle")
    data_model_membership: Optional[DataModelMembership] = Field(default=None, alias="dataModelMembership")
    links: Optional[List[Link]] = None
    __properties = ["href", "scope", "lusidInstrumentId", "version", "stagedModifications", "name", "identifiers", "properties", "lookthroughPortfolio", "instrumentDefinition", "state", "assetClass", "domCcy", "relationships", "settlementCycle", "dataModelMembership", "links"]

    @validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'Instrument' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse',
                                    'Library',
                                    'LibraryResponse',
                                    'DayRegularity',
                                    'RelativeMonthRegularity',
                                    'SpecificMonthRegularity',
                                    'WeekRegularity',
                                    'YearRegularity']:
           return value
        
        # Only validate the 'type' property of the class
        if "state" != "type":
            return value

        if value not in ['Active', 'Inactive', 'Deleted']:
            raise ValueError("must be one of enum values ('Active', 'Inactive', 'Deleted')")
        return value

    @validator('asset_class')
    def asset_class_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'Instrument' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse',
                                    'Library',
                                    'LibraryResponse',
                                    'DayRegularity',
                                    'RelativeMonthRegularity',
                                    'SpecificMonthRegularity',
                                    'WeekRegularity',
                                    'YearRegularity']:
           return value
        
        # Only validate the 'type' property of the class
        if "asset_class" != "type":
            return value

        if value is None:
            return value

        if value not in ['InterestRates', 'FX', 'Inflation', 'Equities', 'Credit', 'Commodities', 'Money', 'Unknown']:
            raise ValueError("must be one of enum values ('InterestRates', 'FX', 'Inflation', 'Equities', 'Credit', 'Commodities', 'Money', 'Unknown')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Instrument:
        """Create an instance of Instrument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of staged_modifications
        if self.staged_modifications:
            _dict['stagedModifications'] = self.staged_modifications.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item in self.properties:
                if _item:
                    _items.append(_item.to_dict())
            _dict['properties'] = _items
        # override the default output from pydantic by calling `to_dict()` of lookthrough_portfolio
        if self.lookthrough_portfolio:
            _dict['lookthroughPortfolio'] = self.lookthrough_portfolio.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instrument_definition
        if self.instrument_definition:
            _dict['instrumentDefinition'] = self.instrument_definition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in relationships (list)
        _items = []
        if self.relationships:
            for _item in self.relationships:
                if _item:
                    _items.append(_item.to_dict())
            _dict['relationships'] = _items
        # override the default output from pydantic by calling `to_dict()` of settlement_cycle
        if self.settlement_cycle:
            _dict['settlementCycle'] = self.settlement_cycle.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_model_membership
        if self.data_model_membership:
            _dict['dataModelMembership'] = self.data_model_membership.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if scope (nullable) is None
        # and __fields_set__ contains the field
        if self.scope is None and "scope" in self.__fields_set__:
            _dict['scope'] = None

        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        # set to None if dom_ccy (nullable) is None
        # and __fields_set__ contains the field
        if self.dom_ccy is None and "dom_ccy" in self.__fields_set__:
            _dict['domCcy'] = None

        # set to None if relationships (nullable) is None
        # and __fields_set__ contains the field
        if self.relationships is None and "relationships" in self.__fields_set__:
            _dict['relationships'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Instrument:
        """Create an instance of Instrument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Instrument.parse_obj(obj)

        _obj = Instrument.parse_obj({
            "href": obj.get("href"),
            "scope": obj.get("scope"),
            "lusid_instrument_id": obj.get("lusidInstrumentId"),
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "staged_modifications": StagedModificationsInfo.from_dict(obj.get("stagedModifications")) if obj.get("stagedModifications") is not None else None,
            "name": obj.get("name"),
            "identifiers": obj.get("identifiers"),
            "properties": [ModelProperty.from_dict(_item) for _item in obj.get("properties")] if obj.get("properties") is not None else None,
            "lookthrough_portfolio": ResourceId.from_dict(obj.get("lookthroughPortfolio")) if obj.get("lookthroughPortfolio") is not None else None,
            "instrument_definition": LusidInstrument.from_dict(obj.get("instrumentDefinition")) if obj.get("instrumentDefinition") is not None else None,
            "state": obj.get("state"),
            "asset_class": obj.get("assetClass"),
            "dom_ccy": obj.get("domCcy"),
            "relationships": [Relationship.from_dict(_item) for _item in obj.get("relationships")] if obj.get("relationships") is not None else None,
            "settlement_cycle": SettlementCycle.from_dict(obj.get("settlementCycle")) if obj.get("settlementCycle") is not None else None,
            "data_model_membership": DataModelMembership.from_dict(obj.get("dataModelMembership")) if obj.get("dataModelMembership") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

Instrument.update_forward_refs()
