# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.instrument import Instrument
from lusid.models.link import Link

class InstrumentEntity(BaseModel):
    """
    A list of instruments.  # noqa: E501
    """
    href:  StrictStr = Field(...,alias="href", description="The specific Uniform Resource Identifier (URI) for this resource at the requested effective and asAt datetime.") 
    entity_unique_id:  StrictStr = Field(...,alias="entityUniqueId", description="The unique id of the entity.") 
    as_at_version_number: Optional[StrictInt] = Field(default=None, description="The integer version number for the entity (the entity was created at version 1)", alias="asAtVersionNumber")
    status:  StrictStr = Field(...,alias="status", description="The status of the entity at the current time.") 
    as_at_deleted: Optional[datetime] = Field(default=None, description="The asAt datetime at which the entity was deleted.", alias="asAtDeleted")
    user_id_deleted:  Optional[StrictStr] = Field(None,alias="userIdDeleted", description="The unique id of the user who deleted the entity.") 
    request_id_deleted:  Optional[StrictStr] = Field(None,alias="requestIdDeleted", description="The unique request id of the command that deleted the entity.") 
    effective_at_created: Optional[datetime] = Field(default=None, description="The EffectiveAt this Entity is created, if entity does not currently exist in EffectiveAt.", alias="effectiveAtCreated")
    prevailing_instrument: Optional[Instrument] = Field(default=None, alias="prevailingInstrument")
    deleted_instrument: Optional[Instrument] = Field(default=None, alias="deletedInstrument")
    previewed_status:  Optional[StrictStr] = Field(None,alias="previewedStatus", description="The status of the previewed entity.") 
    previewed_instrument: Optional[Instrument] = Field(default=None, alias="previewedInstrument")
    links: Optional[List[Link]] = None
    __properties = ["href", "entityUniqueId", "asAtVersionNumber", "status", "asAtDeleted", "userIdDeleted", "requestIdDeleted", "effectiveAtCreated", "prevailingInstrument", "deletedInstrument", "previewedStatus", "previewedInstrument", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentEntity:
        """Create an instance of InstrumentEntity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of prevailing_instrument
        if self.prevailing_instrument:
            _dict['prevailingInstrument'] = self.prevailing_instrument.to_dict()
        # override the default output from pydantic by calling `to_dict()` of deleted_instrument
        if self.deleted_instrument:
            _dict['deletedInstrument'] = self.deleted_instrument.to_dict()
        # override the default output from pydantic by calling `to_dict()` of previewed_instrument
        if self.previewed_instrument:
            _dict['previewedInstrument'] = self.previewed_instrument.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if as_at_version_number (nullable) is None
        # and __fields_set__ contains the field
        if self.as_at_version_number is None and "as_at_version_number" in self.__fields_set__:
            _dict['asAtVersionNumber'] = None

        # set to None if as_at_deleted (nullable) is None
        # and __fields_set__ contains the field
        if self.as_at_deleted is None and "as_at_deleted" in self.__fields_set__:
            _dict['asAtDeleted'] = None

        # set to None if user_id_deleted (nullable) is None
        # and __fields_set__ contains the field
        if self.user_id_deleted is None and "user_id_deleted" in self.__fields_set__:
            _dict['userIdDeleted'] = None

        # set to None if request_id_deleted (nullable) is None
        # and __fields_set__ contains the field
        if self.request_id_deleted is None and "request_id_deleted" in self.__fields_set__:
            _dict['requestIdDeleted'] = None

        # set to None if effective_at_created (nullable) is None
        # and __fields_set__ contains the field
        if self.effective_at_created is None and "effective_at_created" in self.__fields_set__:
            _dict['effectiveAtCreated'] = None

        # set to None if previewed_status (nullable) is None
        # and __fields_set__ contains the field
        if self.previewed_status is None and "previewed_status" in self.__fields_set__:
            _dict['previewedStatus'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentEntity:
        """Create an instance of InstrumentEntity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentEntity.parse_obj(obj)

        _obj = InstrumentEntity.parse_obj({
            "href": obj.get("href"),
            "entity_unique_id": obj.get("entityUniqueId"),
            "as_at_version_number": obj.get("asAtVersionNumber"),
            "status": obj.get("status"),
            "as_at_deleted": obj.get("asAtDeleted"),
            "user_id_deleted": obj.get("userIdDeleted"),
            "request_id_deleted": obj.get("requestIdDeleted"),
            "effective_at_created": obj.get("effectiveAtCreated"),
            "prevailing_instrument": Instrument.from_dict(obj.get("prevailingInstrument")) if obj.get("prevailingInstrument") is not None else None,
            "deleted_instrument": Instrument.from_dict(obj.get("deletedInstrument")) if obj.get("deletedInstrument") is not None else None,
            "previewed_status": obj.get("previewedStatus"),
            "previewed_instrument": Instrument.from_dict(obj.get("previewedInstrument")) if obj.get("previewedInstrument") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

InstrumentEntity.update_forward_refs()
