# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.instrument_payment_diary_leg import InstrumentPaymentDiaryLeg
from lusid.models.link import Link
from lusid.models.version import Version

class InstrumentPaymentDiary(BaseModel):
    """
    A payment diary containing all the cashflows on a single instrument.  # noqa: E501
    """
    instrument_id_type:  Optional[StrictStr] = Field(None,alias="instrumentIdType", description="The identifier type of the instrument.") 
    instrument_id:  Optional[StrictStr] = Field(None,alias="instrumentId", description="The identifier for the instrument.") 
    instrument_scope:  Optional[StrictStr] = Field(None,alias="instrumentScope", description="The scope of the instrument.") 
    version: Optional[Version] = None
    legs: Optional[List[InstrumentPaymentDiaryLeg]] = Field(default=None, description="Aggregated sets of Cashflows.")
    href:  Optional[StrictStr] = Field(None,alias="href", description="The specific Uniform Resource Identifier (URI) for this resource at the requested effective and asAt datetime.") 
    links: Optional[List[Link]] = None
    __properties = ["instrumentIdType", "instrumentId", "instrumentScope", "version", "legs", "href", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentPaymentDiary:
        """Create an instance of InstrumentPaymentDiary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in legs (list)
        _items = []
        if self.legs:
            for _item in self.legs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['legs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if instrument_id_type (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_id_type is None and "instrument_id_type" in self.__fields_set__:
            _dict['instrumentIdType'] = None

        # set to None if instrument_id (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_id is None and "instrument_id" in self.__fields_set__:
            _dict['instrumentId'] = None

        # set to None if instrument_scope (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_scope is None and "instrument_scope" in self.__fields_set__:
            _dict['instrumentScope'] = None

        # set to None if legs (nullable) is None
        # and __fields_set__ contains the field
        if self.legs is None and "legs" in self.__fields_set__:
            _dict['legs'] = None

        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentPaymentDiary:
        """Create an instance of InstrumentPaymentDiary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentPaymentDiary.parse_obj(obj)

        _obj = InstrumentPaymentDiary.parse_obj({
            "instrument_id_type": obj.get("instrumentIdType"),
            "instrument_id": obj.get("instrumentId"),
            "instrument_scope": obj.get("instrumentScope"),
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "legs": [InstrumentPaymentDiaryLeg.from_dict(_item) for _item in obj.get("legs")] if obj.get("legs") is not None else None,
            "href": obj.get("href"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

InstrumentPaymentDiary.update_forward_refs()
