# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class InstrumentPaymentDiaryRow(BaseModel):
    """
    An individual row containing details of a single cashflow in the diary.  # noqa: E501
    """
    quantity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The quantity (amount) that will be paid. Note that this can be empty if the payment is in the future and a model is used that cannot estimate it.")
    currency:  Optional[StrictStr] = Field(None,alias="currency", description="The payment currency of the cash flow.") 
    payment_date: Optional[datetime] = Field(default=None, description="The date at which the given cash flow is due to be paid.", alias="paymentDate")
    pay_or_receive:  Optional[StrictStr] = Field(None,alias="payOrReceive", description="Does the cash flow belong to the Pay or Receive leg.") 
    accrual_start: Optional[datetime] = Field(default=None, description="The date on which accruals start for this cashflow.", alias="accrualStart")
    accrual_end: Optional[datetime] = Field(default=None, description="The date on which accruals end for this cashflow.", alias="accrualEnd")
    cash_flow_type:  Optional[StrictStr] = Field(None,alias="cashFlowType", description="The type of cashflow.") 
    is_cash_flow_determined: Optional[StrictBool] = Field(default=None, description="Is the cashflow determined as of the effective date time.", alias="isCashFlowDetermined")
    is_cash_flow_historic: Optional[StrictBool] = Field(default=None, description="Has the cashflow been paid, i.e. has it become a historic cashflow, as of the date and time pointed to be effectiveAt.", alias="isCashFlowHistoric")
    discount_factor: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Weighting factor to discount cashflow to the present value.", alias="discountFactor")
    discounted_expected_cash_flow_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The expected cashflow amount taking into account the discount factor.", alias="discountedExpectedCashFlowAmount")
    day_count_fraction: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The day count fraction, if appropriate.", alias="dayCountFraction")
    forward_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Forward rate for cash flow if appropriate. (as in for a rates fixed or floating leg)", alias="forwardRate")
    reset_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The value of the reset, if any.", alias="resetRate")
    spread: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The spread that exists on the payoff.")
    __properties = ["quantity", "currency", "paymentDate", "payOrReceive", "accrualStart", "accrualEnd", "cashFlowType", "isCashFlowDetermined", "isCashFlowHistoric", "discountFactor", "discountedExpectedCashFlowAmount", "dayCountFraction", "forwardRate", "resetRate", "spread"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentPaymentDiaryRow:
        """Create an instance of InstrumentPaymentDiaryRow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if currency (nullable) is None
        # and __fields_set__ contains the field
        if self.currency is None and "currency" in self.__fields_set__:
            _dict['currency'] = None

        # set to None if pay_or_receive (nullable) is None
        # and __fields_set__ contains the field
        if self.pay_or_receive is None and "pay_or_receive" in self.__fields_set__:
            _dict['payOrReceive'] = None

        # set to None if cash_flow_type (nullable) is None
        # and __fields_set__ contains the field
        if self.cash_flow_type is None and "cash_flow_type" in self.__fields_set__:
            _dict['cashFlowType'] = None

        # set to None if day_count_fraction (nullable) is None
        # and __fields_set__ contains the field
        if self.day_count_fraction is None and "day_count_fraction" in self.__fields_set__:
            _dict['dayCountFraction'] = None

        # set to None if forward_rate (nullable) is None
        # and __fields_set__ contains the field
        if self.forward_rate is None and "forward_rate" in self.__fields_set__:
            _dict['forwardRate'] = None

        # set to None if reset_rate (nullable) is None
        # and __fields_set__ contains the field
        if self.reset_rate is None and "reset_rate" in self.__fields_set__:
            _dict['resetRate'] = None

        # set to None if spread (nullable) is None
        # and __fields_set__ contains the field
        if self.spread is None and "spread" in self.__fields_set__:
            _dict['spread'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentPaymentDiaryRow:
        """Create an instance of InstrumentPaymentDiaryRow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentPaymentDiaryRow.parse_obj(obj)

        _obj = InstrumentPaymentDiaryRow.parse_obj({
            "quantity": obj.get("quantity"),
            "currency": obj.get("currency"),
            "payment_date": obj.get("paymentDate"),
            "pay_or_receive": obj.get("payOrReceive"),
            "accrual_start": obj.get("accrualStart"),
            "accrual_end": obj.get("accrualEnd"),
            "cash_flow_type": obj.get("cashFlowType"),
            "is_cash_flow_determined": obj.get("isCashFlowDetermined"),
            "is_cash_flow_historic": obj.get("isCashFlowHistoric"),
            "discount_factor": obj.get("discountFactor"),
            "discounted_expected_cash_flow_amount": obj.get("discountedExpectedCashFlowAmount"),
            "day_count_fraction": obj.get("dayCountFraction"),
            "forward_rate": obj.get("forwardRate"),
            "reset_rate": obj.get("resetRate"),
            "spread": obj.get("spread")
        })
        return _obj

InstrumentPaymentDiaryRow.update_forward_refs()
