# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.legal_entity import LegalEntity
from lusid.models.person import Person

class Investor(BaseModel):
    """
    Representation of an Investor on the LUSID API  # noqa: E501
    """
    investor_type:  Optional[StrictStr] = Field(None,alias="investorType", description="The type of the Investor") 
    identifiers: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="The identifiers of the Investor")
    entity_unique_id:  Optional[StrictStr] = Field(None,alias="entityUniqueId", description="The unique Investor entity identifier") 
    person: Optional[Person] = None
    legal_entity: Optional[LegalEntity] = Field(default=None, alias="legalEntity")
    __properties = ["investorType", "identifiers", "entityUniqueId", "person", "legalEntity"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Investor:
        """Create an instance of Investor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict['person'] = self.person.to_dict()
        # override the default output from pydantic by calling `to_dict()` of legal_entity
        if self.legal_entity:
            _dict['legalEntity'] = self.legal_entity.to_dict()
        # set to None if investor_type (nullable) is None
        # and __fields_set__ contains the field
        if self.investor_type is None and "investor_type" in self.__fields_set__:
            _dict['investorType'] = None

        # set to None if identifiers (nullable) is None
        # and __fields_set__ contains the field
        if self.identifiers is None and "identifiers" in self.__fields_set__:
            _dict['identifiers'] = None

        # set to None if entity_unique_id (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_unique_id is None and "entity_unique_id" in self.__fields_set__:
            _dict['entityUniqueId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Investor:
        """Create an instance of Investor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Investor.parse_obj(obj)

        _obj = Investor.parse_obj({
            "investor_type": obj.get("investorType"),
            "identifiers": obj.get("identifiers"),
            "entity_unique_id": obj.get("entityUniqueId"),
            "person": Person.from_dict(obj.get("person")) if obj.get("person") is not None else None,
            "legal_entity": LegalEntity.from_dict(obj.get("legalEntity")) if obj.get("legalEntity") is not None else None
        })
        return _obj

Investor.update_forward_refs()
