# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.workspace_item import WorkspaceItem

class ItemAndWorkspace(BaseModel):
    """
    An item plus its containing workspace name.  # noqa: E501
    """
    workspace_name:  StrictStr = Field(...,alias="workspaceName", description="A workspace's name.") 
    workspace_item: WorkspaceItem = Field(alias="workspaceItem")
    __properties = ["workspaceName", "workspaceItem"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ItemAndWorkspace:
        """Create an instance of ItemAndWorkspace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of workspace_item
        if self.workspace_item:
            _dict['workspaceItem'] = self.workspace_item.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ItemAndWorkspace:
        """Create an instance of ItemAndWorkspace from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ItemAndWorkspace.parse_obj(obj)

        _obj = ItemAndWorkspace.parse_obj({
            "workspace_name": obj.get("workspaceName"),
            "workspace_item": WorkspaceItem.from_dict(obj.get("workspaceItem")) if obj.get("workspaceItem") is not None else None
        })
        return _obj

ItemAndWorkspace.update_forward_refs()
